<?php
echo form_open_multipart("shop_admin/layout_specific_data_save", array("id" => "layout_specific_data_form", "class" => "nvForm"));
echo form_hidden("layout_specific_data_id", $layout_specific_data->layout_specific_data_id);
echo form_hidden("key", $layout_specific_data->key);
csrf();
?>
<div class="row">
	<div class="<?php echo(TOP_LEFT); ?>">
		<h2>Edit Layout Specific Data Field</h2>
	</div>
	<div class="<?php echo(TOP_RIGHT); ?>">
		<button type="submit" name="submit_action" id="submit" value="close" class="btn btn-primary"><em class="fas fa-save" aria-hidden="true"></em> Save &amp; Close</button>
		<button type="submit" name="submit_action" id="submit2" value="continue" class="btn btn-primary"><em class="fas fa-save" aria-hidden="true"></em> Save &amp; Continue</button>
		<a href="/shop_admin/layout_specific_data_list" class="btn btn-secondary"><em class="fas fa-times" aria-hidden="true"></em> Cancel</a>
	</div>
</div>

<div class="<?php echo(TWO_COL); ?>">
	<div class="form-row mb-2">
		<label for="layout_id" class="<?php echo(LABEL_COL); ?>">Layout</label>

		<div class="<?php echo(FIELD_COL); ?>">
			<?php
			$wgt = new FeralBasicSelectWidget("layout_id", $layout_specific_data->layout_id, "form-control custom-select");

			foreach($layouts as $layout)
			{
				$wgt->AddOption($layout->product_layout_id, $layout->layout_name);
			}
			$wgt->Create();
			?>
		</div>
	</div>

	<div class="form-row mb-2">
		<label for="data_name" class="<?php echo(LABEL_COL); ?>">Field Name</label>

		<div class="<?php echo(FIELD_COL); ?>">
			<?php
			echo form_input(array(
			              "name"        => "data_name",
			              "id"          => "data_name",
			              "value"       => $layout_specific_data->data_name,
			              "placeholder" => 'Label for this field',
			              "required"	=> "required",
			              "class" 		=> "form-control"
			            ));
			?>
		</div>
	</div>

	<div class="form-row mb-2">
		<label for="datatype" class="<?php echo(LABEL_COL); ?>">Data Type</label>

		<div class="<?php echo(FIELD_COL); ?>">
			<?php
			$wgt = new FeralBasicSelectWidget("datatype", $layout_specific_data->datatype, "form-control custom-select");
			$wgt->AddOption("text", "Standard Text Field");
			$wgt->AddOption("textarea", "Large Text Field");
			$wgt->AddOption("number", "Number");
			$wgt->AddOption("email", "Email Address");
			$wgt->AddOption("tel", "Phone Number");
			$wgt->AddOption("file", "File Download");
			$wgt->AddOption("url", "URL");
			$wgt->Create();
			?>
		</div>
	</div>

	<div class="form-row mb-2">
		<label for="search_filter" class="<?php echo(LABEL_COL); ?>">Search Filter</label>

		<div class="<?php echo(FIELD_COL); ?>"><?php yesNo("search_filter", $layout_specific_data->search_filter); ?></div>
	</div>

	<div class="form-row mb-2">
		<label for="sort" class="<?php echo(LABEL_COL); ?>">Sort Value</label>

		<div class="<?php echo(FIELD_COL); ?>">
			<?php
			echo form_input(array(
			              "name"        => "sort",
			              "id"          => "sort",
			              "value"       => $layout_specific_data->sort,
			              "type"		=> "number",
			              "min"			=> "0",
			              "step"		=> "1",
			              "class" 		=> "form-control"
			            ));
			?>
		</div>
	</div>
</div>
<?php
echo form_close();
