<div class="row">
	<div class="<?php echo(TOP_LEFT); ?>">
		<h2>Layout Specific Data</h2>
	</div>

	<div class="<?php echo(TOP_RIGHT); ?>">
		<a href="/shop_admin/layout_specific_data?id=0" class="btn btn-primary"><em class="fas fa-shopping-cart" aria-hidden="true"></em> Add New Field</a>
	</div>
</div>

<table id="list" class="<?php echo(ADMIN_TABLE); ?>"></table>

<script>
	jQuery(window).on("load", function()
	{
		jQuery("#list").DataTable(
	    {
			"pagingType": "full_numbers",
			"processing": true,
			"serverSide": false,
			"ajax": "/ajax/get_shop_layout_specific_data",
			"pageLength": 50,
			"order": [[0,'asc'], [1,'asc']],
			"stateSave": true,
			"columns": [
		        { "data": "layout_name", "title": "Layout", "width": "30%", "className": "click", "searchable": true},
		        { "data": "data_name", "title": "Field Name", "width": "30%", "className": "click", "searchable": true},
		        { "data": "key", "title": "Key", "width": "15%", "className": "click", "searchable": true},
		        { "data": "datatype", "title": "Type", "width": "5%", "className": "click", "searchable": true},
		        { "data": "search_filter", "title": "Search Filter", "width": "5%", "className": "click", "searchable": true,
		        	"render": function(data, x, row)
			        {
			        	if(data == "1")
	                    {
	                    	return "Yes";
	                    }
	                    else
	                    {
	                    	return "No";
	                    }
			        }},
		        { "data": "sort", "title": "Sort", "width": "5%", "className": "click", "searchable": true},
		        { "data": "layout_specific_data_id", "title": "Actions", "className": "text-right", "width": "10%", "orderable": false, "searchable": false,
		        	"render": function(data, x, row)
			        {
			        	var buttons = '<div class="nowrap">';
	                    buttons += '<a href="#" title="Delete" class="btn btn-sm btn-danger" onclick="warning(\'Are you sure?\', \'This field will be removed from ANY and ALL products which are using it! You probably do not want to do this.\', true, function() { window.location=\'/shop_admin/layout_specific_data_delete?id=' + data + '\'; }); return false;"><em class="far fa-fw fa-trash-alt" aria-hidden="true"></em></a>';
	                    buttons += '</div>';

	                    return buttons;
			        }}
		    ],
			'drawCallback': function()
			{
				table_hover("#list", "/shop_admin/layout_specific_data?id={id}");
			}
		});
	});
</script>
