<link rel="stylesheet" href="https://unpkg.com/purecss@1.0.0/build/pure-min.css" integrity="sha384-nn4HPE8lTHyVtfCBi5yW9d20FjT8BJwUXyWZT9InLYax14RDjBj46LmSztkmNP9w" crossorigin="anonymous">
<?php
$products 		= unserialize($order->products);
$product_text 	= array();
$product_qty 	= array();
$product_price 	= array();
$count = 0;

foreach($products as $item)
{
	$options = unserialize($item->product_options);
	$deposit = ($item->deposit_price > 0);

	$product_qty[$count] 	= $item->quantity;
	$product_price[$count] 	= $item->price;
	$product_text[$count] 	= $item->product_name . ($item->variant ? " (" . $item->variant . ")" : "");

	if(is_array($options) && count($options) > 0)
	{
		foreach($options as $option)
		{
			$extra = 0;

			switch($option->option_type)
			{
				case "radio":
				case "select":
				{
					$option_values = explode("\n", $option->option_values);

					foreach($option_values as $option_value)
					{
						$values = explode("|", $option_value);

						if(count($values) < 2)
						{
							continue;
						}
						$extra = number_format($item->quantity * ($values[2] ? $values[2] : 0), 2);
					}

					break;
				}
				default:
				{
					$extra = ($item->quantity * $option->price_change);
				}
			}

			if($deposit)
			{
				$extra = 0;
			}

			if($option->option_type == "checkbox")
			{
				$option_label = "<br />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;* " . $option->option_label . ($extra > 0 ? " (+$" . $extra . ")" : "");
			}
			else
			{
				$option_label = "<br />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;* " . $option->option_label . ": " . $option->option_value . ($extra > 0 ? " (+$" . $extra . ")" : "");
			}

			$product_text[$count] .= $option_label;
			$product_price[$count] += $extra;
		}
	}
	$count++;
}

$taxes = unserialize($order->taxes);
$tax_text = array();
$count = 0;
$subtotal_plus_shipping = $order->order_subtotal + $order->shipping_total;

foreach($taxes as $tax)
{
	$tax_text[$tax->tax_name] = number_format($subtotal_plus_shipping * $tax->tax_percentage, 2);
	$count++;
}
?>
<h2>Order Information</h2>
<table width="100%" border="0" class="pure-table pure-table-striped">
	<tbody>
		<tr><td><b>Date:</b></td><td><?php echo(date("M jS, Y", strtotime($order->order_date))); ?></td></tr>
		<tr><td><b>Order Number:</b></td><td><?php echo($order->order_id); ?></td></tr>
		<tr><td><b>Transaction ID:</b></td><td><?php echo($order->txn_id); ?></td></tr>
		<tr><td><b>Status:</b></td><td><?php echo($order->order_status_name); ?></td></tr>

		<?php
		if($order->ship_date != "0000-00-00 00:00:00")
		{
			?><tr><td><b>Shipped:</b></td><td><?php echo(date("M jS \a\\t g:i A T", strtotime($order->ship_date))); ?></td></tr><?php
		}
		?>
		<tr>
			<td><b>Ship To:</b></td>
			<td>
				<?php echo($order->customer_name); ?>
				<br /><?php echo($order->customer_address); ?>
				<br /><?php echo($order->customer_city); ?>, <?php echo($order->customer_province); ?>&nbsp;&nbsp;<?php echo($order->customer_postalcode); ?>
				<br /><?php echo($order->customer_country); ?>
			</td>
		</tr>
		<tr><td><b>Phone:</b></td><td><?php echo($order->customer_phone); ?></td></tr>
		<tr><td><b>Email:</b></td><td><?php echo($order->customer_email); ?></td></tr>
		<tr><td><b>Payment Method:</b></td><td><?php echo($order->payment_gateway_name); ?></td></tr>
		<tr><td><b>Payment Received?</b></td><td><?php echo($order->paid ? 'Yes' : 'No'); ?></td></tr>
		<tr><td><b>Shipping Method:</b></td><td><?php echo(($order->shipping_gateway_service ? $order->shipping_gateway_service : $order->shipping_gateway_name)); ?></td></tr>
	</tbody>
</table>
<p>&nbsp;</p>

<table width="100%" border="0" class="pure-table pure-table-striped">
	<thead><th>Item</th><th>Quantity</th><th>Price</th><th>Total</th></thead>

	<tbody>
		<?php
		for($i=0; $i<count($product_text); $i++)
		{
			?>
			<tr>
				<td><?php echo($product_text[$i]); ?></td>
				<td><?php echo($product_qty[$i]); ?></td>
				<td>$<?php echo(number_format($product_price[$i], 2)); ?></td>
				<td>$<?php echo(number_format($product_qty[$i] * $product_price[$i], 2)); ?></td>
			</tr>
			<?php
		}
		?>

		<tr><td colspan="3" style="text-align: right;"><b>Subtotal:</b></td><td>$<?php echo(number_format($order->order_subtotal, 2)); ?></td></tr>
		<tr><td colspan="3" style="text-align: right;"><b>Shipping:</b></td><td>$<?php echo(number_format($order->shipping_total, 2)); ?></td></tr>
		<?php
		foreach($tax_text as $tax=>$value)
		{
			?><tr><td colspan="3"><b><?php echo($tax); ?>:</b></td><td>$<?php echo($value); ?></td></tr><?php
		}
		?>
		<tr><td colspan="3" style="text-align: right;"><b>Total:</b></td><td>$<?php echo(number_format($order->order_total, 2)); ?></td></tr>
	</tbody>
</table>
