<h2>Payment Gateways</h2>
<table id="payment-gateways" class="<?php echo(ADMIN_TABLE); ?>"></table>

<h2>Shipping Gateways</h2>
<table id="shipping-gateways" class="<?php echo(ADMIN_TABLE); ?>"></table>

<script>
	jQuery(window).on("load", function()
	{
		jQuery("#payment-gateways").DataTable(
	    {
			"pagingType": "full_numbers",
			"processing": true,
			"serverSide": false,
			"ajax": "/ajax/get_shop_payment_gateways",
			"pageLength": 50,
			"order": [[2,'desc'], [0,'asc']],
			"stateSave": true,
			"columns": [
		        { "data": "gateway_name", "title": "Name", "width": "30%", "className": "click", "searchable": true},
		        { "data": "configuration", "title": "Configuration", "width": "60%", "className": "click", "searchable": true,
		    		"render": function(data, x, row)
		    		{
		    			return data.replace(/\n/g, "<br>");
		    		}},
		        { "data": "enabled", "title": "Enabled", "width": "10%", "className": "click", "searchable": true,
		        	"render": function(data, x, row)
			        {
			        	if(data == "1")
	                    {
	                    	return "Yes";
	                    }
	                    else
	                    {
	                    	return "No";
	                    }
			        }}
		    ],
			'drawCallback': function()
			{
				table_hover("#payment-gateways", "/shop_admin/payment_gateway/{id}");
			}
		});

		jQuery("#shipping-gateways").DataTable(
	    {
			"pagingType": "full_numbers",
			"processing": true,
			"serverSide": false,
			"ajax": "/ajax/get_shop_shipping_gateways",
			"pageLength": 50,
			"order": [[2,'desc'], [0,'asc']],
			"stateSave": true,
			"columns": [
		        { "data": "gateway_name", "title": "Name", "width": "30%", "className": "click", "searchable": true},
		        { "data": "configuration", "title": "Configuration", "width": "60%", "className": "click", "searchable": true,
		    		"render": function(data, x, row)
		    		{
		    			return data.replace(/\n/g, "<br>");
		    		}},
		        { "data": "enabled", "title": "Enabled", "width": "10%", "className": "click", "searchable": true,
		        	"render": function(data, x, row)
			        {
			        	if(data == "1")
	                    {
	                    	return "Yes";
	                    }
	                    else
	                    {
	                    	return "No";
	                    }
			        }}
		    ],
			'drawCallback': function()
			{
				table_hover("#shipping-gateways", "/shop_admin/shipping_gateway/{id}");
			}
		});
	});
</script>
