<div class="row">
	<div class="<?php echo(TOP_LEFT); ?>">
		<h2>Orders</h2>
	</div>
	<div class="<?php echo(TOP_RIGHT); ?>">
		<a href="#" title="Batch Change Status" id="batch_status" class="btn btn-primary"><em class="fab fa-dropbox" aria-hidden="true"></em> Update Status</a>
	</div>
</div>

<table id="list" class="<?php echo(ADMIN_TABLE); ?>"></table>

<div id="shop-order-status-dialog" class="dialog">
	<p class="center bold">This will update ALL selected orders.</p>

	<form id="shop-order-status-dialog-form" method="post" action="">
		<?php csrf(); ?>
		<input type="hidden" name="order_ids" id="order_ids" value="" />

		<div class="form-control mb-2">
			<label for="new_status_id" class="<?php echo(LABEL_COL); ?>">New Status</label>

			<div class="<?php echo(FIELD_COL); ?>">
				<?php
				$wgt = new FeralBasicSelectWidget("new_status_id", "", "form-control custom-select");

				foreach($statuses as $status)
				{
					$wgt->AddOption($status->order_status_id, $status->order_status_name);
				}
				$wgt->Create();
				?>
			</div>
		</div>

		<div class="form-control mb-2">
			<label for="paid" class="<?php echo(LABEL_COL); ?>">Payment Status</label>
			<div class="<?php echo(FIELD_COL); ?>"><?php yesNo("paid", "", "Paid", "Not Paid"); ?></div>
		</div>

		<div class="form-control mb-2">
			<label for="tracking_number1" class="<?php echo(LABEL_COL); ?>">Tracking # 1</label>
			<div class="<?php echo(FIELD_COL); ?>">
				<?php
				FeralText("tracking_number1", "", "form-control");
				?>
			</div>
		</div>

		<div class="form-control mb-2">
			<label for="tracking_number2" class="<?php echo(LABEL_COL); ?>">Tracking # 2</label>
			<div class="<?php echo(FIELD_COL); ?>">
				<?php
				FeralText("tracking_number2", "", "form-control");
				?>
			</div>
		</div>

		<div class="form-control mb-2">
			<label for="tracking_number3" class="<?php echo(LABEL_COL); ?>">Tracking # 3</label>
			<div class="<?php echo(FIELD_COL); ?>">
				<?php
				FeralText("tracking_number3", "", "form-control");
				?>
			</div>
		</div>

		<div class="text center">
			<button type="submit" class="btn btn-primary"><em class="fas fa-save" aria-hidden="true"></em> Save</button>
			<button type="button" class="btn" onclick="jQuery('#shop-order-status-dialog').dialog('close');"><em class="fas fa-times" aria-hidden="true"></em> Cancel</button>
		</div>
	</form>
</div>

<script>
	jQuery(window).on("load", function()
	{
		jQuery("#list").DataTable(
	    {
			"pagingType": "full_numbers",
			"processing": true,
			"serverSide": true,
			"ajax": "/ajax/get_shop_orders",
			"pageLength": 50,
			"order": [[0,'desc']],
			"stateSave": true,
			"columns": [
		        { "data": "order_date", "title": "Date", "width": "20%", "className": "click", "searchable": true,
		        	"render": function(data, x, row)
			        {
			        	var d = new Date(data);

	                    return d.toDateString() + " at " + d.toLocaleTimeString();
			        }},
		        { "data": "order_id", "title": "Order #", "width": "10%", "className": "click", "searchable": true},
		        { "data": "customer_name", "title": "Customer", "width": "25%", "className": "click", "searchable": true},
		        { "data": "order_total", "title": "Total", "width": "10%", "className": "click", "searchable": true,
		        	"render": function(data, x, row)
			        {
			        	return "$" + number_format(data, 2);
			        }},
		        { "data": "paid", "title": "Paid", "width": "5%", "className": "click", "searchable": true,
		        	"render": function(data, x, row)
			        {
			        	return (data == 1 ? '<em class="fas fa-fw fa-check green"></em> Yes' : '<em class="fas fa-fw fa-times red"></em> No');
			        }},
		        { "data": "order_status_name", "title": "Status", "width": "15%", "className": "click", "searchable": true},
		        { "data": "order_id", "title": "Actions", "width": "10%", "className": "click text-right", "searchable": true,
		        	"render": function(data, x, row)
			        {
			        	var buttons = '<div class="nowrap">';
	                    buttons += '<a href="/shop_admin/order?id=' + data + '" class="btn btn-sm btn-primary"><em class="fas fa-fw fa-eye" aria-hidden="true"></em></a>';
	                    buttons += '</div>';

	                    return buttons;
			        }},
		        { "data": "order_id", "title": '<input type="checkbox" onchange="shopSelectAllOrders(this);" />', "width": "5%", "orderable": false, "searchable": false,
		        	"render": function(data, x, row)
			        {
			        	var buttons = '<div class="nowrap">';
	                    buttons += '<input type="checkbox" id="shop_order_' + data + '" class="shop_order_checkbox" value="1" />';
	                    buttons += '</div>';

	                    return buttons;
			        }}
		    ],
			'drawCallback': function()
			{
				table_hover("#list", "/shop_admin/order?id={id}");
			}
		});

		jQuery("#batch_status").click(function()
		{
			var checked_ids = shop_get_selected_orders();

			if(checked_ids == false)
			{
				error("Nothing Selected", "No orders are selected.", true, null);
			}
			else
			{
				shopOrderStatusDialog();
			}
		});
	});
</script>
