<?php
$this->load->helper('url');

if($pagination_total > 0)
{
	$getvars = $this->input->get(NULL, TRUE);
	$postvars = $this->input->post(NULL, TRUE);
	$postvars = array_merge(is_array($postvars) ? $postvars : array(), is_array($getvars) ? $getvars : array());
	$pagination_link_extras = "";

	if($this->input->get_post("shop_q") != "")
	{
		$pagination_link_extras .= "&shop_q=" . rawurlencode($this->input->get_post("shop_q"));
	}
	else if($this->input->get_post("shop_q_part_ids") != "")
	{
		$pagination_link_extras .= "&shop_q_part_ids=" . rawurlencode($this->input->get_post("shop_q_part_ids"));
	}

	//automatically add any values starting with shop_filter to our query to preserve our filters
	foreach($postvars as $key=>$value)
	{
		if(stripos($key, "shop_filter") !== false || stripos($key, "shop_part") !== false)
		{
			$pagination_link_extras .= "&" . $key . "=" . $value;
		}
	}

	$pagination_back_link = current_url() . "?page=" . ($pagination_current_page-1) . $pagination_link_extras;
	$pagination_next_link = current_url() . "?page=" . ($pagination_current_page+1) . $pagination_link_extras;

	if($pagination_show_summary)
	{
		$pagination_max = $pagination_offset + $pagination_perpage;
		?>
		<div class="shop_pagination_summary">
			<p><?php echo($pagination_total); ?> Products Found</p>
			<!-- <p>Page <?php echo($pagination_current_page); ?> of <?php echo($pagination_pages); ?></p> -->
			<p>Showing <?php echo($pagination_offset+1); ?> to <?php echo($pagination_max <= $pagination_total ? $pagination_max : $pagination_total); ?></p>
		</div>
		<?php
	}

	if($pagination_pages > 1)
	{
		?>
		<ul class="shop_pagination pure-paginator">
			<?php
			if($pagination_current_page > 1)
			{
				?><li><a rel="prev" class="shop_pagination_link shop_pagination_link_prev pure-button pure-button-secondary prev" href="<?php echo($pagination_back_link); ?>">&lt;&lt;</a></li><?php
			}

			$first_page = 1;
			$last_page = $pagination_pages;

			if($pagination_pages > 8)
			{
				$first_page = $pagination_current_page-4;
				$last_page = $pagination_current_page+4;

				if($first_page < 1)
				{
					$last_page += ($first_page * -1);
					$first_page = 1;
				}
				else if(($last_page+4) > $pagination_pages)
				{
					$first_page = $pagination_current_page - (4 - ($pagination_current_page - $last_page));
					$last_page = $pagination_current_page;
				}

			}

			for($i=$first_page; $i<=$last_page; $i++)
			{
				$pagination_link = current_url() . "?page=$i" . $pagination_link_extras;
				$active_page = ($i == $pagination_current_page);

				?><li><a class="shop_pagination_link shop_pagination_page_link pure-button pure-button-secondary <?php echo($active_page ? "shop_pagination_link_active pure-button-active" : ""); ?>" href="<?php echo($pagination_link); ?>"><?php echo($i); ?></a></li><?php
			}

			if($pagination_current_page < $pagination_pages)
			{
				?><li><a rel="next" class="shop_pagination_link shop_pagination_link_next pure-button pure-button-secondary next" href="<?php echo($pagination_next_link); ?>">&gt;&gt;</a></li><?php
			}
			?>
		</div>
		<?php
	}
}
else
{
	if($pagination_show_summary)
	{
		?>
		<div class="shop_pagination_summary">
			<p>No Products Were Found Matching Your Search</p>
		</div>
		<?php
	}
}
?>
