<?php
$configs = explode("\n", $my_gateway->configuration);
$configuration = array();

foreach($configs as $config)
{
	if($config != "")
	{
		$line = explode("=", $config, 2);
		$configuration[$line[0]] = $line[1];
	}
}
?>
<script src="https://js.stripe.com/v2/"></script>
<script type="text/javascript">
	jQuery(function()
	{
		// When the main form is submitted, submit our PayPal form too.
		// The PayPal form will open in a new window, so both will process properly.
		jQuery("#shop_cart_billing_shipping").off("submit").on("submit", function(e)
		{
			Stripe.setPublishableKey("<?php echo($configuration["public_key"]); ?>");

			if(jQuery("#stripe-form:visible").size() == 1 && jQuery("#payment_stripe_token").val() == "")
			{
				e.preventDefault();
				jQuery("#shop_continue").prop("disabled", true);
				jQuery("#shop_continue").attr("title", "Validating Credit Card...");
				jQuery("#stripe-submit").click();

				// Request a token from Stripe:
				Stripe.card.createToken(jQuery('#stripe-form'), function(status, response)
				{
					jQuery("#shop_continue").removeAttr("disabled");
					jQuery("#shop_continue").removeAttr("title");

					if(status == 200)
					{
						jQuery("#payment_stripe_token").val(response.id);
						jQuery("#shop_cart_billing_shipping").submit();
					}
					else
					{
						error("Error Validating Credit Card", response.error.message, true, null);
					}
				});
			}
		});
	});
</script>

<input type="hidden" id="payment_stripe_token" name="payment_stripe_token" value="<?php echo((isset($payment_vars["payment_stripe_token"]) ? $payment_vars["payment_stripe_token"] : "")); ?>" />

<form action="" method="POST" id="stripe-form" class="pure-form pure-form-aligned" onsubmit="return false;">
	<span class="payment-errors"></span>

	<div class="pure-control-group">
		<label>Card Number</label>
		<input type="text" size="20" maxlength="19" data-stripe="number" required />
	</div>

	<div class="pure-control-group">
		<label>Expiration (MM/YY)</label>
		<input type="text" size="2" maxlength="2" data-stripe="exp_month" required /><input type="text" size="2" maxlength="2" data-stripe="exp_year" required />
	</div>

	<div class="pure-control-group">
		<label>CVC</label>
		<input type="text" size="6" maxlength="4" data-stripe="cvc" />
	</div>

	<div class="pure-control-group">
		<label>Billing Postal Code</label>
		<input type="text" size="6" maxlength="6" data-stripe="address_zip" />
	</div>
	<input type="submit" id="stripe-submit" style="display: none;" />
</form>
