<script async src="/modules/galleria/galleria/galleria-1.4.2.min.js"></script>

<div class="pure-g">
	<div class="pure-u-1 pure-u-lg-1-2">
		<div class="padded">
			<div id="galleria">
				<?php
				$product_images = array_unique(array_merge(array($product->image_filename), $product_extra_images));

				if(count($product_images))
				{
					process_thumbnails($product_images, $layout->product_image_width, $layout->product_image_height);
					process_thumbnails($product_images, $layout->extra_image_width, $layout->extra_image_height);

					foreach($product_images as $image)
					{
						$fullimage 		= preg_replace('/\.(jpe?g|png|gif|bmp|JPE?G|PNG|GIF|BMP)$/', "_" . $layout->product_image_width . "x" . $layout->product_image_height . '.\1', $image);
						$retina_image 	= preg_replace('/\.(jpe?g|png|gif|bmp|JPE?G|PNG|GIF|BMP)$/', '@2x.\1', $fullimage);
						$thumb 			= preg_replace('/\.(jpe?g|png|gif|bmp|JPE?G|PNG|GIF|BMP)$/', "_" . $layout->extra_image_width . "x" . $layout->extra_image_height . '.\1', $image);
						$retina_thumb 	= preg_replace('/\.(jpe?g|png|gif|bmp|JPE?G|PNG|GIF|BMP)$/', '@2x.\1', $thumb);

						if(file_exists(ABSOLUTE_PATH . "/images/shop/resized/" . $fullimage) && file_exists(ABSOLUTE_PATH . "/images/shop/resized/" . $thumb))
						{
							$size = @getimagesize(ABSOLUTE_PATH . "/images/shop/resized/" . $fullimage);

							?>
							<a href="<?php echo(LIVE_SITE); ?>/images/shop/resized/<?php echo($fullimage); ?>">
								<img
				                    src="<?php echo(LIVE_SITE); ?>/images/shop/resized/<?php echo($thumb); ?>"
				                    data-big="<?php echo(LIVE_SITE); ?>/images/shop/resized/<?php echo($fullimage); ?>"
				                    data-title=""
				                    data-description=""
				                >
							</a>
							<?php
	            		}
					}
				}
				?>
			</div>
		</div>
	</div>

	<div class="pure-u-1 pure-u-lg-1-2">
		<div class="padded">
			<?php
			/*
			if($product->price > 0 && $product->call_for_price == 0 && $product->price > 0)
			{
				?><h2 class="shop_product_price"><?php echo("$" . number_format($product->price, 2) . " " . $product->currency_code); ?></h2><?php
			}
			else if($product->call_for_price == 1 || $product->price <= 0)
			{
				?><h2 class="shop_product_price">Call For Price</h2><?php
			}
			*/
			?>

			<div class="shop_product_short_description"><?php echo($product->product_short_description); ?>
			<?php
				if(!empty($product->product_short_description))
				{
					?>
					<hr />
					<?php
				}
			?>
			</div>

			<?php
			$price_obj = new StdClass();
			$price_obj->data_name = "Price";

			if($product->call_for_price || $product->price <= 0)
			{
				$price_obj->data_value = "Call For Price";
			}
			else
			{
				$price_obj->data_value = "$" . number_format($product->price, 2) . " " . $product->currency_code;
			}

			$total_trailer_specs = 1;
			$total_trailer_files = 0;
			$options_to_display = array($price_obj);
			$files_to_display = array();

			foreach($layout_specific_options as $option)	//this list contains everything, we want to count only those which will be displayed
			{
				if($option->data_value)
				{
					if($option->datatype == "file")
					{
						$files_to_display[] = $option;
						$total_trailer_files++;
					}
					else
					{
						$options_to_display[] = $option;
						$total_trailer_specs++;
					}
				}
			}

			if($total_trailer_specs > 0)
			{
				?>
				<h2>Product Information</h2>
				<div class="pure-g">
					<?php
					foreach($options_to_display as $option)
					{
						?>
						<div class="pure-u-1 pure-u-sm-1-2"><b><?php echo($option->data_name); ?></b></div>
						<div class="pure-u-1 pure-u-sm-1-2"><?php echo($option->data_value); ?></div>
						<?php
					}
					?>
				</div>
				<?php
			}

			if($total_trailer_files > 0)
			{
				?>
				<h3>Downloads</h3>
				<div class="pure-g">
					<?php
					foreach($files_to_display as $option)
					{
						if(substr($option->data_value, 0, 4) == "http")
						{
							$link = $option->data_value;
						}
						else
						{
							$link = LIVE_SITE . $option->data_value;
						}
						?>

						<div class="pure-u-1 pure-u-sm-1-2"><b><a href="<?php echo($link); ?>" target="_blank" class="pure-button pure-button-secondary" title="Download"><em class="far fa-file-alt" aria-hidden="true"></em></a></b></div>
						<div class="pure-u-1 pure-u-sm-1-2"><?php echo($option->data_name); ?></div>
						<?php
					}
					?>
				</div>
				<?php
			}
			?>

			<?php
			if($layout->allow_purchase && $product->call_for_price == 0 && $product->price > 0)
			{
				?>
				<h4>Buy Now:</h4>
				<form name="shop_add_to_cart" id="shop_add_to_cart" class="pure-form pure-form-aligned" method="post" action="<?php echo($cart_url); ?>">
					<?php
					csrf();
					FeralHidden("task", "add");
					FeralHidden("product_id", $product->product_id);

					foreach($product_options as $option)
					{
						?>
						<div>
							<?php
							if($option->option_description)
							{
								?><div class="shop_product_option_description"><?php echo($option->option_description); ?></div><?php
							}
							?>
							<label for="option_<?php echo($option->product_option_id); ?>">
								<?php
								echo($option->option_label);

								if($option->price_change != 0)
								{
									echo(str_replace("+$-", "-$", " (+$" . $option->price_change . ")"));
								}
								?>
							</label>
							<?php
							switch($option->option_type)
							{
								default:
								case "text":
								{
									?>
									<input type="text" name="option_<?php echo($option->product_option_id); ?>" id="option_<?php echo($option->product_option_id); ?>" <?php echo($option->option_required ? "required" : ""); ?> />
									<?php
									break;
								}
								case "textarea":
								{
									?>
									<textarea name="option_<?php echo($option->product_option_id); ?>" id="option_<?php echo($option->product_option_id); ?>" <?php echo($option->option_required ? "required" : ""); ?>></textarea>
									<?php
									break;
								}
								case "number":
								{
									?>
									<input type="number" name="option_<?php echo($option->product_option_id); ?>" id="option_<?php echo($option->product_option_id); ?>" <?php echo($option->option_required ? "required" : ""); ?> />
									<?php
									break;
								}
								case "checkbox":
								{
									?>
									<input type="checkbox" name="option_<?php echo($option->product_option_id); ?>" id="option_<?php echo($option->product_option_id); ?>" <?php echo($option->option_required ? "required" : ""); ?> />
									<?php
									break;
								}
								case "radio":
								{
									$option_values = explode("\n", $option->option_values);

									foreach($option_values as $option_value)
									{
										$values = explode("|", $option_value);

										if(count($values) < 2)
										{
											continue;
										}
										$label = $values[0];
										$value = $values[1];
										$price_change = number_format(($values[2] ? $values[2] : 0), 2);

										?>
										<input type="radio" name="option_<?php echo($option->product_option_id); ?>" id="option_value_<?php echo($option->product_option_id); ?>" value="<?php echo($value); ?>" <?php echo($option->option_required ? "required" : ""); ?> />&nbsp;<?php echo($label . ($price_change != 0 ? str_replace("+$-", "-$", " (+$" . $price_change . ")") : "")); ?>&nbsp;&nbsp;&nbsp;
										<?php
									}

									break;
								}
								case "select":
								{
									$option_values = explode("\n", $option->option_values);

									?>
									<select name="option_<?php echo($option->product_option_id); ?>" id="option_<?php echo($option->product_option_id); ?>" <?php echo($option->option_required ? "required" : ""); ?>>

										<option value="">Select Value</option>
										<?php
										foreach($option_values as $option_value)
										{
											$values = explode("|", $option_value);
											if(count($values) < 2)
											{
												continue;
											}
											$label = $values[0];
											$value = $values[1];
											$price_change = number_format(($values[2] ? $values[2] : 0), 2);

											?>
											<option value="<?php echo($value); ?>"><?php echo($label . ($price_change != 0 ? str_replace("+$-", "-$", " (+$" . $price_change . ")") : "")); ?></option>
											<?php
										}
										?>
									</select>
									<?php

									break;
								}
							}
							?>
						</div>
						<?php
					}

					if(count($related_products) > 0)
					{
						?>
						<h3>Related Products</h3>

						<div class="pure-g shop_products shop_related_products">
							<?php
							foreach($related_products as $related_product)
							{
								?>
								<div class="pure-u-1-3">
									<?php $this->load->view("shop/product_snapshot_default", array("product" => $product, "layout" => $layout, "show_category" => false, "show_usd" => true)); ?>
								</div>
								<?php
							}
							?>
						</div>
						<?php
					}
					?>
					<div class="pure-g">
						<div class="pure-u-1 pure-u-sm-1-2 pure-u-lg-2-3">
							<label for="quantity">Qty</label>
							<input type="number" name="quantity" id="quantity" value="1" min="1" class="quantity" required />
						</div>
						<div class="pure-u-1 pure-u-sm-1-2 pure-u-lg-1-3">
							<button type="submit" class="pure-button pure-button-primary"><em class="fas fa-fw fa-shopping-cart" aria-hidden="true"></em> Add To Cart</button>
						</div>
					</div>
				</form>
				<?php
			}
			?>
		</div>
	</div>

	<?php
	if(!empty($product->product_description))
	{
		?>
		<div class="pure-u-1">
			<div class="shop_product_description">
			<hr />
			<h3>Full Description</h3>
			<?php echo($product->product_description); ?>
			</div>
		</div>
		<?php
	}
	?>
</div>

<div itemscope itemtype="http://schema.org/Product" style="display:none;">
	<a itemprop="url" href="<?php echo(current_url()); ?>">
		<div itemprop="name"><?php echo($product->product_name); ?></div>
	</a>
	<div itemprop="description"><?php echo($product->product_short_description); ?></div>
	<span itemprop="productID"><?php echo($product->product_id); ?></span>
	<?php
	if($layout->allow_purchase && $product->call_for_price == 0 && $product->price > 0)
	{
		?>
		<div itemprop="offers" itemscope itemtype="http://schema.org/Offer">
			<span itemprop="price"><?php echo($product->price); ?></span>
		</div>
		<?php
	}
	?>
</div>

<script>
jQuery(window).on("load", function()
{
	// Load the classic theme
    Galleria.loadTheme('<?php echo(LIVE_SITE); ?>/modules/galleria/galleria/themes/classic/galleria.classic.min.js');

    // Initialize Galleria
    Galleria.run('#galleria',
	{
		autoplay: true,
		carousel: true,
		carouselSpeed: 200,
		carouselSteps: 1,
		height: 0,
		width: 0,
		//imagePosition: 'top center',
		thumbnails: true,
		thumbPosition: 'top right',
		transition: 'slide',
		transitionSpeed: 400,
		imageCrop: false,
		responsive: true
	});
});
</script>
