<script>
	var existing_files_select_options = "<?php echo(addslashes($files_options)); ?>";
</script>

<div ng-controller="ProductController" ng-cloak>
	<?php
	echo form_open_multipart("shop_admin/product_save", array("id" => "product_form", "class" => "nvForm"));
	echo form_hidden("product_id", $product->product_id);
	csrf();

	FeralHidden("datasource_id", $product->datasource_id);
	FeralHidden("datasource_product_id", $product->datasource_product_id);
	FeralHidden("datasource_hash", $product->datasource_hash);
	FeralHidden("last_modified", $product->last_modified);
	FeralHidden("last_datasource_update", $product->last_datasource_update);
	FeralHidden("default_tab", ($default_tab != "" ? $default_tab : "0"));
	FeralHidden("product_image_id", $product->product_image_id);
	?>
	<div class="row">
		<div class="<?php echo(TOP_LEFT); ?>">
			<h2>Edit Product</h2>
		</div>
		<div class="<?php echo(TOP_RIGHT); ?>">
			<button type="submit" name="submit_action" id="submit" value="close" class="btn btn-primary"><em class="fas fa-save" aria-hidden="true"></em> Save &amp; Close</button>
			<button type="submit" name="submit_action" id="submit2" value="continue" class="btn btn-primary"><em class="fas fa-save" aria-hidden="true"></em> Save &amp; Continue</button>
			<a href="/shop_admin/products" class="btn btn-secondary"><em class="fas fa-times" aria-hidden="true"></em> Cancel</a>
		</div>
	</div>

	<div class="nv-tabs">
		<nav class="nv-tabs-nav">
			<ul>
				<li><a href=".nv-tab-info" class="nv-tab-link"><em class="far fa-fw fa-edit" aria-hidden="true"></em> Basic Information</a></li>
				<li><a href=".nv-tab-prices" class="nv-tab-link"><em class="fas fa-fw fa-dollar-sign" aria-hidden="true"></em> Prices</a></li>
				<li><a href=".nv-tab-images" class="nv-tab-link"><em class="fas fa-fw fa-camera" aria-hidden="true"></em> Images</a></li>
				<li><a href=".nv-tab-details" class="nv-tab-link"><em class="fas fa-fw fa-cogs" aria-hidden="true"></em> Layout Specific Options</a></li>
				<li><a href=".nv-tab-categories" class="nv-tab-link"><em class="fas fa-fw fa-sitemap" aria-hidden="true"></em> Categories</a></li>
				<?php
				// Only Jensen Trailers uses this, but this allows them to update safely.
				if(file_exists(APPLICATION_PATH . "/models/shop/Shop_product_size.php"))
				{
					?><li><a href="#tabs-sizes" class="nv-tab-link"><em class="fas fa-fw fa-balance-scale" aria-hidden="true"></em> Sizes</a></li><?php
				}
				if(count($years))
				{
					?><li><a href="#tabs-vehicles" class="nv-tab-link"><em class="fas fa-fw fa-car" aria-hidden="true"></em> Vehicles</a></li><?php
				}
				?>
			</ul>
		</nav>

		<div class="nv-tab">
			<div class="nv-tab-content nv-tab-info">
				<div class="row">
					<div class="<?php echo(TWO_COL); ?>">
						<?php
						if(count($sites) > 1)
						{
							?>
							<div class="form-row mb-2">
								<label for="site_id" class="<?php echo(LABEL_COL); ?>">Site</label>

								<div class="<?php echo(FIELD_COL); ?>">
									<?php
									$wgt = new FeralBasicSelectWidget("site_id", ($product->site_id ? $product->site_id : Mainframe::active_site_id()), "form-control custom-select");

									foreach($sites as $site)
									{
										$wgt->AddOption($site->site_id, $site->name);
									}
									$wgt->Create();
									?>
								</div>
							</div>
							<?php
						}
						else
						{
							echo form_hidden("site_id", ($product->site_id ? $product->site_id : Mainframe::active_site_id()));
						}
						?>

						<div class="form-row mb-2">
							<label for="product_name" class="<?php echo(LABEL_COL); ?>">Product Name</label>

							<div class="<?php echo(FIELD_COL); ?>">
								<?php
								echo form_input(array(
								              "name"        => "product_name",
								              "id"          => "product_name",
								              "value"       => $product->product_name,
								              "placeholder" => 'Product Name',
								              "required"	=> "required",
								              "onblur"		=> "updateURL(this, 'url', null, " . ($product->product_id ? 'false' : 'true') . ");",
								              "class" 		=> "form-control"
								            ));
								?>
							</div>
						</div>

						<div class="form-row mb-2">
							<label for="url" class="<?php echo(LABEL_COL); ?>">URL</label>

							<div class="<?php echo(FIELD_COL); ?>">
								<?php
								echo form_input(array(
								              "name"        => "url",
								              "id"          => "url",
								              "value"       => $product->url,
								              "placeholder" => "The URL will display in the address bar of the user's web browser.",
								              "title"		=> "Please enter a URL using only letters, numbers, dashes, underscores, or forward slashes.  Do not include '.html' in your URL.",
								              "pattern"		=> "[A-Za-z0-9/\-_]*",
								              "onkeyup"		=> "jQuery('#url_preview').html(this.value)",
								              "class" 		=> "form-control"
								            ));
								?>
							</div>
						</div>

						<div class="form-row mb-2">
							<label class="<?php echo(LABEL_COL); ?>"></label>
							<div class="<?php echo(FIELD_COL); ?>"><div class="alert alert-info"><?php echo(LIVE_SITE); ?>/shop/{main category URL}/<span id="url_preview"><?php echo($product->url); ?></span></div></div>
						</div>

						<div class="form-row mb-2">
							<label for="page_title" class="<?php echo(LABEL_COL); ?>">Page Title</label>

							<div class="<?php echo(FIELD_COL); ?>">
								<?php
								echo form_input(array(
								              "name"        => "page_title",
								              "id"          => "page_title",
								              "value"       => $product->page_title,
								              "class" 		=> "form-control"
								            ));
								?>
							</div>
						</div>

						<div class="form-row mb-2">
							<label for="sku" class="<?php echo(LABEL_COL); ?>">SKU</label>

							<div class="<?php echo(FIELD_COL); ?>">
								<?php
								echo form_input(array(
								              "name"        => "sku",
								              "id"          => "sku",
								              "value"       => $product->sku,
								              "placeholder" => "SKU or part #.",
								              "class" 		=> "form-control"
								            ));
								?>
							</div>
						</div>

						<div class="form-row mb-2">
							<label for="product_layout_id" class="<?php echo(LABEL_COL); ?>">Layout</label>

							<div class="<?php echo(FIELD_COL); ?>">
								<?php
								//TODO: set default to main category layout
								$wgt = new FeralBasicSelectWidget("product_layout_id", $product->product_layout_id, "form-control custom-select");
								$wgt->SetAttribute("onchange", "get_layout_options(this.value, " . ($product->product_id ? $product->product_id : 0) . ", 'layout_specific_data');");

								foreach($layouts as $layout)
								{
									$wgt->AddOption($layout->product_layout_id, $layout->layout_name);
								}
								$wgt->Create();
								?>
							</div>
						</div>

						<div class="form-row mb-2">
							<label for="by_order_only" class="<?php echo(LABEL_COL); ?>">By Order Only</label>
							<div class="<?php echo(FIELD_COL); ?>"><?php yesNo("by_order_only", (isset($product->product_id) && $product->product_id > 0 ? $product->by_order_only : "0")); ?></div>
						</div>

						<div class="form-row mb-2">
							<label for="out_of_stock" class="<?php echo(LABEL_COL); ?>">Out of Stock</label>
							<div class="<?php echo(FIELD_COL); ?>"><?php yesNo("out_of_stock", (isset($product->product_id) && $product->product_id > 0 ? $product->out_of_stock : "0")); ?></div>
						</div>

						<div class="form-row mb-2">
							<label for="shipping_tbd" class="<?php echo(LABEL_COL); ?>">Shipping TBD</label>
							<div class="<?php echo(FIELD_COL); ?>"><?php yesNo("shipping_tbd", (isset($product->product_id) && $product->product_id > 0 ? $product->shipping_tbd : "0")); ?></div>
						</div>

						<div class="form-row mb-2">
							<label for="shipping_na" class="<?php echo(LABEL_COL); ?>">Shipping N/A</label>
							<div class="<?php echo(FIELD_COL); ?>"><?php yesNo("shipping_na", (isset($product->product_id) && $product->product_id > 0 ? $product->shipping_na : "0")); ?></div>
						</div>

						<div class="form-row mb-2">
							<label for="published" class="<?php echo(LABEL_COL); ?>">Published</label>
							<div class="<?php echo(FIELD_COL); ?>"><?php yesNo("published", (isset($product->product_id) && $product->product_id > 0 ? $product->published : "1")); ?></div>
						</div>
					</div>

					<div class="<?php echo(TWO_COL); ?>">
						<div class="alert alert-info">Use inches and pounds. 1 cm = 0.393701 inches / 1 kg = 2.20462 lbs</div>

						<div class="form-row mb-2">
							<label for="shipping_length" class="<?php echo(LABEL_COL); ?>">Shipping Length</label>

							<div class="<?php echo(FIELD_COL); ?>">
								<?php
								echo form_input(array(
								              "name"        => "shipping_length",
								              "id"          => "shipping_length",
								              "value"       => $product->shipping_length,
								              "placeholder" => '13',
								              "type" 		=> 'number',
								              "step"		=> 0.01,
				              				  "min"			=> 0,
								              "class"		=> "form-control"
								            ));
								?>
							</div>
						</div>

						<div class="form-row mb-2">
							<label for="shipping_width" class="<?php echo(LABEL_COL); ?>">Shipping Width</label>

							<div class="<?php echo(FIELD_COL); ?>">
								<?php
								echo form_input(array(
								              "name"        => "shipping_width",
								              "id"          => "shipping_width",
								              "value"       => $product->shipping_width,
								              "placeholder" => '13',
								              "type" 		=> 'number',
								              "step"		=> 0.01,
				              				  "min"			=> 0,
								              "class"		=> "form-control"
								            ));
								?>
							</div>
						</div>

						<div class="form-row mb-2">
							<label for="shipping_height" class="<?php echo(LABEL_COL); ?>">Shipping Height</label>

							<div class="<?php echo(FIELD_COL); ?>">
								<?php
								echo form_input(array(
								              "name"        => "shipping_height",
								              "id"          => "shipping_height",
								              "value"       => $product->shipping_height,
								              "placeholder" => '13',
								              "type" 		=> 'number',
								              "step"		=> 0.01,
				              				  "min"			=> 0,
								              "class"		=> "form-control"
								            ));
								?>
							</div>
						</div>

						<div class="form-row mb-2">
							<label for="shipping_weight" class="<?php echo(LABEL_COL); ?>">Shipping Weight</label>

							<div class="<?php echo(FIELD_COL); ?>">
								<?php
								echo form_input(array(
								              "name"        => "shipping_weight",
								              "id"          => "shipping_weight",
								              "value"       => $product->shipping_weight,
								              "placeholder" => '13',
								              "type" 		=> 'number',
								              "step"		=> 0.01,
				              				  "min"			=> 0,
								              "class"		=> "form-control"
								            ));
								?>
							</div>
						</div>

						<div class="form-row mb-2">
							<label for="meta_description" class="<?php echo(LABEL_COL); ?>">Meta Description</label>

							<div class="<?php echo(FIELD_COL); ?>">
								<?php FeralTextArea("meta_description", $product->meta_description, "form-control"); ?>
							</div>
						</div>

						<div class="form-row mb-2">
							<label for="sort_priority" class="<?php echo(LABEL_COL); ?>">Sort Priority</label>

							<div class="<?php echo(FIELD_COL); ?>">
								<?php
								$wgt = new FeralTextWidget("sort_priority", $product->sort_priority, "form-control");
								$wgt->SetAttribute("type", "number");
								$wgt->SetAttribute("min", "0");
								$wgt->SetAttribute("step", "1");
								$wgt->Create();
								?>
							</div>
						</div>

						<div class="form-row mb-2">
							<label for="<?php echo("corner_tag_" . $product->corner_tag); ?>" class="<?php echo(LABEL_COL); ?>">Corner Tag</label>

							<div class="<?php echo(FIELD_COL); ?>">
								<?php
								$wgt = new FeralRadioWidget("corner_tag", "0", ($product->corner_tag > 0 ? $product->corner_tag : "0"));
								$wgt->SetAttribute("id", "corner_tag_");
								$wgt->Create();
								echo(" <label for='corner_tag_' class='inline'>None</label><br>");

								$wgt = new FeralRadioWidget("corner_tag", "1", $product->corner_tag);
								$wgt->SetAttribute("id", "corner_tag_1");
								$wgt->Create();
								echo(" <label for='corner_tag_1' class='inline'>NEW</label><br>");

								$wgt = new FeralRadioWidget("corner_tag", "2", $product->corner_tag);
								$wgt->SetAttribute("id", "corner_tag_2");
								$wgt->Create();
								echo(" <label for='corner_tag_2' class='inline'>BEST SELLER</label><br>");

								$wgt = new FeralRadioWidget("corner_tag", "3", $product->corner_tag);
								$wgt->SetAttribute("id", "corner_tag_3");
								$wgt->Create();
								echo(" <label for='corner_tag_3' class='inline'>LIMITED INVENTORY</label><br>");

								$wgt = new FeralRadioWidget("corner_tag", "4", $product->corner_tag);
								$wgt->SetAttribute("id", "corner_tag_4");
								$wgt->Create();
								echo(" <label for='corner_tag_4' class='inline'>CLEARANCE PRICE</label><br>");

								$wgt = new FeralRadioWidget("corner_tag", "5", $product->corner_tag);
								$wgt->SetAttribute("id", "corner_tag_5");
								$wgt->Create();
								echo(" <label for='corner_tag_5' class='inline'>IN STORE SPECIAL</label><br>");

								$wgt = new FeralRadioWidget("corner_tag", "6", $product->corner_tag);
								$wgt->SetAttribute("id", "corner_tag_6");
								$wgt->Create();
								echo(" <label for='corner_tag_6' class='inline'>IN STOCK</label>");
								?>
							</div>
						</div>
					</div>

					<div class="col-12">
						<div class="form-row mb-2">
							<label for="product_description" class="col-12">Full Description</label>

							<div class="col-12">
								<?php FeralTextArea("product_description", $product->product_description, "form-control"); ?>
							</div>
						</div>

						<div class="form-row mb-2">
							<label for="product_short_description" class="col-12">Short Description</label>

							<div class="col-12">
								<?php
								FeralTextArea("product_short_description", $product->product_short_description, "form-control");
								?>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>

		<div class="nv-tab">
			<div class="nv-tab-content nv-tab-prices">
				<div class="row">
					<div class="<?php echo(TWO_COL); ?>">
						<fieldset>
							<legend>General Price Information</legend>

							<div class="form-row mb-2">
								<label for="deposit_price" class="<?php echo(LABEL_COL); ?>">Deposit Price</label>

								<div class="<?php echo(FIELD_COL); ?>">
									<?php
									echo form_input(array(
									              "name"        => "deposit_price",
									              "id"          => "deposit_price",
									              "value"       => number_format($product->deposit_price, 2, ".", ""),
									              "placeholder" => '250.00',
									              "type" 		=> 'number',
									              "step"		=> 0.01,
									              "min"			=> 0,
								              	  "class" 		=> "form-control"
									            ));
									?>
								</div>
							</div>

							<div class="form-row mb-2">
								<label for="cost" class="<?php echo(LABEL_COL); ?>">Our Cost</label>

								<div class="<?php echo(FIELD_COL); ?>">
									<?php
									echo form_input(array(
									              "name"        => "cost",
									              "id"          => "cost",
									              "value"       => $product->cost,
									              "placeholder" => '29.99',
									              "type" 		=> 'number',
									              "step"		=> 0.01,
									              "min"			=> 0,
								              	  "class" 		=> "form-control"
									            ));
									?>
								</div>
							</div>

							<div class="form-row mb-2">
								<label for="price_lock" class="<?php echo(LABEL_COL); ?>">Price Lock</label>

								<div class="<?php echo(FIELD_COL); ?>">
									<?php yesNo("price_lock", (isset($product->product_id) && $product->product_id > 0 ? $product->price_lock : "0")); ?>
								</div>
							</div>

							<div class="form-row mb-2">
								<label for="call_for_price" class="<?php echo(LABEL_COL); ?>">Call For Price</label>

								<div class="<?php echo(FIELD_COL); ?>">
									<?php yesNo("call_for_price", (isset($product->product_id) && $product->product_id > 0 ? $product->call_for_price : "0")); ?>
								</div>
							</div>
						</fieldset>
					</div>

					<div class="<?php echo(TWO_COL); ?>">
						<fieldset>
							<legend>Product Variants</legend>

							<input type="hidden" name="product_variants" ng-value="product.variants | json" />
							<input type="hidden" name="product_prices" ng-value="product.prices | json" />
							<div class="alert alert-info" ng-if="product.variants.length == 0">No product variants defined.</div>

							<div ng-repeat="v in product.variants | orderBy:'sort' track by v.product_variant_id">
								<a href="#" ng-click="removeVariant(v.product_variant_id)"><em class="fas fa-fw fa-times"></em></a>
								<a href="#" ng-click="variantUp(v.product_variant_id)" ng-show="!$first"><em class="fas fa-fw fa-arrow-up"></em></a>
								<em class="fas fa-fw" ng-show="$first"></em>
								<a href="#" ng-click="variantDown(v.product_variant_id)" ng-show="!$last"><em class="fas fa-fw fa-arrow-down"></em></a>
								<em class="fas fa-fw" ng-show="$last"></em>
								{{v.variant}}
							</div>
							<div class="form-row">
								<div class="col-10"><input name="new_variant" id="new_variant" ng-model="new_variant" ng-keypress="addVariantKeyboard($event)" placeholder="New Variant" class="form-control" /></div>
								<div class="col-2"><button type="button" class="btn btn-secondary" ng-click="addVariant()"><em class="fas fa-plus"></em></button></div>
							</div>
						</fieldset>
					</div>

					<div ng-repeat="s in shopper_groups" class="<?php echo(TWO_COL); ?>">
						<fieldset>
							<legend>{{s.group_name}} Prices</legend>

							<div class="form-row mb-2" ng-repeat="p in product.prices" ng-if="s.shopper_group_id == p.shopper_group_id">
								<label class="<?php echo(LABEL_COL); ?>">{{p.variant}}</label>
								<div class="<?php echo(FIELD_COL); ?>"><input type="number" name="" id="" ng-model="p.price" min="0" step="0.01" class="form-control" /></div>
							</div>
						</fieldset>
					</div>

					<div class="col-12"><div class="alert alert-danger">A price of zero for any product variant will disable that product variant for the specific shopper group.</div></div>
				</div>
			</div>
		</div>

		<div class="nv-tab">
			<div class="nv-tab-content nv-tab-images">
				<div class="alert alert-info">Upload your highest resolution images.  The system will resize and optimize them as required.</div>

				<h2>Main Image</h2>

				<div class="form-row mb-2">
					<?php
					if(isset($product->product_image_id) && $product->product_image_id > 0 && $product->image_filename != "")
					{
						$new_filename = preg_replace('/\.(jpe?g|png|gif|bmp|JPE?G|PNG|GIF|BMP)$/', '_200x125.\1', $product->image_filename);

						?><img src="/images/shop/resized/<?php echo($new_filename); ?>" style="width: 200px; height: auto;" alt="Current Image" /><br /><?php
					}
					?><label for="main_product_image" class="<?php echo(LABEL_COL); ?>">Upload Image</label><?php
					?>
					<div class="<?php echo(FIELD_COL); ?>"><input type="file" name="main_product_image" id="main_product_image" /></div>
				</div>

				<h2>Additional Images</h2>
				<h3>New Image</h3>

				<?php
				for($i=1; $i<=5; $i++)
				{
					?>
					<div class="form-row mb-2">
						<label for="<?php echo("extra_product_image_" . $i); ?>" class="<?php echo(LABEL_COL); ?>">Upload Image</label>
						<div class="<?php echo(FIELD_COL); ?>"><input type="file" name="extra_product_image_<?php echo($i); ?>" id="extra_product_image_<?php echo($i); ?>" /></div>
					</div>
					<?php
				}
				?>

				<div class="clear"></div>

				<h3>Existing Images</h3>
				<input type="hidden" name="image-sort" id="image-sort" />

				<ul class="sortable-images">
					<?php
					foreach($extra_images as $image)
					{
						if($image->image_id == $product->product_image_id)
						{
							continue;
						}

						$image_data["select_id"] = "image_id_$image->image_id";
						$image_data["selected_value"] = $image->image_id;

						$new_filename = preg_replace('/\.(jpe?g|png|gif|bmp|JPE?G|PNG|GIF|BMP)$/', '_200x125.\1', $image->filename);

						?>
						<li class="shop_photo" data-image-id="<?php echo($image->image_id); ?>">
							<a class="shop_remove_photo" href="#" onclick="remove_product_image(this, <?php echo($image->image_id); ?>); return false;"><em class="fas fa-fw fa-times-circle" aria-hidden="true"></em></a>
							<img src="/images/shop/resized/<?php echo($new_filename); ?>" width="200" align="left" />
						</li>
						<?php
					}
					?>
				</ul>
				<div class="clear"></div>
			</div>
		</div>

		<div class="nv-tab">
			<div class="nv-tab-content nv-tab-details">
				<div id="layout_specific_data"></div>
			</div>
		</div>

		<div class="nv-tab">
			<div class="nv-tab-content nv-tab-categories">
				<div class="alert alert-info text-center">
					Select the product's primary category using the first column of radio buttons.
					<hr>
					Select any additional categories using the second column of check boxes.
				</div>

				<div class="row">
					<div class="<?php echo(TWO_COL); ?>">
						<div class="form-row mb-2 smallText">
							<label for="main_category_id" class="<?php echo(LABEL_COL); ?>">Main Category:</label>

							<div class="<?php echo(FIELD_COL); ?>">
								<?php
								usort($categories, "shop_sort_categories");

								$wgt = new FeralBasicSelectWidget("main_category_id", $product->main_category_id, "form-control custom-select");
								$wgt->SetAttribute("required", "required");
								$wgt->SetAttribute("onchange", "select_shop_categories(this.value);");
								$wgt->AddOption("", "Choose Main Category");

								foreach($categories as $cat)
								{
									$wgt->AddOption($cat->category_id, ($cat->category_path_string ? htmlentities($cat->category_path_string) : $cat->category_name));
								}
								$wgt->Create();
								?>
							</div>
						</div>
					</div>

					<div class="<?php echo(TWO_COL); ?>">
						<div class="smalltext">
							<h3>Additional Categories (optional)</h3>
							<?php
							// $total_categories = count($categories);
							// $per_column = ceil($total_categories/2);
							// $count = 0;

							foreach($categories as $cat)
							{
								FeralCheckBox("category_id_" . $cat->category_id, $cat->checked, "category_id_checkbox");

								echo(" <label for='category_id_" . $cat->category_id . "_checkbox'>" . ($cat->category_path_string ? htmlentities($cat->category_path_string) : $cat->category_name) . "</label><br />");
							}
							?>
						</div>
					</div>
				</div>
			</div>
		</div>

		<?php
		// Only Jensen Trailers uses this, but this allows them to update safely.
		if(file_exists(APPLICATION_PATH . "/models/shop/Shop_product_size.php"))
		{
			?>
			<div class="nv-tab">
				<div class="nv-tab-content nv-tab-sizes">
					<div class="row">
						<?php
						$last_heading 	= "";
						$box_open 		= false;

						foreach($sizes as $size)
						{
							if($last_heading != $size->heading)
							{
								if($box_open)
								{
									?></div><?php
									$box_open = false;
								}
								?>
								<div class="<?php echo(THREE_COL); ?>">
									<p><b><? echo($size->heading); ?></b></p>
								<?php
								$box_open = true;
							}

							?>
							<div class="form-row mb-2">
								<?php FeralCheckbox("size_" . $size->product_size_id, $size->checked); ?>
								<label class="inline" for="size_<?php echo($size->product_size_id); ?>_checkbox"><?php echo($size->size); ?></label>
							</div>
							<?php
							$last_heading = $size->heading;
						}

						if($box_open)
						{
							?></div><?php
						}
						?>
					</div>
				</div>
			</div>
			<?php
		}

		if(count($years))
		{
			?>
			<div class="nv-tab">
				<div class="nv-tab-content nv-tab-vehicles">
					<div class="row">
						<div class="<?php echo(TWO_COL); ?>">
							<h4>Years</h4>

							<div class="scroller" id="years-list">
								<?php
								foreach($years as $year)
								{
									?>
									<div>
										<input type="checkbox" class="year" id="year_<?php echo($year->year); ?>" />
										<label for="year_<?php echo($year->year); ?>"><?php echo($year->year); ?></label>
									</div>
									<?php
								}
								?>
							</div>
						</div>

						<div class="<?php echo(TWO_COL); ?>">
							<h4>Makes</h4>

							<div class="scroller" id="makes-list"></div>
						</div>

						<div class="<?php echo(TWO_COL); ?>">
							<h4>Models</h4>

							<div class="scroller" id="models-list"></div>
						</div>

						<div class="<?php echo(TWO_COL); ?>">
							<h4>Styles</h4>

							<div class="scroller" id="styles-list"></div>
						</div>

						<div class="<?php echo(TWO_COL); ?>">
							<h4>Vehicles</h4>

							<div class="scroller" id="vehicles-list"></div>
						</div>
					</div>
				</div>

				<h3>Vehicles Already Linked To This Product</h3>
				<table id="existing-vehicle-list"></table>
				<div class="clear"></div>
			</div>
			<?php
		}
		?>
	</div>
	<?php
	echo form_close();
	?>
</div>

<style>
	#tabs-vehicles
	{
		background: #F4F4F4;
		border: 1px solid #AAAAAA;
		margin: 0 5px;

		-webkit-border-radius: 10px;
		-moz-border-radius: 10px;
		-ms-border-radius: 10px;
		border-radius: 10px;
	}

	#tabs-vehicles h4
	{
		margin-top: 0px;
		padding-top: 0px;
		text-align: center;
	}

	#tabs-vehicles .scroller
	{
		font-size: 0.8em;
		overflow-y: auto;
		overflow-x: hidden;
		width: 100%;
		height: 200px;
	}

	#tabs-vehicles .scroller label
	{
		font-weight: normal;
		margin: 0px;
		padding: 0px;
		display: inline;
	}
</style>

<script>
	var nvFinderPath = "<?php echo(LIVE_SITE); ?>/finder";
	var editor1 = "";
	var editor2 = "";

	jQuery(window).on("load", function()
	{
		get_layout_options(<?php echo(($product->product_layout_id ? $product->product_layout_id : 1)); ?>, <?php echo(($product->product_id ? $product->product_id : 0)) ?>, 'layout_specific_data');
		select_shop_categories(<?php echo($product->main_category_id); ?>);

		rebind_checkboxes();

    	jQuery('.sortable-images').sortable().bind('sortupdate', function()
    	{
		    //Triggered when the user stopped sorting and the DOM position has changed.
		    var ids 	= [];
		    var count 	= 0;

		    jQuery(".shop_photo").each(function()
		    {
		    	ids[count] = {"image_id": jQuery(this).attr("data-image-id"), "sort": count};
		    	count++;
		    });

		    jQuery("#image-sort").val(JSON.stringify(ids));
		});

		editor1 = CKEDITOR.replace( 'product_short_description',
		{
			filebrowserBrowseUrl : nvFinderPath,
			filebrowserNvimageBrowseUrl : nvFinderPath + '?type=images',
			filebrowserNvdocumentBrowseUrl : nvFinderPath + '?type=documents',
			filebrowserUploadUrl : nvFinderPath + '/quick_upload?type=files',
			filebrowserNvimageUploadUrl : nvFinderPath + '/quick_upload?type=images',
			filebrowserNvdocumentUploadUrl : nvFinderPath + '/quick_upload?type=documents',
			height: '300px'
		});

		editor2 = CKEDITOR.replace( 'product_description',
		{
			filebrowserBrowseUrl : nvFinderPath,
			filebrowserNvimageBrowseUrl : nvFinderPath + '?type=images',
			filebrowserNvdocumentBrowseUrl : nvFinderPath + '?type=documents',
			filebrowserUploadUrl : nvFinderPath + '/quick_upload?type=files',
			filebrowserNvimageUploadUrl : nvFinderPath + '/quick_upload?type=images',
			filebrowserNvdocumentUploadUrl : nvFinderPath + '/quick_upload?type=documents',
			height: '600px'
		});

    	jQuery("#existing-vehicle-list").DataTable(
	    {
			"pagingType": "full_numbers",
			"processing": true,
			"serverSide": false,
			"ajax": "/ajax/get_shop_vehicles?product_id=<?php echo($product->product_id); ?>",
			"pageLength": 50,
			"order": [[0,'desc'],[1,'asc'],[2,'asc'],[3,'asc']],
			"stateSave": true,
			"columns": [
		        { "data": "year", "title": "Year", "width": "20%", "className": "click", "searchable": true},
		        { "data": "make", "title": "Make", "width": "25%", "className": "click", "searchable": true},
		        { "data": "model", "title": "Model", "width": "25%", "className": "click", "searchable": true},
		        { "data": "style", "title": "Style", "width": "20%", "className": "click", "searchable": true},
		        { "data": "vehicle_id", "title": "Actions", "width": "10%", "orderable": false, "searchable": false,
		        	"render": function(data, x, row)
			        {
			        	var buttons = '<div class="nowrap">';
	                    buttons += '<a href="#" title="Delete" class="btn btn-icon" onclick="warning(\'Are you sure?\', \'This item will be deleted.\', true, function() { window.location=\'/shop_admin/vehicle_link_delete?product_id=' + row["product_id"] + '&vehicle_id=' + row["vehicle_id"] + '\'; }); return false;"><em class="far fa-fw fa-trash-alt" aria-hidden="true"></em></a>';
	                    buttons += '</div>';

	                    return buttons;
			        }}
		    ]
		});
	});

	/**
	 * Because we are constantly reloading the DOM, we have to rebind our event handlers each time.
	 * @return {[type]} [description]
	 */
	function rebind_checkboxes()
	{
		jQuery("input.year").unbind("change").change(function()
		{
			update_makes();
		});

		jQuery("input.make").unbind("change").change(function()
		{
			update_models();
		});

		jQuery("input.model").unbind("change").change(function()
		{
			update_styles();
		});

		jQuery("input.style").unbind("change").change(function()
		{
			update_vehicles();
		});
	}

	function update_makes()
	{
		jQuery("#makes-list").empty();

		var years_selected = "";

		jQuery("input.year:checked").each(function()
		{
			years_selected += jQuery(this).attr("id").replace("year_", "") + "|";
		});
		years_selected = years_selected.substring(0, years_selected.length-1);

		if(years_selected == "")
		{
			return;
		}

		jQuery.post
	    (
	        "/shop_custom/get_part_makes_admin",
	        {
	        	years: years_selected
	        },
	        function(data)
	        {
	        	if(data.length > 0)
	        	{
	        		for(i=0; i<data.length; i++)
	        		{
	        			jQuery("#makes-list").append('<div><input type="checkbox" class="make" id="make_' + data[i].make + '" /> <label for="make_' + data[i].make + '">' + data[i].make + '</label></div>');
	        		}

	        		rebind_checkboxes();
					update_models();
					update_styles();
					update_vehicles();
	        	}
	        	else
	        	{
	        	}
	        }
	    );
	}

	function update_models()
	{
		jQuery("#models-list").empty();

		var years_selected = "";
		var makes_selected = "";

		jQuery("input.year:checked").each(function()
		{
			years_selected += jQuery(this).attr("id").replace("year_", "") + "|";
		});
		years_selected = years_selected.substring(0, years_selected.length-1);

		jQuery("input.make:checked").each(function()
		{
			makes_selected += jQuery(this).attr("id").replace("make_", "") + "|";
		});
		makes_selected = makes_selected.substring(0, makes_selected.length-1);

		if(years_selected == "" || makes_selected == "")
		{
			return;
		}

		jQuery.post
	    (
	        "/shop_custom/get_part_models_admin",
	        {
	            years: years_selected,
	            makes: makes_selected
	        },
	        function(data)
	        {
	        	if(data.length > 0)
	        	{
	        		for(i=0; i<data.length; i++)
	        		{
	        			jQuery("#models-list").append('<div><input type="checkbox" class="model" id="model_' + data[i].model + '" /> <label for="model_' + data[i].model + '">' + data[i].model + '</label></div>');
	        		}

	        		rebind_checkboxes();
					update_styles();
					update_vehicles();
	        	}
	        	else
	        	{
	        	}
	        }
	    );
	}

	function update_styles()
	{
		jQuery("#styles-list").empty();

		var years_selected = "";
		var makes_selected = "";
		var models_selected = "";

		jQuery("input.year:checked").each(function()
		{
			years_selected += jQuery(this).attr("id").replace("year_", "") + "|";
		});
		years_selected = years_selected.substring(0, years_selected.length-1);

		jQuery("input.make:checked").each(function()
		{
			makes_selected += jQuery(this).attr("id").replace("make_", "") + "|";
		});
		makes_selected = makes_selected.substring(0, makes_selected.length-1);

		jQuery("input.model:checked").each(function()
		{
			models_selected += jQuery(this).attr("id").replace("model_", "") + "|";
		});
		models_selected = models_selected.substring(0, models_selected.length-1);

		if(years_selected == "" || makes_selected == "" || models_selected == "")
		{
			return;
		}

		jQuery.post
	    (
	        "/shop_custom/get_part_styles_admin",
	        {
	            years: years_selected,
	            makes: makes_selected,
	            models: models_selected
	        },
	        function(data)
	        {
	        	if(data.length > 0)
	        	{
	        		for(i=0; i<data.length; i++)
	        		{
	        			jQuery("#styles-list").append('<div><input type="checkbox" class="style" id="style_' + data[i].style + '" /> <label for="style_' + data[i].style + '">' + data[i].style + '</label></div>');
	        		}

	        		rebind_checkboxes();
	        		update_vehicles();
	        	}
	        	else
	        	{
	        	}
	        }
	    );
	}

	function update_vehicles()
	{
		jQuery("#vehicles-list").empty();

		var years_selected = "";
		var makes_selected = "";
		var models_selected = "";
		var styles_selected = "";

		jQuery("input.year:checked").each(function()
		{
			years_selected += jQuery(this).attr("id").replace("year_", "") + "|";
		});
		years_selected = years_selected.substring(0, years_selected.length-1);

		jQuery("input.make:checked").each(function()
		{
			makes_selected += jQuery(this).attr("id").replace("make_", "") + "|";
		});
		makes_selected = makes_selected.substring(0, makes_selected.length-1);

		jQuery("input.model:checked").each(function()
		{
			models_selected += jQuery(this).attr("id").replace("model_", "") + "|";
		});
		models_selected = models_selected.substring(0, models_selected.length-1);

		jQuery("input.style:checked").each(function()
		{
			styles_selected += jQuery(this).attr("id").replace("style_", "") + "|";
		});
		styles_selected = styles_selected.substring(0, styles_selected.length-1);

		if(years_selected == "" || makes_selected == "" || models_selected == "" || styles_selected == "")
		{
			return;
		}

		jQuery.post
	    (
	        "/shop_custom/get_parts_admin",
	        {
	            years: years_selected,
	            makes: makes_selected,
	            models: models_selected,
	            styles: styles_selected
	        },
	        function(data)
	        {
	        	if(data.length > 0)
	        	{
	        		jQuery("#vehicles-list").append('<div class="text-center"><button type="submit" name="apply" id="apply2" value="1" class="btn btn-secondary" onclick="document.getElementById(\'default_tab\').value=\'5\';"><em class="fas fa-car" aria-hidden="true"></em> Add Selected Vehicles</button></div>');

	        		for(i=0; i<data.length; i++)
	        		{
	        			jQuery("#vehicles-list").append('<div><input type="checkbox" class="vehicle" name="vehicle_' + data[i].vehicle_id + '" id="vehicle_' + data[i].vehicle_id + '" /> <label for="vehicle_' + data[i].vehicle_id + '">' + data[i].year + ' / ' + data[i].make + ' / ' + data[i].model + ' / ' + data[i].style + '</label></div>');
	        		}

	        		rebind_checkboxes();
	        	}
	        	else
	        	{
	        	}
	        }
	    );
	}
</script>
