<div class="row">
	<div class="col-12 col-md-3">
		<h2>Products</h2>
	</div>
	<div class="col-12 col-md-6">
		<form class="nvForm">
			<?php csrf(); ?>

			<div class="form-row">
				<label for="category_id" class="<?php echo(LABEL_COL); ?>">Category</label>

				<div class="<?php echo(FIELD_COL); ?>">
					<select id="category_id" class="form-control form-control-sm custom-select list-filter" data-filter-name="shop_category_id">
						<option value="">All Categories</option>
						<?php
						$cats = array();

						foreach($categories as $cat)
						{
							if(!in_array($cat->category_path_string, $cats))
							{
								$cats[] = $cat->category_path_string;
							}
						}

						sort($cats);

						foreach($cats as $cat)
						{
							//use the category path plus the category path HTML encoded (except our > separators) as the search query.
							//some of the database values have HTML entities in them and will fail to match.
							$value = $cat;// . "|" . str_replace("&gt;", ">", htmlentities($cat));

							?><option value="<?php echo($value); ?>"><?php echo($cat); ?></option><?php
						}
						?>
					</select>
				</div>
			</div>
		</form>
	</div>

	<div class="col-12 col-md-3 text-right">
		<a href="/shop_admin/product?id=0" class="btn btn-primary mb-2"><em class="fas fa-shopping-cart" aria-hidden="true"></em> Add Product</a>

		<div class="mb-2">
			Batch: <a href="#" title="Batch Publish" id="batch_publish" class="btn btn-sm btn-info"><em class="fas fa-fw fa-plus-circle" aria-hidden="true"></em></a>
			<a href="#" title="Batch Unpublish" id="batch_unpublish" class="btn btn-sm btn-info"><em class="fas fa-fw fa-minus-circle" aria-hidden="true"></em></a>
			<a href="#" title="Batch Delete" id="batch_delete" class="btn btn-sm btn-info"><em class="fas fa-fw fa-times-circle" aria-hidden="true"></em></a>
			<a href="#" title="Batch Edit Price" id="batch_price" class="btn btn-sm btn-info"><em class="fas fa-fw fa-dollar-sign" aria-hidden="true"></em></a>
			<a href="#" title="Batch Edit Shipping Size/Weight" id="batch_size" class="btn btn-sm btn-info"><em class="fab fa-fw fa-dropbox" aria-hidden="true"></em></a>
			<a href="#" title="Batch Edit Category" id="batch_category" class="btn btn-sm btn-info"><em class="fas fa-fw fa-sitemap" aria-hidden="true"></em></a>
		</div>
	</div>
</div>

<table id="list" class="<?php echo(ADMIN_TABLE); ?>"></table>

<div id="shop-price-dialog" class="dialog">
	<div class="alert alert-warning text-center">
		This will update ALL selected items.
		<hr>
		Uncheck an item to avoid updating that field.
	</div>

	<form id="shop-price-dialog-form nvForm" method="post" action="">
		<?php csrf(); ?>
		<input type="hidden" name="product_ids" id="product_ids" value="" />

		<div class="form-control mb-2">
			<label for="price" class="<?php echo(LABEL_COL); ?>">Price</label>
			<div class="<?php echo(FIELD_COL); ?>">
				<?php
				echo form_input(array(
				              "name"        => "price",
				              "id"          => "price",
				              "type" 		=> 'number',
				              "step"		=> 0.01,
				              "min"			=> 0,
				              "class"		=> "small-input",
				              "onchange"	=> "document.getElementById('update_price').checked='1';",
				              "class"		=> "form-control"
				            ));
				?>
				<input type="checkbox" name="update_price" id="update_price" value="1" /> Update Price
			</div>
		</div>

		<div class="form-control mb-2">
			<label for="price_lock" class="<?php echo(LABEL_COL); ?>">Price Lock</label>
			<div class="<?php echo(FIELD_COL); ?>">
				<?php
				echo form_checkbox(array(
				              "name"        => "price_lock",
				              "id"          => "price_lock",
				              "class"		=> "small-input",
				              "value"       => "1",
				              "onchange"	=> "document.getElementById('update_price_lock').checked='1';"
				            ));
				?>
				&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
				<input type="checkbox" name="update_price_lock" id="update_price_lock" value="1" /> Update Lock
			</div>
		</div>

		<div class="text-center">
			<button type="submit" class="btn btn-primary"><em class="fas fa-save" aria-hidden="true"></em> Save</button>
			<button type="button" class="btn btn-secondary" onclick="jQuery('#shop-price-dialog').dialog('close');"><em class="fas fa-times" aria-hidden="true"></em> Cancel</button>
		</div>
	</form>
</div>

<div id="shop-size-dialog" class="dialog">
	<div class="alert alert-warning text-center">
		This will update ALL selected items.
		<hr>
		Uncheck an item to avoid updating that field.
	</div>

	<form id="shop-size-dialog-form nvForm" method="post" action="">
		<?php csrf(); ?>
		<input type="hidden" name="product_ids" id="product_ids" value="" />

		<div class="form-control mb-2">
			<label for="shipping_length" class="<?php echo(LABEL_COL); ?>">Shipping Length</label>
			<div class="<?php echo(FIELD_COL); ?>">
				<?php
				echo form_input(array(
				              "name"        => "shipping_length",
				              "id"          => "shipping_length",
				              "type" 		=> 'number',
				              "step"		=> 0.01,
				              "min"			=> 0,
				              "class"		=> "small-input",
				              "onchange"	=> "document.getElementById('update_shipping_length').checked='1';",
				              "class"		=> "form-control"
				            ));
				?>
				<input type="checkbox" name="update_shipping_length" id="update_shipping_length" value="1" /> Update Length
			</div>
		</div>

		<div class="form-control mb-2">
			<label for="shipping_width" class="<?php echo(LABEL_COL); ?>">Shipping Width</label>
			<div class="<?php echo(FIELD_COL); ?>">
				<?php
				echo form_input(array(
				              "name"        => "shipping_width",
				              "id"          => "shipping_width",
				              "type" 		=> 'number',
				              "step"		=> 0.01,
				              "min"			=> 0,
				              "class"		=> "small-input",
				              "onchange"	=> "document.getElementById('update_shipping_width').checked='1';",
				              "class"		=> "form-control"
				            ));
				?>
				<input type="checkbox" name="update_shipping_width" id="update_shipping_width" value="1" /> Update Width
			</div>
		</div>

		<div class="form-control mb-2">
			<label for="shipping_height" class="<?php echo(LABEL_COL); ?>">Shipping Height</label>
			<div class="<?php echo(FIELD_COL); ?>">
				<?php
				echo form_input(array(
				              "name"        => "shipping_height",
				              "id"          => "shipping_height",
				              "type" 		=> 'number',
				              "step"		=> 0.01,
				              "min"			=> 0,
				              "class"		=> "small-input",
				              "onchange"	=> "document.getElementById('update_shipping_height').checked='1';",
				              "class"		=> "form-control"
				            ));
				?>
				<input type="checkbox" name="update_shipping_height" id="update_shipping_height" value="1" /> Update Height
			</div>
		</div>

		<div class="form-control mb-2">
			<label for="shipping_weight" class="<?php echo(LABEL_COL); ?>">Shipping Weight</label>
			<div class="<?php echo(FIELD_COL); ?>">
				<?php
				echo form_input(array(
				              "name"        => "shipping_weight",
				              "id"          => "shipping_weight",
				              "type" 		=> 'number',
				              "step"		=> 0.01,
				              "min"			=> 0,
				              "class"		=> "small-input",
				              "onchange"	=> "document.getElementById('update_shipping_weight').checked='1';",
				              "class"		=> "form-control"
				            ));
				?>
				<input type="checkbox" name="update_shipping_weight" id="update_shipping_weight" value="1" /> Update Weight
			</div>
		</div>

		<div class="text-center">
			<button type="submit" class="btn btn-primary"><em class="fas fa-save" aria-hidden="true"></em> Save</button>
			<button type="button" class="btn btn-secondary" onclick="jQuery('#shop-size-dialog').dialog('close');"><em class="fas fa-times" aria-hidden="true"></em> Cancel</button>
		</div>
	</form>
</div>

<div id="shop-category-dialog" class="dialog">
	<div class="alert alert-warning text-center">This will update ALL selected items.</div>

	<form id="shop-category-dialog-form nvForm" method="post" action="">
		<?php csrf(); ?>
		<input type="hidden" name="product_ids" id="product_ids" value="" />

		<div class="form-control mb-2">
			<label for="new_category_id" class="<?php echo(LABEL_COL); ?>">New Category</label>
			<div class="<?php echo(FIELD_COL); ?>">
				<?php
				$wgt = new FeralBasicSelectWidget("new_category_id");
				$wgt->SetAttribute("required", "required");
				$wgt->AddOption("", "Select Category");

				foreach($cats as $cat)
				{
					//use the category path plus the category path HTML encoded (except our > separators) as the search query.
					//some of the database values have HTML entities in them and will fail to match.
					$value = $cat;// . "|" . str_replace("&gt;", ">", htmlentities($cat));
					$wgt->addOption($value, $cat);
				}

				$wgt->Create();
				?>
			</div>
		</div>

		<div class="text-center">
			<button type="submit" class="btn btn-primary"><em class="fas fa-save" aria-hidden="true"></em> Save</button>
			<button type="button" class="btn btn-secondary" onclick="jQuery('#shop-category-dialog').dialog('close');"><em class="fas fa-times" aria-hidden="true"></em> Cancel</button>
		</div>
	</form>
</div>

<script>
	jQuery(window).on("load", function()
	{
		jQuery.fn.dataTable.ext.search.push(
		    function( settings, data, dataIndex )
		    {
		    	var category 		= jQuery("#category_id").val();
		    	var match 			= true;

		    	match = match && (category == "" || category == data[2]);

		        return match;
		    }
		);

		var table = jQuery("#list").DataTable(
	    {
			"pagingType": "full_numbers",
			"processing": true,
			"serverSide": false,
			"ajax": "/ajax/get_shop_products",
			"pageLength": 50,
			"order": [[4,'desc'], [5,'desc'], [1,'asc']],
			"stateSave": true,
			"columns": [
		        { "data": "sku", "title": "SKU", "width": "10%", "className": "click", "searchable": true,
		        	"render": function(data, x, row)
			        {
			        	return '<a href="/shop_admin/product?id=' + row["product_id"] + '" class="click">' + data + '</a>';
			        }},
		        { "data": "product_name", "title": "Product", "width": "25%", "className": "click", "searchable": true,
		        	"render": function(data, x, row)
			        {
			        	return data;
			        }},
		        { "data": "category_path_string", "title": "Category Path", "width": "20%", "className": "click", "searchable": true,
		        	"render": function(data, x, row)
			        {
			        	return data;
			        }},
		        { "data": "price", "title": "Price", "width": "10%", "className": "click", "searchable": true,
		        	"render": function(data, x, row)
			        {
			        	if(row["price_lock"] == "1")
	                    {
	                    	return "$" + number_format(data, 2) + " (Locked)";
	                    }
	                    else
	                    {
	                    	return "$" + number_format(data, 2);
	                    }
			        }},
		        { "data": "published", "title": "Published", "width": "10%", "className": "click", "searchable": true,
		        	"render": function(data, x, row)
			        {
			        	if(data == "1")
	                    {
	                    	return "Yes";
	                    }
	                    else
	                    {
	                    	return "No";
	                    }
			        }},
		        { "data": "has_image", "title": "Picture", "width": "10%", "className": "click", "searchable": true,
		        	"render": function(data, x, row)
			        {
			        	if(data == "1")
	                    {
	                    	return "Yes";
	                    }
	                    else
	                    {
	                    	return "No";
	                    }
			        }},
		        { "data": "product_id", "title": "Actions", "width": "10%", "className": "click", "searchable": true,
		        	"render": function(data, x, row)
			        {
			        	var buttons = '<div class="nowrap">';
	                    buttons += '<a title="Delete Product" href="#" class="btn btn-sm btn-danger" onclick="warning(\'Are you sure?\', \'This item will be deleted.\', true, function() { window.location=\'/shop_admin/product_delete?id=' + data + '\'; }); return false;"><em class="far fa-fw fa-trash-alt" aria-hidden="true"></em></a>';
	                    buttons += ' <a title="Duplicate Product" href="/shop_admin/product_duplicate?id=' + data + '" class="btn btn-sm btn-secondary"><em class="fas fa-fw fa-copy" aria-hidden="true"></em></a>';
	                    buttons += '</div>';

	                    return buttons;
			        }},
		        { "data": "product_id", "title": '<input type="checkbox" onchange="shopSelectAllProducts(this);" />', "width": "5%", "className": "text-right", "orderable": false, "searchable": false,
		        	"render": function(data, x, row)
			        {
			        	var buttons = '<div class="nowrap">';
	                    buttons += '<input type="checkbox" id="shop_product_' + data + '" class="shop_product_checkbox" value="1" />';
	                    buttons += '</div>';

	                    return buttons;
			        }}
		    ],
			'drawCallback': function()
			{
				table_hover("#list", "/shop_admin/product?id={id}");
			}
		});

		jQuery('#category_id').change(function()
		{
	        table.draw();
	    });

		jQuery("#batch_publish").click(function()
		{
			var checked_ids = shop_get_selected_products();

			if(checked_ids == false)
			{
				error("Nothing Selected", "No products are selected.", true, null);
			}
			else
			{
				nerivon_confirm("Are you sure?", "The selected products will be published.  Continue?", "warning", true, function()
                {
	                //publish each selected product
					jQuery.post
				    (
				        "/shop_admin/product_publish",
				        {
	            			product_ids: checked_ids
				        },
				        function(data)
				        {
				        	if(data == "FALED")
				        	{
				        		error("Error", "An error occurred while publishing these products.", true, null);
				        	}
				        	jQuery('#list').dataTable().fnFilter(jQuery("#list_filter input").val());
				        }
				    );
				});
			}
		});

		jQuery("#batch_unpublish").click(function()
		{
			var checked_ids = shop_get_selected_products();

			if(checked_ids == false)
			{
				error("Nothing Selected", "No products are selected.", true, null);
			}
			else
			{
				nerivon_confirm("Are you sure?", "The selected products will be unpublished.  Continue?", "warning", true, function()
                {
	                //unpublish each selected product
					jQuery.post
				    (
				        "/shop_admin/product_unpublish",
				        {
				            product_ids: checked_ids
				        },
				        function(data)
				        {
				        	if(data == "FALED")
				        	{
				        		error("Error", "An error occurred while unpublishing these products.", true, null);
				        	}
				        	jQuery('#list').dataTable().fnFilter(jQuery("#list_filter input").val());
				        }
				    );
				});
			}
		});

		jQuery("#batch_delete").click(function()
		{
			var checked_ids = shop_get_selected_products();

			if(checked_ids == false)
			{
				error("Nothing Selected", "No products are selected.", true, null);
			}
			else
			{
				nerivon_confirm("Are you sure?", "The selected products will be deleted.  Continue?", "warning", true, function()
                {
					//delete each selected product
					jQuery.post
				    (
				        "/shop_admin/product_delete_ajax",
				        {
				            product_ids: checked_ids
				        },
				        function(data)
				        {
				        	if(data == "FALED")
				        	{
				        		error("Error", "An error occurred while deleting these products.", true, null);
				        	}
				        	jQuery('#list').dataTable().fnFilter(jQuery("#list_filter input").val());
				        }
				    );
                });
			}
		});

		jQuery("#batch_price").click(function()
		{
			var checked_ids = shop_get_selected_products();

			if(checked_ids == false)
			{
				error("Nothing Selected", "No products are selected.", true, null);
			}
			else
			{
				shopPriceDialog();
			}
		});

		jQuery("#batch_size").click(function()
		{
			var checked_ids = shop_get_selected_products();

			if(checked_ids == false)
			{
				error("Nothing Selected", "No products are selected.", true, null);
			}
			else
			{
				shopSizeDialog();
			}
		});

		jQuery("#batch_category").click(function()
		{
			var checked_ids = shop_get_selected_products();

			if(checked_ids == false)
			{
				error("Nothing Selected", "No products are selected.", true, null);
			}
			else
			{
				shopCategoryDialog();
			}
		});
	});
</script>
