<?php
$temp_category_layout = new Shop_Category_Layout();
$temp_category_layout->Load(1);

$temp_layout = new Shop_Product_Layout();
$temp_layout->Load($product->product_layout_id);

$temp_category_layout = new Shop_Category_Layout();
$temp_category_layout->Load(1);

$all_layout_specific_options = $temp_layout->get_layout_options($product->product_id);
$layout_specific_options = $temp_layout->get_layout_options_for_product_display($product->product_id);

$filter = "category_all price_all ";
$cats = $this->shop_category->GetCategoriesForProductID($product->product_id);

foreach($cats as $cat)
{
	$filter .= "category_" . $cat->category_id . " ";
}

// We must do this because not all products will have ALL the layout options.
// We must set the _all filter on these products anyway so that our filters don't get screwed up.
foreach($all_layout_specific_options as $option)
{
	$filter .= "option_" . $option->layout_specific_data_id . "_all ";
}

// Now we add the filters which the product actually has.
foreach($layout_specific_options as $option)
{
	if($option->datatype == "checkbox" && $option->data_value == 1)
	{
		$filter .= "option_" . $option->layout_specific_data_id . " ";
	}
	else
	{
		$filter .= "option_" . $option->layout_specific_data_id . "_" . md5($option->data_value) . " ";
	}
}

$price_index = Shop::get_price_range_index($product->price);

if($price_index !== false)
{
	$filter .= "price_$price_index ";
}

$filter = trim($filter);
//Remove duplicates by converting the string to an array, making the array unique, and then converting back to a string.
$filter = explode(" ", $filter);
$filter = array_unique($filter);
$filter = implode(" ", $filter);

$product_name_for_display = preg_replace('/ \(([A-Za-z0-9 \._\/]*?)\)$/i', '<span class="common-name">$1</span>', $product->product_name);
?>

<div class="shop_product mix <?php echo($filter); ?>">
	<div class="shop_product_thumbnail">
		<?php
		//Processing thumbnails from the view is not ideal, but its a failsafe
		//MOST images will already be generated, this is mostly just a failsafe catch-all for things like related products which sometimes don't have thumbnails generated yet.
		// process_shop_thumbnails(array($product->image_filename), $temp_category_layout->product_image_width, $temp_category_layout->product_image_height);
		$offset 					= strripos($product->image_filename, ".");
		$product->image_filename 	= str_replace(".", "_" . $temp_category_layout->product_image_width . "x" . $temp_category_layout->product_image_height . ".", $product->image_filename, $offset);

		if($product->image_filename != "" && file_exists(ABSOLUTE_PATH . "/images/shop/resized/" . $product->image_filename))
		{
			$size = @getimagesize(ABSOLUTE_PATH . "/images/shop/resized/" . $product->image_filename);
			?><a href="/<?php echo($product->url); ?>" title="<?php echo($product->page_title ? addslashes($product->page_title) : addslashes($product->product_name)); ?>"><img src="<?php echo(LIVE_SITE . "/images/shop/resized/" . $product->image_filename); ?>" width="<?php echo($size[0]); ?>" height="<?php echo($size[1]); ?>" alt="<?php echo($product->page_title ? addslashes($product->page_title) : addslashes($product->product_name)); ?>" /></a><?php
		}
		?>
	</div>

	<div class="shop_product_title"><a href="/<?php echo($product->url); ?>"><?php echo($product_name_for_display); ?></a></div>

	<div class="clear"></div>
</div>
