<?php
$this->load->helper("shipping");
// $this->load->model("shipping/goshippo");

$items 		= 0;
$shipping_tbd = 0;

foreach($cart_items as $cart_item)
{
	if($cart_item->shipping_na || $cart_item->shipping_tbd == 1)
	{
		$shipping_tbd += $cart_item->quantity;
	}
	else
    {
    	$items += $cart_item->quantity;
    }
}

if($shipping_tbd > 0)
{
	?>
	<h3>Shipping Notes</h3>
	<ul class="shipping_summary">
		<?php
		if($shipping_tbd > 0)
		{
			?><li><em class="fas fa-home" aria-hidden="true"></em> You have <?php echo($shipping_tbd); ?> <?php echo($shipping_tbd == 1 ? "item" : "items"); ?> for which shipping costs could not be determined.  <b>See notes below.</b></li><?php
		}
		?>
	</ul>
	<?php
}

//If we have rates for each section that we have items for, allow the user to proceed to the next step in the checkout.
//The user will still be forced to select an option by way of HTML5 validation on the fields that get displayed.
if($items > 0 && is_array($rates) && count($rates) > 0)
{
	?>
	<script>
		jQuery("#shop_continue").removeAttr("disabled");
		jQuery("#shop_continue").removeAttr("title");
	</script>
	<?php
}

if(is_array($rates))
{
	?>
	<script>
		jQuery(window).on("load", function()
		{
			shop_update_shipping_cost(0);	//this is in case shipping is free, the tax/total will be updated
			shop_add_shippo_costs();
		});

		function shop_add_shippo_costs()
		{
			var standard = Number(jQuery("input.shipping_shippo_service_id:checked").attr("data-price"));

			shop_update_shipping_cost(standard);
		}
	</script>

	<?php
	if($items > 0 && count($rates) > 0)
	{
		?>
		<h3>Shipping Options</h3>
		<input type="hidden" name="shipping_gateway_service" id="shipping_gateway_service" value="<?php echo((isset($shipping_vars["shipping_gateway_service"]) ? $shipping_vars["shipping_gateway_service"] : "")); ?>" />

		<div class="pure-g">
			<div class="pure-u-10-24"><b>Carrier &amp; Service</b></div>
			<div class="pure-u-8-24 center"><b>Delivery Date</b></div>
			<div class="pure-u-2-24 center"><b>Tracking</b></div>
			<div class="pure-u-4-24 center"><b>Price</b></div>
			<?php
			foreach($rates as $rate)
			{
				if(isset($shipping_vars["shipping_shippo_service_id"]) && $shipping_vars["shipping_shippo_service_id"] == $rate->object_id)
				{
					$checked = true;
					?>
					<script>
						shop_update_shipping_cost(<?php echo($rate->amount); ?>);
						document.getElementById('shipping_gateway_service').value='<?php echo(addslashes($rate->provider) . " " . addslashes($rate->servicelevel_name)); ?>';
					</script>
					<?php
				}
				else
				{
					$checked = false;
				}
				?>
				<div class="pure-u-10-24">
					<img src="<?php echo($rate->provider_image_200); ?>" width="100" alt="<?php echo($rate->provider . " " . $rate->servicelevel_name); ?>" title="<?php echo($rate->provider . " " . $rate->servicelevel_name); ?> is $<?php echo($rate->amount . ' ' . $rate->currency); ?>" />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
					<input type="radio" name="shipping_shippo_service_id" id="shipping_shippo_service_id_<?php echo($rate->object_id); ?>" class="shipping_shippo_service_id" data-price="<?php echo($rate->amount); ?>" value="<?php echo($rate->object_id); ?>" required onclick="document.getElementById('shipping_gateway_service').value='<?php echo(addslashes($rate->provider) . " " . addslashes($rate->servicelevel_name)); ?>'; shop_add_shippo_costs();" <?php echo($checked ? "checked" : ""); ?> />
					<label for="shipping_shippo_service_id_<?php echo($rate->object_id); ?>">
						<?php echo($rate->provider . " " . $rate->servicelevel_name); ?>
					</label>
				</div>
				<div class="pure-u-8-24 center"><?php echo(date("l, F jS, Y", strtotime("+" . $rate->days . " weekdays"))); ?></div>
				<div class="pure-u-2-24 center"><em class="fas fa-fw fa-<?php echo(($rate->trackable ? "check" : "times")); ?>" aria-hidden="true"></em></div>
				<div class="pure-u-4-24 center">$<?php echo(number_format($rate->amount, 2) . " " . $rate->currency); ?></div>
				<?php
			}
		?>
		</div>
		<?php
	}
	else
	{
		?><p class="error">No shipping options are available.</p><?php
	}
}
else
{
	?>
	<div class="error"><?php echo($rates); ?></div>
	<?php
}

if($shipping_tbd > 0)
{
	?>
	<h3>Shipping Not Included (<?php echo($shipping_tbd); ?> <?php echo($shipping_tbd == 1 ? "Item" : "Items"); ?>)</h3>
	<ul>
		<li>You are ordering <?php echo($shipping_tbd); ?> <?php echo($shipping_tbd == 1 ? "item" : "items"); ?> for which shipping costs could not be determined.</li>
		<li>We can still ship these to you but <b>the shipping cost is not included</b> on this order.</li>
		<li>Please call us for a shipping quote or arrange to pick up <?php echo($shipping_tbd == 1 ? "this item" : "these items"); ?> in store.</li>
	</ul>
	<?php
}
?>
