<div class="row">
	<div class="<?php echo(TOP_LEFT); ?>">
		<h2>Shopper Groups</h2>
	</div>
	<div class="<?php echo(TOP_RIGHT); ?>">
		<a href="/shop_admin/shopper_group/0" class="btn btn-primary"><em class="fas fa-users" aria-hidden="true"></em> Add Shopper Group</a>
	</div>
</div>

<table id="list" class="<?php echo(ADMIN_TABLE); ?>"></table>

<script>
	jQuery(window).on("load", function()
	{
		jQuery("#list").DataTable(
	    {
			"pagingType": "full_numbers",
			"processing": true,
			"serverSide": false,
			"ajax": "/ajax/get_shop_shopper_groups",
			"pageLength": 50,
			"order": [[0,'asc']],
			"stateSave": true,
			"columns": [
		        { "data": "group_name", "title": "Shopper Group", "width": "90%", "className": "click", "searchable": true,
		        	"render": function(data, x, row)
			        {
			        	return '<a href="/shop_admin/shopper_group/' + row["shopper_group_id"] + '" class="click">' + data + '</a>';
			        }},
		        { "data": "shopper_group_id", "title": "Actions", "width": "10%", "className": "text-right", "orderable": false, "searchable": false,
		        	"render": function(data, x, row)
			        {
			        	var buttons = '<div class="nowrap">';
	                    buttons += '<a href="#" title="Delete" class="btn btn-sm btn-danger" onclick="warning(\'Are you sure?\', \'This shopper group will be deleted.\', true, function() { window.location=\'/shop_admin/shopper_group_delete/' + data + '\'; }); return false;"><em class="far fa-fw fa-trash-alt" aria-hidden="true"></em></a>';
	                    buttons += '</div>';

	                    return buttons;
			        }}
		    ],
			'drawCallback': function()
			{
				table_hover("#list", "/shop_admin/shopper_group/{id}");
			}
		});
	});
</script>
