CKEDITOR.dialog.add('nvdocument', function(editor)
{
	return {
		title: 'Insert Document Link',
		resizable: CKEDITOR.DIALOG_RESIZE_NONE,
        minWidth: 640,
        height: 300,
        contents:
		[
	        {
	            id: 'tab-document',
	            label: '',
	            title: '',
	            elements:
	            [
	            	{
						type: 'text',
						id: 'nvdocument-return',
						label: 'Return Info',
						onChange: function(e)
						{
							d = this.getDialog();
				        	parts = d.getValueOf("tab-document", "nvdocument-return").split("|");
				        	d.setValueOf("tab-document", "nvdocument-url", parts[0]);

				        	// Replace the title, unless there was already selected text.
							if(editor.getSelection().getType() != CKEDITOR.SELECTION_ELEMENT &&
								d.getValueOf("tab-document", "nvdocument-text") == "")
							{
								d.setValueOf("tab-document", "nvdocument-text", parts[1]);
								d.getContentElement("tab-document", "nvdocument-text").focus();
							}
							if(d.getValueOf("tab-document", "nvdocument-title") == "")
							{
								d.setValueOf("tab-document", "nvdocument-title", parts[1]);
								d.getContentElement("tab-document", "nvdocument-title").focus();
							}
		                },
						setup: function(element)
						{
							this.getElement().hide();
		                }
					},
					{
						type: 'button',
						id: 'existing-document-filename-browse',
						filebrowser: 'tab-document:nvdocument-return',
						label: 'Select a Document',
						className: 'center'
					},
					{
						type: 'text',
						id: 'nvdocument-text',
						label: 'Link Text',
						setup: function(element)
						{
							if(editor.getSelection().getType() == CKEDITOR.SELECTION_ELEMENT)
							{
								// This is probably HTML, lets just hide the input.
								this.setValue("");
								this.getElement().hide();
							}
							else
							{
								this.getElement().show();
								this.setValue(element.getHtml().replace(/<br>$/ig, ''));
							}
		                }
					},
					{
						type: 'text',
						id: 'nvdocument-title',
						label: 'Title Attribute (used as a tooltip for accessibility and SEO)',
						setup: function(element)
						{
							this.setValue((element.getAttribute("title") ? element.getAttribute("title") : ""));
							this.focus();
		                }
					},
					{
						type: 'text',
						id: 'nvdocument-url',
						label: 'Link URL (populated automatically after selecting a document)',
						validate: CKEDITOR.dialog.validate.notEmpty("You must select a document."),
						setup: function(element)
						{
							href = element.getAttribute("href");

							// If this is an existing document link, populate it.
							// If its some other form of link, we'll only replace it if the user selects a document.
							if(href != null && href.match(/^\/document\//))
							{
								this.setValue(href);
							}
							this.disable();
						}
					}
	            ]
	        }
        ],
        onShow: function()
        {
            var selection 	= editor.getSelection();
            var element 	= selection.getStartElement();

            if(element != null && element.getName() == 'a')
            {
                element = element.getAscendant({ a:1}, true);

                if(element != null && selection != null)
            	{
            		selection.selectElement(element);
            	}
            }
            else
            {
                element = editor.document.createElement('a');
            }

            if(selection != null && selection.getType() != CKEDITOR.SELECTION_ELEMENT)
            {
            	element.setHtml(selection.getSelectedText());
            }

            this.insertMode 	= true;
            this.element 		= element;
            this.setupContent(this.element);
        },
		onOk: function()
		{
			var docurl 		= this.getValueOf('tab-document', 'nvdocument-url');
			var doctext 	= this.getValueOf('tab-document', 'nvdocument-text');
			var doctitle 	= this.getValueOf('tab-document', 'nvdocument-title');
			var selection 	= editor.getSelection();
            var element 	= selection.getStartElement();
            var children 	= "";

            // href attribtue doesn't replace properly so we'll remove the element and add a fresh one.
            if(element != null && element.getName() == 'a')
            {
                parent = element.getAscendant({ a:1}, true);

                if(parent != null && parent.getName() == "a")
            	{
            		children = parent.getHtml().replace(/<br>$/ig, '');
                	parent.remove();
            	}
            	else
            	{
            		children = element.getOuterHtml().replace(/<br>$/ig, '');
            	}
            }
            else if(element != null && element.getName() == 'img')
            {
                children = element.getOuterHtml();
            }
            else
            {
            	children = selection.getSelectedText();
            }

			var link = editor.document.createElement('a');

            if(doctext)
        	{
        		link.setHtml(doctext);
        	}
        	else if(children)
        	{
        		link.setHtml(children);
        	}

            link.setAttribute("class", "document-link");
            link.setAttribute("href", docurl);
            link.setAttribute("title", (doctitle ? doctitle : "Download " + doctitle));
            link.setAttribute("target", "_blank");
            this.commitContent(link);

            if(this.insertMode)
            {
               	editor.insertElement(link);
            }
		}
	};
});
