CKEDITOR.plugins.add('nvfontawesome', {
	init: function(editor)
	{
		editor.addCommand('nvfontawesome', new CKEDITOR.dialogCommand('nvfontawesome'));
		editor.modes = {
			wysiwyg: 1,
			source: 0
		};
		editor.canUndo = true;
		editor.ui.addButton('nvfontawesome', {
			label: 'Insert Font Awesome Icon',
			command: 'nvfontawesome',
			icon: this.path + 'nvfontawesome.png'
		});
		CKEDITOR.dialog.add('nvfontawesome', this.path + 'dialogs/nvfontawesome.js');

		if ( editor.contextMenu )
		{
		    editor.addMenuGroup( 'nvFontAwesomeGroup' );
		    editor.addMenuItem( 'nvFontAwesomeSettings',
		    {
		        label: 'Edit Font Awesome Icon',
		        icon: this.path + 'nvfontawesome.png',
		        command: 'nvfontawesome',
		        group: 'nvFontAwesomeGroup'
		    });
		    editor.contextMenu.addListener( function( element )
		    {
		    	if(element.hasClass("fa"))
		        {
		            return { nvFontAwesomeSettings: CKEDITOR.TRISTATE_OFF };
		        }
		    });
		}
	}
});
