CKEDITOR.dialog.add('nvimage', function(editor)
{
	return {
		title: 'Insert Image',
		resizable: CKEDITOR.DIALOG_RESIZE_NONE,
        minWidth: 640,
        minHeight: 400,
        contents:
		[
	        {
	            id: 'tab-image',
	            label: '',
	            title: '',
	            elements:
	            [
	            	{
						type: 'text',
						id: 'nvimage-return',
						label: 'Return Info',
						onChange: function()
						{
							d = this.getDialog();
				        	d.setValueOf("tab-image", "nvimage-url", d.getValueOf("tab-image", "nvimage-return"));
				        	d.getContentElement("tab-image", "nvimage-alt").focus();
				        	jQuery("#nvimage-preview").attr("src", d.getValueOf("tab-image", "nvimage-return")).css({'display': 'inline'});
				        },
						setup: function(element)
						{
							this.getElement().hide();
		                }
					},
					{
						type: 'hbox',
						widths: ['60%', '40%'],
						children: [
						{
							type: 'button',
							id: 'nvimage-src-browse',
							filebrowser: 'tab-image:nvimage-return',
							label: 'Select an Image',
							className: 'center',
							style: 'width: 100%'
						},
						{
							type: 'html',
							id: 'nvimage-imagepreview',
							html: '<p style="text-align: center;"><img src="" style="display: none; max-height: 60px !important" id="nvimage-preview" /></p>'
						}]
					},
					{
						type: 'text',
						id: 'nvimage-url',
						label: 'Image URL (populated automatically after selecting an image)',
						validate: CKEDITOR.dialog.validate.notEmpty("You must select an image."),
						setup: function(element)
						{
							src = (element.getAttribute("src") ? element.getAttribute("src") : "");
							this.setValue(src);

							if(src)
							{
								jQuery("#nvimage-preview").attr("src", src).css({'display': 'inline'});
							}
							this.disable();
						}
					},
					{
						type: 'text',
						id: 'nvimage-alt',
						label: 'Alt Attribute (short description of the image)',
						setup: function(element)
						{
							this.setValue((element.getAttribute("alt") ? element.getAttribute("alt") : ""));
							this.focus();
		                }
					},
					{
						type: 'text',
						id: 'nvimage-title',
						label: 'Title Attribute (used as a tooltip for accessibility and SEO)',
						setup: function(element)
						{
							this.setValue((element.getAttribute("title") ? element.getAttribute("title") : ""));
		                }
					},
					{
						type: 'hbox',
						widths: ['80%', '20%'],
						children: [
						{
							type: 'text',
							id: 'nvimage-class',
							label: 'CSS Class Name(s)',
							setup: function(element)
							{
								this.setValue((element.getAttribute("class") ? element.getAttribute("class") : ""));
			                }
						},
						{
							type: 'select',
							id: 'nvimage-alignment',
							style: 'width: 100%',
							label: 'Alignment',
							items: [["None", ""], ["Left", "left"], ["Right", "right"]],
							setup: function(element)
							{
								style = (element.getAttribute("style") ? element.getAttribute("style") : "");

								if(style.indexOf("float: left") != -1)
								{
									this.setValue("left");
								}
								else if(style.indexOf("float: right") != -1)
								{
									this.setValue("right");
								}
			                }
						}]
					},
					{
						type: 'text',
						id: 'nvimage-caption',
						label: 'Figure Caption (changes this to a figure with caption)',
						setup: function(element)
						{
							try
							{
								this.setValue(element.caption.getText());
							}
							catch(e){}
		                }
					},
					{
						type: 'html',
						id: 'nvimage-linkinstructions',
						html: '<p>You can add a link to this image afterwards using the appropriate link tools.</p>'
					},
					{
						type: 'text',
						id: 'nvimage-linkurl',
						label: 'Link',
						setup: function(element)
						{
							try
							{
								this.setValue((element.link.getAttribute("href") ? element.link.getAttribute("href") : ""));
							}
							catch(e){}
							this.getElement().hide();
		                }
					},
					{
						type: 'text',
						id: 'nvimage-linktitle',
						label: 'Link Title',
						setup: function(element)
						{
							try
							{
								this.setValue((element.link.getAttribute("title") ? element.link.getAttribute("title") : ""));
							}
							catch(e){}
							this.getElement().hide();
		                }
					},
					{
						type: 'text',
						id: 'nvimage-linktarget',
						label: 'Link Target',
						setup: function(element)
						{
							try
							{
								this.setValue((element.link.getAttribute("target") ? element.link.getAttribute("target") : ""));
							}
							catch(e){}
							this.getElement().hide();
		                }
					},
					{
						type: 'text',
						id: 'nvimage-linkclass',
						label: 'Link Class',
						setup: function(element)
						{
							try
							{
								this.setValue((element.link.getAttribute("class") ? element.link.getAttribute("class") : ""));
							}
							catch(e){}
							this.getElement().hide();
		                }
					}
	            ]
	        }
        ],
        onShow: function()
        {
            var selection 	= editor.getSelection();
            var element 	= selection.getStartElement();
            var img 		= null;
            var link 		= null;
            var figure 		= null;
            var caption 	= null;
            var children 	= [];

            if(element != null && (element.getName() == "img" || element.getName() == "a" || element.getName() == "figure" || element.getName() == "figcaption"))
            {
            	img = element;	// Assume the element is <img> unless found later.

            	try
            	{
            		parent = element.getAscendant({figure:1}, true);
            	}
            	catch(e)
            	{
            		parent = null;
            	}

            	if(parent != null)
            	{
            		figure = parent;
            	}
            	else
            	{
            		try
            		{
            			parent = element.getAscendant({a:1}, true);
            		}
            		catch(e)
            		{
            			parent = null;
            		}

            		if(parent != null)
	            	{
	            		link = parent;
	            	}
	            	else
	            	{
	            		parent = null;
	            	}
            	}

            	if(parent != null && (parent.getName() == "a" || parent.getName() == "figure"))
            	{
            		try
            		{
            			children = parent.getChildren();

            			for(i=0; i<children.count(); i++)
		    			{
		    				try
		    				{
			    				if(children.getItem(i).getName() == "img")
				            	{
				            		img = children.getItem(i);
				            	}
				            	else if(children.getItem(i).getName() == "a")
				            	{
				            		link 		= children.getItem(i);
				            		children2 	= link.getChildren();

					        		for(j=0; j<children2.count(); j++)
					    			{
					    				try
					    				{
						    				if(children2.getItem(j).getName() == "img")
							            	{
							            		img = children2.getItem(j);
							            	}
							            }
							            catch(e){}
						            }
				            	}
				            	else if(children.getItem(i).getName() == "figcaption")
				            	{
				            		caption = children.getItem(i);
				            	}
				            }
				            catch(e){}
		    			}
            		}
            		catch(e)
            		{
            			children = [];
            		}
	    		}

                if(figure && selection)
            	{
            		selection.selectElement(figure);
            	}
            	else if(link && selection)
            	{
            		selection.selectElement(link);
            	}
            	else if(img && selection)
            	{
            		selection.selectElement(img);
            	}
            	element = img;
            }
            else
            {
                element = editor.document.createElement('img');
            }

            jQuery("#nvimage-preview").attr("src", "").css({'display': 'none'});

            this.insertMode 			= true;
            this.element 				= element;
            this.element.link 			= link;
            this.element.figure 		= figure;
            this.element.caption 		= caption;
            this.setupContent(this.element);
        },
		onOk: function()
		{
			var imageurl 		= this.getValueOf('tab-image', 'nvimage-url');
			var imagealt 		= this.getValueOf('tab-image', 'nvimage-alt');
			var imagetitle 		= this.getValueOf('tab-image', 'nvimage-title');
			var imageclass 		= this.getValueOf('tab-image', 'nvimage-class');
			var imagealignment 	= this.getValueOf('tab-image', 'nvimage-alignment');
			var imagecaption 	= this.getValueOf('tab-image', 'nvimage-caption');
			var linkurl 		= this.getValueOf('tab-image', 'nvimage-linkurl');
			var linktitle 		= this.getValueOf('tab-image', 'nvimage-linktitle');
			var linktarget 		= this.getValueOf('tab-image', 'nvimage-linktarget');
			var linkclass 		= this.getValueOf('tab-image', 'nvimage-linkclass');
			var selection 		= editor.getSelection();
            var element 		= selection.getStartElement();

            // src attribtue doesn't replace properly so we'll remove the element and add a fresh one.
            if(element != null && (element.getName() == "img" || element.getName() == "a" || element.getName() == "figure" || element.getName() == "figcaption"))
            {
                element.remove();
            }

            // Silently load the image so that we can access its width and add it to the style attribute.
			var temp = new Image();
			var nvimage_this = this;

			temp.onload = function()
			{
			  	var figure 	= null;
	            var link 	= null;
	            var img 	= editor.document.createElement('img');
	            var style 	= "";

	            // Check if a high DPI copy of this image exists.
	            var http = new XMLHttpRequest();

    			http.open('HEAD', imageurl.replace(/\.(jpe?g|png|gif|ico)$/i, '@2x.$1'), false);
    			http.send();

    			if(http.status == 404)
    			{
    				style = "width: " + this.width + "px; height: auto;";
    			}
	            else
	            {
	            	style = "width: " + Math.floor(this.width/2) + "px; height: auto;";
    			}

	            img.setAttribute("src", imageurl);
	            img.setAttribute("alt", imagealt);
	            img.setAttribute("title", imagetitle);
				img.setAttribute("class", imageclass);

				if(!imagecaption)
	            {
	            	if(imagealignment == "left")
		            {
						style += "float: left;";
		            }
		            else if(imagealignment == "right")
		            {
						style += "float: right;";
		            }
		        }

		        img.setAttribute("style", style);

	            if(linkurl)
	            {
	            	link = editor.document.createElement('a');
	            	link.setAttribute("href", linkurl);
	            	link.setAttribute("title", linktitle);
	            	link.setAttribute("target", linktarget);
	            	link.setAttribute("class", linkclass);
	            	link.append(img);
	            }

	            if(imagecaption)
	            {
	            	figure = editor.document.createElement('figure');
	            	caption = editor.document.createElement('figcaption');
	            	caption.setHtml(imagecaption);

	            	if(imagealignment == "left")
		            {
						figure.setAttribute("style", "float: left");
		            }
		            else if(imagealignment == "right")
		            {
						figure.setAttribute("style", "float: right");
		            }

	            	if(link)
	            	{
	            		figure.append(link);
	            	}
	            	else
	        		{
	        			figure.append(img);
	        		}
	            	figure.append(caption);

	            	nvimage_this.commitContent(figure);

		            if(nvimage_this.insertMode)
		            {
		               	editor.insertElement(figure);
		            }
	            }
	            else
	            {
	            	nvimage_this.commitContent(img);

		            if(nvimage_this.insertMode)
		            {
		               	editor.insertElement(img);
		            }
	            }
			}
			temp.src = imageurl;
		}
	};
});
