CKEDITOR.plugins.add('nvimage', {
	init: function(editor)
	{
		editor.addCommand('nvimage', new CKEDITOR.dialogCommand('nvimage'));
		editor.modes = {
			wysiwyg: 1,
			source: 0
		};
		editor.canUndo = true;
		editor.ui.addButton('nvimage', {
			label: 'Insert Image',
			command: 'nvimage',
			icon: this.path + 'nvimage.png'
		});
		CKEDITOR.dialog.add('nvimage', this.path + 'dialogs/nvimage.js');

		if(editor.contextMenu)
		{
		    editor.addMenuGroup('nvImageGroup');
		    editor.addMenuItem('nvImageSettings',
		    {
		        label: 'Edit Image',
		        icon: this.path + 'nvimage.png',
		        command: 'nvimage',
		        group: 'nvImageGroup'
		    });
		    editor.contextMenu.addListener( function( element )
		    {
		    	if(element.hasClass("fa"))
		        {
		            return { nvImageSettings: CKEDITOR.TRISTATE_OFF };
		        }
		    });
		}
	}
});
