CKEDITOR.dialog.add('nvlink', function(editor)
{
	return {
		title: 'Insert Custom Link',
		resizable: CKEDITOR.DIALOG_RESIZE_NONE,
        minWidth: 640,
        height: 200,
        contents:
		[
	        {
	            id: 'tab-link',
	            label: '',
	            title: '',
	            elements:
	            [
	            	{
						type: 'text',
						id: 'nvlink-text',
						label: 'Link Text',
						setup: function(element)
						{
							if(editor.getSelection().getType() == CKEDITOR.SELECTION_ELEMENT)
							{
								// This is probably HTML, lets just hide the input.
								this.setValue("");
								this.getElement().hide();
							}
							else
							{
								this.getElement().show();
								this.setValue(element.getHtml().replace(/<br>$/ig, ''));
							}
		                }
					},
					{
						type: 'text',
						id: 'nvlink-title',
						label: 'Title Attribute (used as a tooltip for accessibility and SEO)',
						setup: function(element)
						{
							this.setValue((element.getAttribute("title") ? element.getAttribute("title") : ""));
							this.focus();
		                }
					},
					{
						type: 'text',
						id: 'nvlink-url',
						label: 'Link URL',
						validate: CKEDITOR.dialog.validate.notEmpty("You must enter a link."),
						setup: function(element)
						{
							this.setValue((element.getAttribute("href") ? element.getAttribute("href") : ""));
						}
					},
					{
						type: 'select',
						id: 'nvlink-target',
						style: 'width: 100%',
						label: 'Link Target',
						items: [["New Window", "_blank"], ["Same Window", ""]],
						setup: function(element)
						{
							this.setValue((element.getAttribute("target") ? element.getAttribute("target") : "_blank"));
		                }
					}
	            ]
	        }
        ],
        onShow: function()
        {
            var selection 	= editor.getSelection();
            var element 	= selection.getStartElement();

            if(element != null && element.getName() == 'a')
            {
                element = element.getAscendant({ a:1}, true);

                if(element != null && selection != null)
            	{
            		selection.selectElement(element);
            	}
            }
            else
            {
                element = editor.document.createElement('a');
            }

            if(selection != null && selection.getType() != CKEDITOR.SELECTION_ELEMENT)
            {
            	element.setHtml(selection.getSelectedText());
            }

            this.insertMode 		= true;
            this.element 			= element;
            this.setupContent(this.element);
        },
		onOk: function()
		{
			var linkurl 	= this.getValueOf('tab-link', 'nvlink-url');
			var linktext 	= this.getValueOf('tab-link', 'nvlink-text');
			var linktitle 	= this.getValueOf('tab-link', 'nvlink-title');
			var linktarget 	= this.getValueOf('tab-link', 'nvlink-target');
			var selection 	= editor.getSelection();
            var element 	= selection.getStartElement();
            var children 	= "";

            // href attribtue doesn't replace properly so we'll remove the element and add a fresh one.
            if(element != null && element.getName() == 'a')
            {
                parent = element.getAscendant({ a:1}, true);

                if(parent != null && parent.getName() == "a")
            	{
            		children = parent.getHtml().replace(/<br>$/ig, '');
                	parent.remove();
            	}
            	else
            	{
            		children = element.getOuterHtml().replace(/<br>$/ig, '');
            	}
            }
            else if(element != null && element.getName() == 'img')
            {
                children = element.getOuterHtml();
            }
            else
            {
            	children = selection.getSelectedText();
            }

			var link = editor.document.createElement('a');

            if(linktext)
        	{
        		link.setHtml(linktext);
        	}
        	else if(children)
        	{
        		link.setHtml(children);
        	}

            if(linktarget == "_blank")
            {
            	link.setAttribute("class", "external-link");
            }
            else
        	{
        		link.setAttribute("class", "custom-link");
        	}
            link.setAttribute("href", linkurl);
            link.setAttribute("title", linktitle);
            link.setAttribute("target", linktarget);
            this.commitContent(link);

            if(this.insertMode)
            {
               	editor.insertElement(link);
            }
		}
	};
});
