CKEDITOR.plugins.add('nvlink', {
	init: function(editor)
	{
		editor.addCommand('nvlink', new CKEDITOR.dialogCommand('nvlink'));
		editor.modes = {
			wysiwyg: 1,
			source: 0
		};
		editor.canUndo = true;
		editor.ui.addButton('nvlink', {
			label: 'Insert Custom Link',
			command: 'nvlink',
			icon: this.path + 'nvlink.png'
		});
		CKEDITOR.dialog.add('nvlink', this.path + 'dialogs/nvlink.js');

		if(editor.contextMenu)
		{
		    editor.addMenuGroup('nvLinkGroup');
		    editor.addMenuItem('nvLinkSettings',
		    {
		        label: 'Edit Custom Link',
		        icon: this.path + 'nvlink.png',
		        command: 'nvlink',
		        group: 'nvLinkGroup'
		    });
		    editor.contextMenu.addListener( function( element )
		    {
		    	if(element.hasClass("fa"))
		        {
		            return { nvLinkSettings: CKEDITOR.TRISTATE_OFF };
		        }
		    });
		}
	}
});
