CKEDITOR.plugins.add('nvmodule',
{
	init: function(editor)
	{
		editor.addCommand('nvmodule', new CKEDITOR.dialogCommand('nvmodule'));
		editor.modes = {
			wysiwyg: 1,
			source: 0
		};
		editor.canUndo = true;
		editor.ui.addButton('nvmodule', {
			label: 'Insert Module',
			command: 'nvmodule',
			icon: this.path + 'nvmodule.png'
		});
		CKEDITOR.dialog.add('nvmodule', this.path + 'dialogs/nvmodule.js');

		if ( editor.contextMenu )
		{
		    editor.addMenuGroup( 'nvModuleGroup' );
		    editor.addMenuItem( 'nvModuleSettings',
		    {
		        label: 'Configure Module',
		        icon: this.path + 'nvmodule.png',
		        command: 'nvmodule',
		        group: 'nvModuleGroup'
		    });
		    editor.contextMenu.addListener( function( element )
		    {
		    	if(element.getAscendant('img', true) && element.hasClass("module_placeholder"))
		        {
		            return { nvModuleSettings: CKEDITOR.TRISTATE_OFF };
		        }
		    });
		}
	}
});
