CKEDITOR.plugins.add('nvpure',
{
	requires: 'widget',

    init: function( editor ) {
        editor.widgets.add( 'nvpure', {

            template:
                '<img class="module_placeholder" src="/placeholder?id=1" />',

            editables:
            {
                grid1:
                {
                    selector: '.pure-u-1:nth-child(1)'
                },
                grid2:
                {
                    selector: '.pure-u-1:nth-child(2)'
                }
            },

            allowedContent: 'div(!pure-g); div(!pure-u-1)',

            requiredContent: 'div(pure-g)',

            upcast: function( element ) {
                return element.name == 'div' && element.hasClass( 'pure-g' );
            }
        } );

        editor.ui.addButton('nvpure', {
			label: 'Insert Pure CSS Grid',
			command: 'nvpure',
			icon: this.path + 'nvpure.png'
		});
    }
});
