(function()
{
 	var app = angular.module('app');

 	app.controller('ProductController', ["$scope", "$http", function($scope, $http)
	{
		$scope.product 				= PRODUCT;
		$scope.shopper_groups 		= SHOPPER_GROUPS;
		$scope.new_variant 			= "";
		$scope.new_variant_count 	= 0;

		$scope.addVariant = function()
		{
			if(!$scope.new_variant)
			{
				return;
			}
			$scope.new_variant_count++;

			if(typeof $scope.product.variants == "undefined")
			{
				$scope.product.variants = [];
			}
			if(typeof $scope.product.prices == "undefined")
			{
				$scope.product.prices = [];
			}

			$scope.product.variants.push({product_variant_id: "new_" + $scope.new_variant_count, variant: $scope.new_variant, sort: $scope.product.variants.length+1});

			for(var i=0; i<$scope.shopper_groups.length; i++)
			{
				$scope.product.prices.push({product_price_id: null, shopper_group_id: $scope.shopper_groups[i].shopper_group_id, shopper_group: $scope.shopper_groups[i].group_name, product_variant_id: "new_" + $scope.new_variant_count, variant: $scope.new_variant, price: 0.00});
			}

			// Now that we have at least one variant, remove any "default prices" from the list.
			for(var i=0; i<$scope.product.prices.length; i++)
			{
				if($scope.product.prices[i].product_variant_id == null)
				{
					$scope.product.prices.splice(i, 1);
					i--;
				}
			}

			$scope.new_variant = null;
		}

		$scope.addVariantKeyboard = function(e)
		{
			if(e.keyCode == 13)	// Enter
			{
				e.preventDefault();
				$scope.addVariant();

				return false;
			}
		}

		$scope.removeVariant = function(product_variant_id)
		{
			nerivon_confirm("Are you sure?", "This variant and all associated prices will be deleted (only from this product).", "warning", true, function()
			{
				for(var i=0; i<$scope.product.variants.length; i++)
				{
					if($scope.product.variants[i].product_variant_id == product_variant_id)
					{
						$scope.product.variants.splice(i, 1);
						break;
					}
				}

				// If we have no more variants, add "default prices" to the list.
				if($scope.product.variants.length == 0)
				{
					$scope.new_variant_count++;

					for(var i=0; i<$scope.shopper_groups.length; i++)
					{
						$scope.product.prices.push({product_price_id: null, shopper_group_id: $scope.shopper_groups[i].shopper_group_id, shopper_group: $scope.shopper_groups[i].group_name, product_variant_id: "default_" + $scope.new_variant_count, variant: "Default Price", price: 0.00});
					}
				}

				// Remove all prices that were for this variant.
				for(var i=0; i<$scope.product.prices.length; i++)
				{
					if($scope.product.prices[i].product_variant_id == product_variant_id)
					{
						$scope.product.prices.splice(i, 1);
						i--;
					}
				}

				$scope.$digest();
			});
		}

		$scope.variantUp = function(product_variant_id)
		{
			var sort = 0;

			for(var i=0; i<$scope.product.variants.length; i++)
			{
				if($scope.product.variants[i].product_variant_id == product_variant_id)
				{
					$scope.product.variants[i].sort--;
					sort = $scope.product.variants[i].sort;
					break;
				}
			}

			for(var i=0; i<$scope.product.variants.length; i++)
			{
				if($scope.product.variants[i].product_variant_id != product_variant_id &&
				   $scope.product.variants[i].sort == sort)
				{
					$scope.product.variants[i].sort++;
					break;
				}
			}
		}

		$scope.variantDown = function(product_variant_id)
		{
			var sort = 0;

			for(var i=0; i<$scope.product.variants.length; i++)
			{
				if($scope.product.variants[i].product_variant_id == product_variant_id)
				{
					$scope.product.variants[i].sort++;
					sort = $scope.product.variants[i].sort;
					break;
				}
			}

			for(var i=0; i<$scope.product.variants.length; i++)
			{
				if($scope.product.variants[i].product_variant_id != product_variant_id &&
				   $scope.product.variants[i].sort == sort)
				{
					$scope.product.variants[i].sort--;
					break;
				}
			}
		}
	}]);
})();
