var xhr;

function shop_flip(obj)
{
	jQuery(obj).parent().parent().find('.flip-container').addClass('hover');
}

function shop_flip_back(obj)
{
	jQuery(obj).parent().parent().find('.flip-container').removeClass('hover');
}

function shop_update_taxes()
{
	var country = jQuery("#shipping_country").val();
	var province = jQuery("#shipping_province").val();

	jQuery.post
    (
        "/shop/get_taxes",
        {
            country: country,
            province: province
        },
        function(data)
        {
        	var subtotal = Number(jQuery("#shop_cart_total_unformatted").val());
        	var shipping = Number(jQuery("#shop_cart_shipping_unformatted").val());
        	var tax_field = jQuery("#shop_cart_tax_unformatted");
        	var cart_total = Number(subtotal) + Number(shipping);
        	var tax = null;
        	var tax_amount = 0;
        	var tax_display = "";
        	var tax_percentage = 0;

        	if(typeof data == "object")
        	{
        		jQuery(".shop_cart_tax_row").remove();

        		//go backwards to keep them in proper order
        		for(i=data.length-1; i>=0; i--)
        		{
        			tax = data[i];
        			//due to some stupid floating point issues, we have to do lots of type conversion to simply move our decimal point in the display value
        			tax_percentage = Number(String(Number(tax["tax_percentage"]) * 100).substring(0, 7).toString());
        			tax_display = tax["tax_name"] + " (" + tax["tax_province"] + " " + tax_percentage + "%)";
        			tax_amount = Number(tax["tax_percentage"]) * Number(cart_total);
        			cart_total += Number(tax_amount);

        			jQuery("#shop_cart_shipping_row").after("<tr class=\"shop_cart_tax_row\"><th colspan=\"3\" class=\"right\">" + tax_display + "</th><td class=\"shop_cart_column_total\">$" + number_format(tax_amount, 2) + "</td></tr>");
        			jQuery(tax_field).val(number_format(tax_amount, 2, ".", ""));
        		}

        		jQuery(".shop_cart_total").html("$" + number_format(cart_total, 2));
        	}
        }
    );
}

function show_payment_gateway(id)
{
	jQuery('#payment_gateway').html(jQuery('#payment_gateway' + id + 'form').html());
}

function update_shipping_gateway()
{
	if(shop_active_shipping_gateway <= 0)
	{
		return;
	}

	//attempt to abort any already in progress AJAX requests for shipping
	//this will fail if none are active, so we ignore the exception
	try
	{
		xhr.abort();
	}
	catch(e){}

	jQuery("#shop_continue").prop("disabled", true);
	jQuery("#shop_continue").attr("title", "You must choose a shipping method in order to continue.");

	var shipping_address 	= document.getElementById("shipping_address");
	var shipping_city 		= document.getElementById("shipping_city");
	var shipping_province 	= document.getElementById("shipping_province");
	var shipping_postalcode = document.getElementById("shipping_postalcode");
	var shipping_country 	= document.getElementById("shipping_country");

	//jQuery('#shipping_gateway').html(jQuery('#shipping_gateway' + id + 'form').html());

	jQuery("#shipping_gateway").html("<div class='success center'><i class='fas fa-spin fa-spinner'></i> Loading Shipping Options...</div>");

	xhr = jQuery.post
    (
        "/shop/get_shipping_rates",
        {
            shipping_gateway_id: shop_active_shipping_gateway,
            shipping_address: (typeof shipping_address.value != 'undefined' ? shipping_address.value : ""),
            shipping_city: (typeof shipping_city.value != 'undefined' ? shipping_city.value : ""),
            shipping_province: (typeof shipping_province.value != 'undefined' ? shipping_province.value : ""),
            shipping_postalcode: (typeof shipping_postalcode.value != 'undefined' ? shipping_postalcode.value : ""),
            shipping_country: (typeof shipping_country.value != 'undefined' ? shipping_country.value : "")
        },
        function(data)
        {
        	jQuery("#shipping_gateway").html(data);

        	shop_update_taxes();
        }
    );
}

function shop_update_shipping_cost(new_cost)
{
	var cart_total = Number(jQuery("#shop_cart_total_unformatted").val());
	cart_total += Number(new_cost);

	jQuery("#shop_cart_shipping_unformatted").val(new_cost);
	jQuery("#shop_cart_shipping").html("$" + number_format(new_cost, 2));
	jQuery(".shop_cart_total").html("$" + number_format(cart_total, 2));
	//jQuery("#order-total").html("$" + number_format(cart_total, 2));

	shop_update_taxes();
}

function shop_order_submit()
{
	jQuery("#shop-submit-order").prop("disabled", true);
	jQuery("#shop-submit-order").html("<i></i> Submitting Order...", true);
	jQuery("#shop-submit-order i").addClass("fas fa-spin fa-spinner");
}

function postalcode_lookup()
{
	var postalcode = jQuery("#shipping_postalcode").val();

	jQuery("label.shop-spinner").append(" <i class='fas fa-spin fa-spinner'></i>");

	jQuery.post
    (
        "/shop/geocode",
        {
            postalcode: postalcode
        },
        function(data)
        {
        	try
        	{
        		var postalcode = data.postalcode;
        		var city = data.city;
        		var province = data.province;
        		var country = data.country;

				jQuery("#shipping_postalcode").val(postalcode);
        		jQuery("#shipping_city").val(city);

    			jQuery("#shipping_province option:selected").removeAttr("selected");
				jQuery("#shipping_province option[value='" + province + "']").attr("selected", "selected");

    			jQuery("#shipping_country option:selected").removeAttr("selected");
				jQuery("#shipping_country option[value='" + country + "']").attr("selected", "selected");
        	}
        	catch(e){}

        	jQuery("label.shop-spinner").each(function()
			{
				jQuery(this).find("i").remove();
				jQuery(this).html(jQuery(this).html().trim());
			});

        	update_shipping_gateway();
        }
    );
}

function shop_quickview(product_id, product_variant_id, message)
{
	jQuery.ajax(
	{
		url: '/shop/product_quick_view/' + product_id,
		type: 'GET'
	}).done(function(data, textStatus, jqXHR)
	{
		swal.close();

		newdata = '<a href="#" id="shop-product-quick-view-close" onclick="jQuery(\'#shop-product-quick-view\').dialog(\'close\');return false;"><em class="fas fa-times"></em></a>';

		if(message)
		{
			newdata += '<div class="shop-product-quick-view-message"><div class="pure-g"><div class="pure-u-2-24"><a href="/shop/cart" title="View Cart"><em class="fas fa-lg fa-shopping-basket" aria-title="View Cart"></em></a></div><div class="pure-u-22-24 pure-u-md-14-24 center">' + message + '</div><div class="pure-u-1 pure-u-md-8-24 checkout"><a href="/shop/checkout">Ready to Checkout? <em class="fas fa-caret-right" aria-hidden="true"></em></a></div></div></div>';
		}

		newdata += data;
		newdata = newdata.replace(/<script[^>]*>/gi, ' <!-- <script>');
		newdata = newdata.replace(/<\/script>/gi, ' </script> --> ');
		// data = newdata;

		jQuery("#shop-product-quick-view").html(newdata).dialog(
		{
			title: "",
			width: jQuery(window).width() * 0.95,
			height: jQuery(window).height() * 0.95,
			maxWidth: 1500,
			modal: true,
			show: { effect: "fade", duration: 500 },
			hide: { effect: "fade", duration: 500 }
		});

		setTimeout(function()
		{
			// Hijack the form submit function from the main product page and use our Javascript function instead.
			jQuery("#shop_add_to_cart").submit(function(e)
			{
				e.preventDefault();
				shop_addtocart(product_id, product_variant_id, jQuery("#quantity").val());
			});

			jQuery('#bxSliderProduct').bxSlider({
				mode: "horizontal",
				speed: 1000,
				slideMargin: 0,
				startSlide: 0,
				randomStart: true,
				slideSelector: "",
				infiniteLoop: true,
				hideControlOnEnd: false,
				easing: "linear",
				captions: false,
				ticker: false,
				tickerHover: false,
				adaptiveHeight: true,
				adaptiveHeightSpeed: 250,
				video: false,
				responsive: true,
				useCSS: true,
				preloadImages: "visible",
				touchEnabled: true,
				swipeThreshold: 50,
				oneToOneTouch: true,
				preventDefaultSwipeX: true,
				preventDefaultSwipeY: false,
				pager: true,
				pagerType: "full",
				pagerShortSeparator: "/",
				pagerSelector: "",
				pagerCustom: "#bxPager",
				buildPager: "",
				controls: true,
				nextText: "Next",
				prevText: "Prev",
				nextSelector: "",
				prevSelector: "",
				autoControls: false,
				startText: "Start",
				stopText: "Stop",
				autoControlsCombine: false,
				autoControlsSelector: "",
				auto: false,
				pause: 4000,
				autoStart: true,
				autoDirection: "next",
				autoHover: true,
				autoDelay: 0,
				minSlides: 1,
				maxSlides: 1,
				moveSlides: 1,
				slideWidth: 500
			});

			jQuery("#bxSliderProduct a.lightbox").colorbox({
				'rel'			: 'product-slider',
				'transition'	: 'elastic',
				'current'		: '{current}/{total}',
				'scalePhotos' 	: true,
				'width'			: '1000',
				'height'		: '750',
				'maxWidth' 		: '100%',
				'maxHeight'		: '100%'
			});
		},600);
	}).fail(function(jqXHR, textStatus, errorThrown)
	{
		error("Error", "Could not load product information.", true, null);
	});
}

function shop_addtocart(product_id, product_variant_id, qty)
{
	jQuery.ajax(
	{
		url: '/shop/add_to_cart',
		type: 'POST',
		data: jQuery.param({ task: 'add', product_id: product_id, product_variant_id: product_variant_id, quantity: 1})
	}).done(function(data, textStatus, jqXHR)
	{
		swal.close();
		shop_get_cart();

		try
		{
			if(jQuery("#shop-product-quick-view").dialog("isOpen"))
			{
				jQuery("#shop-product-quick-view").dialog("close");
			}
		}
		catch(e)
		{
		}

		if(jQuery("#shop-cart-floater").is(':visible'))
		{
			cartSummary(jQuery("#shop-cart-floater"), true);

			setTimeout(function()
			{
				cartSummary(jQuery("#shop-cart-floater"), true);
			}, 3000);
		}
		else
		{
			cartSummary(jQuery(".shop-cart-button:visible"), true);

			setTimeout(function()
			{
				cartSummary(jQuery(".shop-cart-button:visible"), true);
			}, 3000);
		}
	}).fail(function(jqXHR, textStatus, errorThrown)
	{
		error("Error", "Could not add product to cart.", true, null);
	});
}

function shop_get_cart()
{
	jQuery.post
    (
        "/shop/get_cart", null,
        function(data)
        {
        	var cart_total 	= 0;
			var qty_total 	= 0;
			var details 	= '<div class="pure-g">';
			var summary 	= '';

			for(var i=0; i<data.length; i++)
			{
				details += '<div class="pure-u-1">' + Number(data[i].quantity) + " x " + data[i].product_name + (data[i].variant ? " (" + data[i].variant + ")" : "") + '</div><div class="pure-u-1-2">$' + number_format(Number(data[i].price), 2, ".", ",") + ' each</div><div class="pure-u-1-2 right">$' + number_format(Number(data[i].price) * Number(data[i].quantity), 2, ".", ",") + '</div>';
				details += '<div class="pure-u-1">&nbsp;</div>';
				qty_total += Number(data[i].quantity);
				cart_total += (Number(data[i].quantity) * Number(data[i].price));
			}
			details += '<div class="pure-u-1-2 right">Subtotal</div><div class="pure-u-1-2 right">$' + number_format(Number(cart_total), 2, ".", ",") + '</div>';
			details += '</div>';

			summary = '$' + number_format(Number(cart_total), 2, ".", ",");

			jQuery(".shop-cart-summary").html(summary);
			jQuery(".shop-cart-details").html(details);
			jQuery(".shop-cart-quantity").html(qty_total);
        }
    );
}
