<?php
defined('PRODUCT_NAME') or die;
class AccountModule extends ModuleInstance
{
	public function __construct()
	{
		parent::__construct();
		$this->cache_config->enabled = false;
	}

	public function render()
	{
		$this->load->helper("url");
		$this->load->model("shop/shop_order");

		$user 					= get_user();
		$task 					= $this->input->get_post("task");
		$page 					= "/" . Mainframe::page()->url;
		$title 					= $this->setting("title");
		$title_heading_level 	= $this->setting("title_heading_level");
		$module_class 			= $this->setting("module_class");

		$view_data = array("module_instance_id" => $this->module_instance_id,
		                   "user" 				=> $user,
		                   "task" 				=> $task,
		                   "page" 				=> $page,
		                   "module_class" 		=> $module_class);

		$orders = $this->shop_order->LoadByUserID($user->user_id);

		?>
		<div id="module_<?php echo $this->module_instance_id?>" class="module account-module <?php echo($module_class); ?>">
			<?php
			if($title && $title_heading_level)
			{
				?><<?php echo($title_heading_level); ?> class="module-title"><?php echo($title); ?></<?php echo($title_heading_level); ?>><?php
			}
			?>
			<nav class="account_navigation">
				<ul>
					<li><a href="<?php echo($page); ?>">My Account</a> &bull; </li>
					<li><a href="<?php echo($page); ?>?task=info">Account Information</a> &bull; </li>
					<?php
					if(count($orders) > 0)
					{
						?><li><a href="<?php echo($page); ?>?task=orders">Order History</a> &bull; </li><?php
					}
					?>
					<li><a href="<?php echo($page); ?>?task=logout">Logout</a></li>
				</ul>
			</nav>

			<?php
			switch($task)
			{
				case "save_info":
				{
					csrf_verify();

					if($this->input->post("password") && $this->input->post("password") != $this->input->post("password2"))
					{
						$view_data["saved"] = false;
					}
					else
					{
						$edit_user = new User();
						$edit_user->load($this->input->post("user_id"));
						$edit_user->readPostVars();

						$view_data["saved"] = $edit_user->save();
					}

					//intentionally not breaking to let the "info" page re-load
				}
				case "info":
				{
					$user = get_user();	//this will reload the data if it was previously saved
					$this->load->view("modules/account/info", $view_data);

					break;
				}
				case "orders":
				{
					$view_data["orders"] = $orders;

					$this->load->view("modules/account/orders", $view_data);

					break;
				}
				case "order":
				{
					$order = new Shop_Order();
					$order->LoadWithDetails($this->input->get_post("order_id"));
					$view_data["order"] = $order;

					$this->load->view("modules/account/order", $view_data);

					break;
				}
				case "logout":
				{
					setcookie("user_id", "", 1, $this->config->item("cookie_path"), $this->config->item("cookie_domain"), $this->config->item("cookie_secure"), $this->config->item("cookie_httponly"));

					FeralRedirect("/");

					break;
				}
				default:
				{
					$this->load->view("modules/account/module", $view_data);

					break;
				}
			}
			?>
		</div>
		<?php
	}
}
