<?php
defined('PRODUCT_NAME') or die;
class ContentListModule extends ModuleInstance
{
	public function __construct()
	{
		parent::__construct();

		$this->cache_config->user         = true;
		$this->cache_config->url          = true;
		$this->cache_config->query_string = true;
	}

	function render()
	{
		$this->load->model(array("page", "content_type"));

		$q					= filter_var($this->input->get_post("q" . $this->module_instance_id), FILTER_SANITIZE_STRING);
		$page_number		= (int)$this->input->get_post("p");
		$year 				= ($this->setting("layout") == "year" ? ($this->input->get_post("year") ? (int)$this->input->get_post("year") : date("Y")) : null);

		if(!$page_number)
		{
			$page_number = 1;
		}

		$category_id		= $this->setting("category_id");
		$content_type_id	= $this->setting("content_type_id");
		$tag_ids			= $this->setting("tag_ids");
		$tag_logic			= $this->setting("tag_logic", "OR");
		$num_featured		= $this->setting("num_featured");
		$num_articles		= $this->setting("num_articles");
		$per_page			= $this->setting("per_page");
		$ordering 			= $this->setting("ordering");
		$orderby 			= "`created` DESC";
		$ignore_searchable 	= ($this->setting("ignore_searchable") ? 1 : 0);
		$offset 			= ($page_number-1) * $per_page;
		$next 				= false;
		$prev 				= ($page_number > 1 && $per_page > 0 ? $page_number-1 : false);
		$categories 		= array();

		if($ordering == "newest_created")
		{
			$orderby = "`created` DESC";
		}
		else if($ordering == "oldest_created")
		{
			$orderby = "`created` ASC";
		}
		else if($ordering == "newest_modified")
		{
			$orderby = "`modified` DESC";
		}
		else if($ordering == "oldest_modified")
		{
			$orderby = "`modified` ASC";
		}
		else if($ordering == "alpha")
		{
			$orderby = "`title` ASC";
		}
		else if($ordering == "random")
		{
			$orderby = "RAND()";
		}

		$pages = $this->page->LoadByCategoryContentTypeTagID(Mainframe::site()->site_id, $category_id, $content_type_id, $tag_ids, $tag_logic, $orderby, $q, Mainframe::user(), $ignore_searchable);

		if($this->setting("layout") == "year")
		{
			$categories = array();

			foreach($pages as $p)
			{
				$index = date("Y", strtotime($p->created));

				if(!isset($categories[$index]))
				{
					$categories[$index] = new StdClass();
					$categories[$index]->year = $index;
					$categories[$index]->name = $index;
					$categories[$index]->total = 0;
				}

				$categories[$index]->total++;
			}

			usort($categories, array("ContentListModule", "year_sort"));

			$pages = $this->page->LoadByCategoryContentTypeTagIDYear(Mainframe::site()->site_id, $category_id, $content_type_id, $tag_ids, $tag_logic, $year, $orderby, $q, Mainframe::user(), $ignore_searchable);
		}

		if($num_articles > 0)
		{
			$pages = array_splice($pages, 0, $num_featured + $num_articles);
		}

		$total 		= count($pages);
		$page_count = ($per_page > 0 ? ceil($total/$per_page) : 1);
		$next 		= ($page_count > $page_number && $per_page > 0 ? $page_number+1 : false);

		if($per_page > 0)
		{
			if(count($pages) > $per_page)
			{
				$pages = array_splice($pages, $offset, $per_page);
			}
		}

		$final_pages = array();

		for($i=0; $i<count($pages); $i++)
		{
			$fp = new Page();
			$fp->populate($pages[$i]);

			$final_pages[$i] = $fp;
		}

		$data = array("module_instance_id" 		=> $this->module_instance_id,
					  "title" 					=> $this->setting("title"),
					  "title_heading_level" 	=> $this->setting("title_heading_level"),
		              "module_class" 			=> $this->setting("module_class"),
					  "q" 						=> $q,
					  "category_id" 			=> $category_id,
					  "content_type_id" 		=> $content_type_id,
					  "num_featured" 			=> $num_featured,
					  "num_articles" 			=> $num_articles,
					  "num_columns" 			=> $this->setting("num_columns"),
					  "num_columns_featured" 	=> $this->setting("num_columns_featured"),
					  "character_limit" 		=> $this->setting("character_limit"),
					  "read_more_text" 			=> $this->setting("read_more_text"),
					  "show_image" 				=> $this->setting("show_image"),
					  "image_width" 			=> $this->setting("image_width"),
					  "image_height" 			=> $this->setting("image_height"),
					  "image_crop" 				=> $this->setting("crop"),
					  "image_raw" 				=> $this->setting("image_raw"),
					  "show_image_featured" 	=> $this->setting("show_image_featured"),
					  "image_width_featured" 	=> $this->setting("image_width_featured"),
					  "image_height_featured" 	=> $this->setting("image_height_featured"),
					  "image_crop_featured" 	=> $this->setting("crop_featured"),
					  "image_raw_featured" 		=> $this->setting("image_raw_featured"),
					  "show_text" 				=> $this->setting("show_text"),
					  "show_title" 				=> $this->setting("show_title"),
					  "show_date" 				=> $this->setting("show_date"),
					  "do_not_link" 			=> $this->setting("do_not_link"),
					  "heading_level" 			=> $this->setting("heading_level"),
					  "always_show_readmore" 	=> $this->setting("always_show_readmore"),
					  "never_show_readmore" 	=> $this->setting("never_show_readmore"),
					  "strip_tags" 				=> $this->setting("strip_tags"),
					  "search_legend" 			=> $this->setting("search_legend"),
					  "ordering" 				=> $ordering,
					  "total" 					=> $total,
					  "per_page" 				=> $per_page,
					  "next" 					=> $next,
					  "prev" 					=> $prev,
					  "page_number"				=> $page_number,
					  "page_count"				=> $page_count,
					  "categories" 				=> $categories,
					  "layout" 					=> $this->setting("layout"),
					  "year" 					=> $year,
					  "pages" 					=> $final_pages);

		if($this->setting("layout") == "alpha")
		{
			$this->load->view("modules/content_list/alpha", $data);
		}
		else
		{
			$this->load->view("modules/content_list/module", $data);
		}
	}

	public static function year_sort($a, $b)
	{
	    if($a->year == $b->year)
	    {
	        return 0;
	    }
	    return ($a->year > $b->year) ? -1 : 1;
	}
}
