<?php
defined('PRODUCT_NAME') or die;
class DirectoryCouponsModule extends ModuleInstance
{
	var $page_link;

	public function __construct()
	{
		parent::__construct();

		$this->cache_config->user         = true;
		$this->cache_config->url          = true;
		$this->cache_config->query_string = true;
	}

	function render()
	{
		$this->load->model(array("page", "directory_coupon", "directory_company"));

		$page_id = $this->setting("page_id");

		$page = new Page();
		$page->Load($page_id);

		$page_link 				= "/" . $page->url;
		$coupons 				= $this->directory_coupon->LoadBySiteID(Mainframe::site()->site_id);
		$title 					= $this->setting("title");
		$title_heading_level 	= $this->setting("title_heading_level");
		$module_class 			= $this->setting("module_class");
		?>
		<div id="module_<?php echo($this->module_instance_id); ?>" class="module directory-coupons-module <?php echo($module_class); ?>">
			<?php
			if($title && $title_heading_level)
			{
				?><<?php echo($title_heading_level); ?> class="module-title"><?php echo($title); ?></<?php echo($title_heading_level); ?>><?php
			}

			if(count($coupons) > 0)
			{
				?>
				<div class="pure-g">
					<?php
					foreach($coupons as $coupon)
					{
						$company = new Directory_Company();
						$company->Load($coupon->company_id);

						$link = $page_link . "/" . $company->url;
						?>
						<div class="pure-u-1-2">
							<div class="padded coupon">
								<h2 class="coupon-company"><a href="<?php echo($link); ?>"><?php echo($coupon->company); ?></a></h2>
								<div class="coupon-detail"><?php echo($coupon->coupon); ?></div>
								<div class="coupon-validity">
									<?php
									if($coupon->valid_from != NULL && $coupon->valid_to != NULL)
									{
										echo("Valid From " . $coupon->valid_from . " Until " . $coupon->valid_to);
									}
									else if($coupon->valid_from != NULL)
									{
										echo("Valid From " . $coupon->valid_from);
									}
									else if($coupon->valid_to != NULL)
									{
										echo("Valid Until " . $coupon->valid_to);
									}
									?>
								</div>
							</div>
						</div>
						<?php
					}
					?>
				</div>
				<?php
			}
			else
			{
				?><div class="error center">No Coupons Were Found</div><?php
			}
			?>
		</div>
		<?php
	}
}
