<?php
defined('PRODUCT_NAME') or die;
class DocumentsModule extends ModuleInstance
{
	public function __construct()
	{
		parent::__construct();

		$this->cache_config->user         = true;
		$this->cache_config->url          = true;
		$this->cache_config->query_string = true;
	}

	function render()
	{
		$this->load->model(array("document", "category"));

		$q					= filter_var($this->input->get_post("q" . $this->module_instance_id), FILTER_SANITIZE_STRING);
		$page_number		= (int)$this->input->get_post("p");
		$category_id		= (int)$this->input->get_post("c");
		$show_uncategorized	= $this->setting("show_uncategorized");
		$year 				= ($this->setting("layout") == "year" ? ($this->input->get_post("year") ? (int)$this->input->get_post("year") : date("Y")) : null);

		if(!$page_number)
		{
			$page_number = 1;
		}

		$category_id		= ($category_id ? $category_id : $this->setting("category_id"));
		$tag_ids			= $this->setting("tag_ids", null);
		$tag_logic			= $this->setting("tag_logic", "OR");
		$ordering 			= $this->setting("ordering");
		$orderby 			= "`created` DESC";
		$per_page			= $this->setting("per_page");
		$offset 			= ($page_number-1) * $per_page;
		$next 				= false;
		$prev 				= ($page_number > 1 && $per_page > 0 ? $page_number-1 : false);

		if($ordering == "newest_created")
		{
			$orderby = "`created` DESC";
		}
		else if($ordering == "oldest_created")
		{
			$orderby = "`created` ASC";
		}
		else if($ordering == "newest_modified")
		{
			$orderby = "`modified` DESC";
		}
		else if($ordering == "oldest_modified")
		{
			$orderby = "`modified` ASC";
		}
		else if($ordering == "alpha")
		{
			$orderby = "`title` ASC";
		}
		else if($ordering == "category")
		{
			$orderby = "category_name ASC";
		}
		else if($ordering == "random")
		{
			$orderby = "RAND()";
		}

		$categories = array();
		$documents 	= $this->document->loadByCategoryID(Mainframe::site()->site_id, ($category_id || $show_uncategorized ? $category_id : -1), $tag_ids, $tag_logic, $orderby, $q, Mainframe::user());

		if($this->setting("layout") == "year")
		{
			foreach($documents as $d)
			{
				$index = date("Y", strtotime($d->created));

				if(!isset($categories[$index]))
				{
					$categories[$index] = new StdClass();
					$categories[$index]->year = $index;
					$categories[$index]->name = $index;
					$categories[$index]->total = 0;
				}

				$categories[$index]->total++;
			}

			usort($categories, array("DocumentsModule", "year_sort"));

			$documents 	= $this->document->loadByCategoryIDYear(Mainframe::site()->site_id, ($category_id || $show_uncategorized ? $category_id : -1), $tag_ids, $tag_logic, $year, $orderby, $q, Mainframe::user());
		}
		else
		{
			if($this->setting("show_categories"))
			{
				$categories = $this->category->loadDocumentCategories(Mainframe::site()->site_id);
			}
		}

		$total 		= count($documents);
		$page_count = ($per_page > 0 ? ceil($total/$per_page) : 1);
		$next 		= ($page_count > $page_number && $per_page > 0 ? $page_number+1 : false);

		if($per_page > 0)
		{
			if(count($documents) > $per_page)
			{
				$documents = array_splice($documents, $offset, $per_page);
			}
		}

		$data = array("module_instance_id" 		=> $this->module_instance_id,
					  "title" 					=> $this->setting("title"),
					  "title_heading_level" 	=> $this->setting("title_heading_level"),
		              "heading_level" 			=> $this->setting("heading_level"),
		              "module_class" 			=> $this->setting("module_class"),
					  "q" 						=> $q,
					  "category_id" 			=> $category_id,
					  "show_title" 				=> $this->setting("show_title"),
					  "show_date" 				=> $this->setting("show_date"),
					  "show_category" 			=> $this->setting("show_category"),
					  "show_icons" 				=> $this->setting("show_icons"),
					  "show_text" 				=> $this->setting("show_text"),
					  "character_limit" 		=> $this->setting("character_limit"),
					  "search_legend" 			=> $this->setting("search_legend"),
					  "ordering" 				=> $ordering,
					  "total" 					=> $total,
					  "per_page" 				=> $per_page,
					  "num_columns" 			=> $this->setting("num_columns"),
					  "next" 					=> $next,
					  "prev" 					=> $prev,
					  "page_number"				=> $page_number,
					  "page_count"				=> $page_count,
					  "categories"				=> $categories,
					  "show_categories"			=> $this->setting("show_categories"),
					  "show_preview" 			=> $this->setting("show_preview"),
					  "layout" 					=> $this->setting("layout"),
					  "year" 					=> $year,
					  "documents" 				=> $documents);

		if($this->setting("layout") == "alpha")
		{
			$this->load->view("modules/documents/alpha", $data);
		}
		else if($this->setting("layout") == "category")
		{
			$this->load->view("modules/documents/category", $data);
		}
		else
		{
			$this->load->view("modules/documents/module", $data);
		}
	}

	public static function year_sort($a, $b)
	{
	    if($a->year == $b->year)
	    {
	        return 0;
	    }
	    return ($a->year > $b->year) ? -1 : 1;
	}
}
