<?php
defined('PRODUCT_NAME') or die;
class EventsModule extends ModuleInstance
{
	public function __construct()
	{
		parent::__construct();

		$this->cache_config->url          = true;
		$this->cache_config->query_string = true;
	}

	function render()
	{
		$this->load->model(array("event", "event_form"));

		$title 					= $this->setting("title");
		$title_heading_level 	= $this->setting("title_heading_level");
		$module_class 			= $this->setting("module_class");
		$page_id				= $this->setting("page_id");
		$gallery_page_id 		= $this->setting("gallery_page_id");
		$application_page_id	= $this->setting("application_page_id");
		$max_width				= $this->setting("max_width");
		$max_height				= $this->setting("max_height");

		$page = new Page();
		$page->Load($page_id);

		$gallery_page = new Page();
		$gallery_page->Load($gallery_page_id);

		$application_page = new Page();
		$application_page->Load($application_page_id);

		$page_link = "/" . $page->url;
		$gallery_page_link = "/" . $gallery_page->url;
		$application_page_link = "/" . $application_page->url;
		$this_page = "/" . Mainframe::page()->url;

		$events = $this->event->LoadEventStream(Mainframe::site()->site_id);

		$id = $this->input->get_post("id");

		if($id > 0)
		{
			$event = new Event();
			$event->LoadWithDetails($id);
		}
		else
		{
			$url_parts = uri_string();
			$url_parts = explode("/", $url_parts);

			if(count($url_parts) == 2)
			{
				$url = $url_parts[1];
			}
			else if(count($url_parts) == 3)
			{
				$url = $url_parts[2];	//this will be an event ID
			}

			if(isset($url))
			{
				$event = new Event();
				$event->LoadByURL(Mainframe::site()->site_id, $url);
			}
		}

		if(isset($event->event_id))
		{
			//if somebody lands on a parent event's page, we want to check if there is an upcoming child event and load that instead
			if($event->is_parent)
			{
				$temp_events = $this->event->LoadByParentID($event->event_id);

				foreach($temp_events as $event_temp)
				{
					if($event_temp->event_date >= date("Y-m-d"))
					{
						//THIS event is the parent, and our temp event is the child ID
						//$link = $page_link . "/" . $event->url . "/" . $event_temp->event_id;
						//redirect($link);
						$event = clone($event_temp);
						$id = $event->event_id;
					}
				}
			}
		}

		?>
		<div id="module_<?php echo($this->module_instance_id); ?>" class="module events-module <?php echo($module_class); ?>">
			<?php
			if($title && $title_heading_level)
			{
				?><<?php echo($title_heading_level); ?> class="module-title"><?php echo($title); ?></<?php echo($title_heading_level); ?>><?php
			}

			if(isset($event->event_id))
			{
				$parent = new Event();
				$parent->load($event->parent_id);

				//if we have no banner but our parent does, use that.
				if($event->banner_image == null && $parent->banner_image != null)
				{
					$event->banner_image = $parent->banner_image;
				}

				if($event->parent_id == NULL)
				{
					$events = $this->event->LoadByParentID($event->event_id);
				}
				else
				{
					$events = $this->event->LoadByParentID($event->parent_id);
				}

				$forms = $this->event_form->LoadByEventID($event->event_id, $event->parent_id);

				$total_upcoming = 0;
				$total_past = 0;

				//count up the number of events in each section for use later
				foreach($events as $tmp_event)
				{
					if($tmp_event->event_id == $id)	//don't show this event in the list
					{
						continue;
					}

					if($tmp_event->upcoming == 1)
					{
						$total_upcoming++;
					}
					else if($tmp_event->upcoming == 0)
					{
						$total_past++;
					}
				}

				if($event->banner_image && file_exists(ABSOLUTE_PATH . "/images/event-banners/" . $event->banner_image))
				{
					$file 		= ABSOLUTE_PATH . "/images/event-banners/" . $event->banner_image;
					$thumbnail 	= Mainframe::thumbnail($file, $max_width, $max_height, false, Mainframe::site()->webp ? IMAGETYPE_WEBP : null);
					$size 		= @getimagesize(ABSOLUTE_PATH . $thumbnail);

					?><div class="event-banner"><img src="<?php echo(str_replace(ABSOLUTE_PATH, LIVE_SITE, $thumbnail)); ?>" width="<?php echo($size[0]); ?>" alt="<?php echo(htmlentities($event->headline)); ?>" /></div><?php
				}

				if($event->event_date)
				{
					?><h1 class="event-headline"><?php echo($event->headline); ?> - <?php echo($event->event_date > date("Y-m-d") ? " Coming " : "") . date("l, F jS, Y", strtotime($event->event_date)); ?></a></h1><?php
				}
				else
				{
					?><h1 class="event-headline"><?php echo($event->headline); ?></h1><?php
				}
				?>

				<div class="event-anchors pure-g">
					<?php
					$galleries = array();

					if($event->galleries != null)
					{
						$galleries = explode("\n", trim($event->galleries));
					}

					$grid_size = 0;
					$grid_size += (count($forms) > 0 ? 1 : 0);
					$grid_size += ($total_upcoming ? 1 : 0);
					$grid_size += ($total_past ? 1 : 0);
					$grid_size += (count($galleries) > 0 ? 1 : 0);

					if($grid_size == 1)
					{
						$pure_class = "pure-u-sm-1";
						$pure_class2 = "pure-u-md-1";
					}
					else if($grid_size >= 2)
					{
						$pure_class = "pure-u-sm-1-" . $grid_size;
						$pure_class2 = "pure-u-md-1-2";
					}
					else if($grid_size > 1)
					{
						$pure_class = "pure-u-sm-1-" . $grid_size;
						$pure_class2 = "pure-u-md-1-2";
					}
					else
					{
						$pure_class = "";
						$pure_class2 = "";
					}

					if(count($forms) > 0)
					{
						?><div class="pure-u-1 <?php echo($pure_class); ?>"><div class="padded"><a href="<?php echo($this_page); ?>#forms" class="pure-button"><em class="far fa-list-alt" aria-hidden="true"></em> Registration Form<?php echo(count($forms) > 1 ? "s" : ""); ?></a></div></div><?php
					}
					if(count($galleries) > 0)
					{
						?><div class="pure-u-1 <?php echo($pure_class); ?>"><div class="padded"><a href="<?php echo($this_page); ?>#galleries" class="pure-button"><em class="fas fa-camera" aria-hidden="true"></em> Photo Galleries</a></div></div><?php
					}
					if($total_upcoming)
					{
						?><div class="pure-u-1 <?php echo($pure_class); ?>"><div class="padded"><a href="<?php echo($this_page); ?>#upcoming" class="pure-button"><em class="far fa-calendar-alt" aria-hidden="true"></em> Upcoming Dates</a></div></div><?php
					}
					if($total_past)
					{
						?><div class="pure-u-1 <?php echo($pure_class); ?>"><div class="padded"><a href="<?php echo($this_page); ?>#past" class="pure-button"><em class="far fa-calendar-alt" aria-hidden="true"></em> Past Events</a></div></div><?php
					}
					?>
				</div>

				<div class="event-full">
					<?php echo($event->preview . $event->description); ?>
					<div class="clear"></div>
				</div>

				<div class="pure-g">
					<?php
					if(count($forms) > 0)
					{
						?>
						<div class="pure-u-1 <?php echo($pure_class2); ?>">
							<div class="padded">
								<a name="forms" id="forms"></a><h2>Registration Form<?php echo(count($forms) > 1 ? "s" : ""); ?></h2>
								<?php
								foreach($forms as $form)
								{
									?>
									<div><a href="<?php echo($application_page_link); ?>?form_id=<?php echo($form->form_id); ?>" class="pure-button event-quick-link"><?php echo($form->title); ?></a></div>
									<?php
								}
								?>
							</div>
						</div>
						<?php
					}

					if(count($galleries) > 0)
					{
						?>
						<div class="pure-u-1 <?php echo($pure_class2); ?>">
							<div class="padded">
								<a name="galleries" id="galleries"></a><h2>Photo Galleries</h2><?php

								foreach($galleries as $gallery)
								{
									$gallery = trim($gallery);
									$dirname = basename($gallery);
									?><a href="<?php echo($gallery_page_link); ?>?dir=<?php echo($dirname); ?>" title="<?php echo($dirname); ?>" class="pure-button event-quick-link"><?php echo($dirname); ?></a><?php
								}
								?>
							</div>
						</div>
						<?php
					}

					$past = false;
					$count = 0;
					$open = false;

					foreach($events as $temp_event)
					{
						if($temp_event->event_id == $id)	//don't show this event in the list
						{
							continue;
						}
						$count++;
						$link = $page_link;

						if($temp_event->upcoming == 1 && $count == 1)
						{
							if($open)
							{
								?></div></div><?php
								$open = false;
							}

							?>
							<div class="pure-u-1 <?php echo($pure_class2); ?>">
								<div class="padded">
									<a name="upcoming" id="upcoming"></a><h2>Upcoming Dates</h2>
							<?php
							$open = true;
						}
						else if($temp_event->upcoming == 0 && ($count == 1 || !$past))
						{
							if($open)
							{
								?></div></div><?php
								$open = false;
							}

							?>
							<div class="pure-u-1 <?php echo($pure_class2); ?>">
								<div class="padded">
									<a name="past" id="past"></a><h2>Past Events</h2>
							<?php
							$open = true;
							$past = true;
						}

						$parent = new Event();
						$parent->load($temp_event->parent_id);

						if($temp_event->upcoming == 1)
						{
							$link = $page_link . "/" . $parent->url;
						}
						else if($temp_event->upcoming == 0)
						{
							$link = $page_link . "/" . $parent->url . "/" . $temp_event->event_date;
						}

						?><div><a href="<?php echo($link); ?>" class="pure-button event-quick-link"><?php echo($temp_event->headline . " - " . date("Y", strtotime($temp_event->event_date))); ?></a></div><?php
					}

					if($open)
					{
						?></div></div><?php
						$open = false;
					}
					?>
				</div>
				<?php
			}
			else
			{
				$count = 0;
				$past = false;
				$total_upcoming = 0;
				$total_past = 0;

				//count up the number of events in each section for use later
				foreach($events as $event)
				{
					if($event->upcoming == 1)
					{
						$total_upcoming++;
					}
					else if($event->upcoming == 0)
					{
						$total_past++;
					}
				}

				foreach($events as $event)
				{
					$count++;

					if($count == 1)
					{
						$heading = "h1";
					}
					else
					{
						$heading = "h2 class='h1'";
					}

					if($event->upcoming == 1 && $count == 1)
					{
						?><<?php echo($heading); ?>>Upcoming Events</<?php echo($heading); ?>><?php
					}
					else if($event->upcoming == 0 && ($count == 1 || !$past))
					{
						//if count is > 1 when we get here, we know it was because there was an upcoming event - add an hr
						if($count > 1)
						{
							?><hr /><?php
						}
						?><<?php echo($heading); ?>>Past Events Coming Again Soon</<?php echo($heading); ?>><?php
						$past = true;
					}

					//in this case, this link will always take us to the default event page or upcoming event.
					//past events will stay on the default event page.
					//if there's an upcoming event, the event page will handle that and load it up.
					$link = $page_link . "/" . $event->url;
					?>
					<div class="event">
						<?php
						if($event->banner_image && file_exists(ABSOLUTE_PATH . "/images/event-banners/" . $event->banner_image))
						{
							$file 		= ABSOLUTE_PATH . "/images/event-banners/" . $event->banner_image;
							$thumbnail 	= Mainframe::thumbnail($file, $max_width, $max_height, false, Mainframe::site()->webp ? IMAGETYPE_WEBP : null);
							$size 		= @getimagesize(ABSOLUTE_PATH . $thumbnail);

							?><div class="event-banner"><a href="<?php echo($link); ?>"><?php
							if($event->upcoming)
							{
								?><div class="event-badge event-badge-upcoming"><span class="event-badge-text"><?php echo(date("F jS", strtotime($event->event_date))); ?></span></div><?php
							}
							else if(!$event->upcoming)
							{
								?><div class="event-badge event-badge-past"><span class="event-badge-text">Next <?php echo(date("F", strtotime($event->event_date . " +1 year"))); ?></span></div><?php
							}
							?><img src="<?php echo(str_replace(ABSOLUTE_PATH, LIVE_SITE, $thumbnail)); ?>" width="<?php echo($size[0]); ?>" alt="<?php echo(htmlentities($event->headline)); ?>" /></a></div><?php
						}
						?>
						<h2><a href="<?php echo($link); ?>"><?php echo($event->headline); ?> - <?php echo($event->upcoming ? "Coming" : "Last Event Was"); ?> <?php echo(date("l, F jS, Y", strtotime($event->event_date))); ?></a></h2>
						<div class="event-preview"><?php echo($event->preview); ?></div>
						<div class="event-buttons"><a href="<?php echo($link); ?>" class="pure-button"><em class="far fa-calendar-alt" aria-hidden="true"></em> View Event Details</a></div>
						<div class="clear"></div>
						<?php
						//do not put out an HR for the last item in each section
						if((!$past && $count != $total_upcoming) || ($past && $count != ($total_past+$total_upcoming)))
						{
							?><hr /><?php
						}
						?>
					</div>
					<?php
				}
			}
			?>
		</div>
		<?php
	}
}
