<?php
defined('PRODUCT_NAME') or die;
class EventsApplicationModule extends ModuleInstance
{
	private $page_link = "";

	public function __construct()
	{
		parent::__construct();
		$this->include_jquery        = true;
		$this->cache_config->enabled = false;
	}

	function render()
	{
		$this->load->model(array("event", "event_form"));

		$page_id				= $this->setting("page_id");
		$title 					= $this->setting("title");
		$title_heading_level 	= $this->setting("title_heading_level");
		$module_class 			= $this->setting("module_class");

		$page = new Page();
		$page->Load($page_id);

		$this->page_link = "/" . $page->url;

		$step = 1;

		$url_parts = uri_string();
		$url_parts = explode("/", $url_parts);

		if(count($url_parts) == 2)
		{
			$step = $url_parts[1];
		}

		$this->save_session();

		//if we're on the first step but already have a form ID passed in, jump to step 2
		if($step <= 1 && $this->input->get_post("form_id"))
		{
			$step = 2;
		}

		?>
		<div id="module_<?php echo($this->module_instance_id); ?>" class="module events-application-module <?php echo($module_class); ?>">
			<?php
			if($title && $title_heading_level)
			{
				?><<?php echo($title_heading_level); ?> class="module-title"><?php echo($title); ?></<?php echo($title_heading_level); ?>><?php
			}

			switch($step)
			{
				default:
				case 1:
				{
					$this->progress(1);
					$this->step1();
					break;
				}
				case 2:
				{
					$this->progress(3);
					$this->subheader();
					$this->step2();
					break;
				}
				case 3:
				{
					$this->progress(5);
					$this->subheader();
					$this->step3();
					break;
				}
				case 4:
				{
					$this->progress(7);
					$this->subheader();
					$this->step4();
					break;
				}
				case "email":
				{
					$this->progress(7);
					$this->subheader();
					$this->send_email();
					$this->step4();

					break;
				}
			}
			?>
		</div>

		<script>
		jQuery(window).on("load", function()
		{
			jQuery("#numberspaces").change(function()
			{
				var price 	= Number(jQuery("#form-fee").val());
				var qty 	= Number(jQuery(this).val());

				jQuery("span.form-fee").html("$" + number_format(price * qty, 2, ".", ","));
			});
		});
		</script>
		<?php
	}

	private function save_session()
	{
		if($this->input->get_post("form_id"))
		{
			$_SESSION["form_id"] = $this->input->get_post("form_id");
		}
		if($this->input->get_post("company"))
		{
			$_SESSION["company"] = $this->input->get_post("company");
		}

		if($this->input->get_post("name"))
		{
			$_SESSION["name"] = $this->input->get_post("name");
		}

		if($this->input->get_post("address"))
		{
			$_SESSION["address"] = $this->input->get_post("address");
		}

		if($this->input->get_post("city"))
		{
			$_SESSION["city"] = $this->input->get_post("city");
		}

		if($this->input->get_post("postalcode"))
		{
			$_SESSION["postalcode"] = $this->input->get_post("postalcode");
		}

		if($this->input->get_post("phone"))
		{
			$_SESSION["phone"] = $this->input->get_post("phone");
		}

		if($this->input->get_post("fax"))
		{
			$_SESSION["fax"] = $this->input->get_post("fax");
		}

		if($this->input->get_post("email"))
		{
			$_SESSION["email"] = $this->input->get_post("email");
		}
		if($this->input->get_post("website"))
		{
			$_SESSION["website"] = $this->input->get_post("website");
		}

		if($this->input->get_post("craft"))
		{
			$_SESSION["craft"] = $this->input->get_post("craft");
		}
		if($this->input->get_post("firsttime"))
		{
			$_SESSION["firsttime"] = $this->input->get_post("firsttime");
		}
		if($this->input->get_post("edibleproduct"))
		{
			$_SESSION["edibleproduct"] = $this->input->get_post("edibleproduct");
		}
		if($this->input->get_post("onsitecooking"))
		{
			$_SESSION["onsitecooking"] = $this->input->get_post("onsitecooking");
		}
		if($this->input->get_post("dimensions"))
		{
			$_SESSION["dimensions"] = $this->input->get_post("dimensions");
		}
		if($this->input->get_post("numberspaces"))
		{
			$_SESSION["numberspaces"] = $this->input->get_post("numberspaces");
		}
		if($this->input->get_post("comments"))
		{
			$_SESSION["comments"] = $this->input->get_post("comments");
		}

		if($this->input->get_post("email_form"))
		{
			$_SESSION["email_form"] = $this->input->get_post("email_form");
		}
	}

	private function progress($step)
	{
		?>
		<aside>
			<progress max="8" value="<?php echo($step); ?>" style="width: 100%;"></progress>

			<div class="pure-g">
				<div class="pure-u-1-4"><div class="padded center"><a href="<?php echo($this->page_link); ?>">1. Event Selection</a></div></div>
				<div class="pure-u-1-4"><div class="padded center"><a href="<?php echo($this->page_link); ?>/2">2. Application Rules and Regulations</a></div></div>
				<div class="pure-u-1-4"><div class="padded center"><a href="<?php echo($this->page_link); ?>/3">3. Provide Information</a></div></div>
				<div class="pure-u-1-4"><div class="padded center"><a href="<?php echo($this->page_link); ?>/4">4. Download &amp; Print</a></div></div>
			</div>
		</aside>
		<?php
	}

	private function subheader()
	{
		if(!$_SESSION["form_id"])
		{
			redirect($this->page_link);	//go back to step 1
			return;
		}

		$form = new Event_Form();
		$form->Load($_SESSION["form_id"]);

		if($form->form_id <= 0)
		{
			redirect($this->page_link);	//go back to step 1
			return;
		}
		?>
		<aside class="pure-g">
			<div class="pure-u-1 pure-u-sm-2-3">
				<div class="padded">
					<h2><?php echo($form->title); ?></h2>
				</div>
			</div>
			<div class="pure-u-1 pure-u-sm-1-3">
				<div class="padded">
					<p>The fee for this event is <span class="form-fee">$<?php echo(number_format($form->fee * (isset($_SESSION["numberspaces"]) ? $_SESSION["numberspaces"] : 1), 2)); ?></span></p>
				</div>
			</div>
		</aside>
		<?php
	}

	private function step1()
	{
		$forms = $this->event_form->LoadActive();
		$link = $this->page_link . "/2";

		?>
		<div class="padded">
			<h2>Event Selection</h2>
		</div>

		<?php
		foreach($forms as $form)
		{
			?>
			<form action="<?php echo($link); ?>" method="post">
				<?php
				csrf();
				FeralHidden("form_id", $form->form_id);
				?>

				<div class="event-application-choice pure-g">
					<div class="pure-u-1 pure-u-md-1-3">
						<div class="padded">
							<b><?php echo($form->title); ?></b>
						</div>
					</div>
					<div class="pure-u-1 pure-u-md-1-3">
						<div class="padded">
							<div class="nowrap"><label class="bold">Fee:</label> <span class="form-fee">$<?php echo(number_format($form->fee * (isset($_SESSION["numberspaces"]) ? $_SESSION["numberspaces"] : 1), 2)); ?></span></div>
							<div class="nowrap"><label class="bold">Deadline:</label> <?php echo(date("l, F jS, Y", strtotime($form->registration_end))); ?></div>
						</div>
					</div>
					<div class="pure-u-1 pure-u-md-1-3">
						<div class="padded right">
							<button type="submit" class="pure-button event-quick-link">Apply For This Event&nbsp;&nbsp;&nbsp;<em class="fas fa-arrow-right" aria-hidden="true"></em></button>
						</div>
					</div>
				</div>
			</form>
			<?php
		}
	}
	private function step2()
	{
		$form = new Event_Form();
		$form->Load($_SESSION["form_id"]);
		?>
		<div class="padded">
			<h3>Application Rules and Regulations</h3>

			<div class="event-terms"><?php echo($form->terms); ?></div>
			<p>&nbsp;</p>

			<form name="step2" action="<?php echo($this->page_link); ?>/3" method="post" class="pure-form pure-form-aligned">
				<?php csrf(); ?>
				<div class="pure-control-group">
					<label for="terms">I Agree <sup class="required">*</sup></label>
					<?php
					$wgt = new FeralCheckboxWidget("terms", isset($_SESSION["terms"]) ? $_SESSION["terms"] : false);
					$wgt->SetAttribute("required", "required");
					$wgt->Create();
					?>
				</div>
				<div class="center">
					<button type="submit" class="pure-button">Continue&nbsp;&nbsp;&nbsp;<em class="fas fa-arrow-right" aria-hidden="true"></em></button>
				</div>
			</form>
		</div>
		<?php
	}
	private function step3()
	{
		$form = new Event_Form();
		$form->Load($_SESSION["form_id"]);
		?>
		<div class="padded">
			<h3>Provide Information</h3>
			<form name="step3" action="<?php echo($this->page_link); ?>/4" method="post" class="pure-form pure-form-aligned">
				<?php csrf(); ?>
				<input type="hidden" name="form-fee" id="form-fee" value="<?php echo($form->fee); ?>" />
				<div class="pure-g">
					<div class="pure-u-1 pure-u-md-1-2">
						<div class="padded">
							<div class="pure-control-group">
								<label for="company">Company Name <sup class="required">*</sup></label>
								<?php
								$wgt = new FeralTextWidget("company", isset($_SESSION["company"]) ? $_SESSION["company"] : "");
								$wgt->SetAttribute("required", "required");
								$wgt->Create();
								?>
							</div>
							<div class="pure-control-group">
								<label for="name">Contact Name <sup class="required">*</sup></label>
								<?php
								$wgt = new FeralTextWidget("name", isset($_SESSION["name"]) ? $_SESSION["name"] : "");
								$wgt->SetAttribute("required", "required");
								$wgt->Create();
								?>
							</div>
							<div class="pure-control-group">
								<label for="address">Address <sup class="required">*</sup></label>
								<?php
								$wgt = new FeralTextWidget("address", isset($_SESSION["address"]) ? $_SESSION["address"] : "");
								$wgt->SetAttribute("required", "required");
								$wgt->Create();
								?>
							</div>
							<div class="pure-control-group">
								<label for="city">City <sup class="required">*</sup></label>
								<?php
								$wgt = new FeralTextWidget("city", isset($_SESSION["city"]) ? $_SESSION["city"] : "");
								$wgt->SetAttribute("required", "required");
								$wgt->Create();
								?>
							</div>
							<div class="pure-control-group">
								<label for="postalcode">Postal Code <sup class="required">*</sup></label>
								<?php
								$wgt = new FeralTextWidget("postalcode", isset($_SESSION["postalcode"]) ? $_SESSION["postalcode"] : "");
								$wgt->SetAttribute("required", "required");
								$wgt->Create();
								?>
							</div>
						</div>
					</div>

					<div class="pure-u-1 pure-u-md-1-2">
						<div class="padded">
							<div class="pure-control-group">
								<label for="phone">Phone <sup class="required">*</sup></label>
								<?php
								$wgt = new FeralTextWidget("phone", isset($_SESSION["phone"]) ? $_SESSION["phone"] : "");
								$wgt->SetAttribute("required", "required");
								$wgt->SetAttribute("type", "tel");
								$wgt->Create();
								?>
							</div>
							<div class="pure-control-group">
								<label for="fax">Fax</label>
								<?php
								$wgt = new FeralTextWidget("fax", isset($_SESSION["fax"]) ? $_SESSION["fax"] : "");
								$wgt->SetAttribute("type", "tel");
								$wgt->Create();
								?>
							</div>
							<div class="pure-control-group">
								<label for="email">Email <sup class="required">*</sup></label>
								<?php
								$wgt = new FeralTextWidget("email", isset($_SESSION["email"]) ? $_SESSION["email"] : "");
								$wgt->SetAttribute("required", "required");
								$wgt->SetAttribute("type", "email");
								$wgt->Create();
								?>
							</div>
							<div class="pure-control-group">
								<label for="website">Website</label>
								<?php
								$wgt = new FeralTextWidget("website", isset($_SESSION["website"]) ? $_SESSION["website"] : "");
								$wgt->Create();
								?>
							</div>
							<div class="pure-control-group">
								<label for="craft">Describe Your Product <sup class="required">*</sup></label>
								<textarea name="craft" id="craft" required><?php echo(isset($_SESSION["craft"]) ? $_SESSION["craft"] : ""); ?></textarea>
							</div>
						</div>
					</div>
					<div class="pure-u-1 pure-u-md-1-2 pure-form-stacked">
						<div class="padded">
							<div class="pure-control-group">
								<label for="firsttime_yes">Are you a first time vendor? <sup class="required">*</sup></label>
								<?php
								$wgt = new FeralRadioWidget("firsttime", "1", isset($_SESSION["firsttime"]) ? $_SESSION["firsttime"] : "");
								$wgt->SetAttribute("required", "required");
								$wgt->SetAttribute("id", "firsttime_yes");
								$wgt->Create();
								?> Yes&nbsp;&nbsp;&nbsp;&nbsp;

								<?php
								$wgt = new FeralRadioWidget("firsttime", "0", isset($_SESSION["firsttime"]) ? $_SESSION["firsttime"] : "");
								$wgt->SetAttribute("required", "required");
								$wgt->SetAttribute("id", "firsttime_no");
								$wgt->Create();
								?> No
							</div>

							<div class="pure-control-group">
								<label for="edibleproduct_yes">Are you selling an edible product? <sup class="required">*</sup></label>
								<?php
								$wgt = new FeralRadioWidget("edibleproduct", "1", isset($_SESSION["edibleproduct"]) ? $_SESSION["edibleproduct"] : "");
								$wgt->SetAttribute("required", "required");
								$wgt->SetAttribute("id", "edibleproduct_yes");
								$wgt->Create();
								?> Yes&nbsp;&nbsp;&nbsp;&nbsp;

								<?php
								$wgt = new FeralRadioWidget("edibleproduct", "0", isset($_SESSION["edibleproduct"]) ? $_SESSION["edibleproduct"] : "");
								$wgt->SetAttribute("required", "required");
								$wgt->SetAttribute("id", "edibleproduct_no");
								$wgt->Create();
								?> No
							</div>

							<div class="pure-control-group">
								<label for="onsitecooking_yes">Will you have on-site cooking capabilities? <sup class="required">*</sup></label>
								<?php
								$wgt = new FeralRadioWidget("onsitecooking", "1", isset($_SESSION["onsitecooking"]) ? $_SESSION["onsitecooking"] : "");
								$wgt->SetAttribute("required", "required");
								$wgt->SetAttribute("id", "onsitecooking_yes");
								$wgt->Create();
								?> Yes&nbsp;&nbsp;&nbsp;&nbsp;

								<?php
								$wgt = new FeralRadioWidget("onsitecooking", "0", isset($_SESSION["onsitecooking"]) ? $_SESSION["onsitecooking"] : "");
								$wgt->SetAttribute("required", "required");
								$wgt->SetAttribute("id", "onsitecooking_no");
								$wgt->Create();
								?> No
							</div>
						</div>
					</div>
					<div class="pure-u-1 pure-u-md-1-2 pure-form-stacked">
						<div class="padded">
							<div class="pure-control-group">
								<label for="dimensions">Dimensions of food truck, trailer, cart (if applicable)</label>
								<textarea name="dimensions" id="dimensions"><?php echo(isset($_SESSION["dimensions"]) ? $_SESSION["dimensions"] : ""); ?></textarea>
							</div>
						</div>
					</div>

					<div class="pure-u-1 pure-u-md-1-2 pure-form-stacked">
						<div class="padded">
							<div class="pure-control-group">
								<label for="dimensions">Vendor Spaces</label>
								<?php
								$wgt = new FeralBasicSelectWidget("numberspaces", (isset($_SESSION["numberspaces"]) ? $_SESSION["numberspaces"] : 1));
								$wgt->SetAttribute("required", "required");
								$wgt->AddOption(1);
								$wgt->AddOption(2);
								$wgt->AddOption(3);
								$wgt->AddOption(4);
								$wgt->AddOption(5);
								$wgt->Create();
								?>
							</div>
						</div>
					</div>
					<div class="pure-u-1 pure-u-md-1-2 pure-form-stacked">
						<div class="padded">
							<div class="pure-control-group">
								<label for="comments">Comments</label>
								<textarea name="comments" id="comments"><?php echo(isset($_SESSION["comments"]) ? $_SESSION["comments"] : ""); ?></textarea>
							</div>
						</div>
					</div>
				</div>

				<div class="center">
					<button type="submit" class="pure-button">Continue&nbsp;&nbsp;&nbsp;<em class="fas fa-arrow-right" aria-hidden="true"></em></button>
				</div>
			</form>
		</div>
		<?php
	}

	private function step4()
	{
		if(!$_SESSION["form_id"])
		{
			redirect($this->page_link);	//go back to step 1
			return;
		}

		$form = new Event_Form();
		$form->Load($_SESSION["form_id"]);

		if($form->form_id <= 0)
		{
			redirect($this->page_link);	//go back to step 1
			return;
		}

		$instructions = $this->setting("instructions");

		$filename = $this->pdf();
		$this->clean_temp_dir();
		?>
		<div class="padded">
			<h3>Download &amp; Print</h3>
		</div>

		<div class="pure-g">
			<div class="pure-u-1 pure-u-md-1-2">
				<div class="padded center">
					<a href="<?php echo($filename); ?>" target="_blank" class="pure-button event-quick-link"><em class="fas fa-cloud-download-alt" aria-hidden="true"></em> Download a PDF ready for signing</a>
				</div>
			</div>

			<div class="pure-u-1 pure-u-md-1-2">
				<div class="padded center">
					<form action="<?php echo($this->page_link); ?>/email" method="post" class="pure-form pure-form-aligned">
						<?php
						csrf();
						FeralHidden("filename", $filename);
						?>
						<div><button type="submit" class="pure-button event-quick-link"><em class="fas fa-envelope" aria-hidden="true"></em> Email a PDF to the address below</button></div>
						<div>
							<?php
							$wgt = new FeralTextWidget("email_form", ($this->input->post("email_form") ? $this->input->post("email_form") : $_SESSION["email"]));
							$wgt->SetAttribute("required", "required");
							$wgt->SetAttribute("type", "email");
							$wgt->Create();
							?>
						</div>
					</form>
				</div>
			</div>
		</div>

		<div class="padded">
			<?php
			echo($instructions);
			?>
		</div>
		<?php
	}

	/**
	 * Remove old application forms older than 1 day.
	 */
	private function clean_temp_dir()
	{
		$files = scandir(ABSOLUTE_PATH . "/temp/");

		foreach($files as $file)
		{
			$filename = ABSOLUTE_PATH . "/temp/" . $file;

			if(is_file($filename) && preg_match('/.*Application.*\.pdf$/', $file) && filemtime($filename) <= strtotime("-1 day"))
			{
				@unlink($filename);
			}
		}
	}

	private function pdf()
	{
		$this->load->model(array("event", "event_form"));

		$form = new Event_Form();
		$form->Load($_SESSION["form_id"]);

		$instructions	= $this->setting("instructions");
		$pdf_header		= $this->setting("pdf_header");

		$html = "";
		$html .= $pdf_header;
		$html .= '<h1>' . $form->title . " Application Form</h1>";
		$html .= "<p><b>Application Generated:</b> " 			. date("l, F jS, Y \a\\t g:ia") . "</p>";
		$html .= "<p><b>Application Deadline:</b> " 			. date("l, F jS, Y", strtotime($form->registration_end)) . "</p>";
		$html .= "<p><b>Company Name:</b> " 					. (isset($_SESSION["company"]) ? $_SESSION["company"] : "&nbsp;") . "</p>";
		$html .= "<p><b>Contact Name:</b> " 					. (isset($_SESSION["name"]) ? $_SESSION["name"] : "&nbsp;") . "</p>";
		$html .= "<p><b>Address:</b> " 							. (isset($_SESSION["address"]) ? $_SESSION["address"] : "&nbsp;") . "</p>";
		$html .= "<p><b>City:</b> " 							. (isset($_SESSION["city"]) ? $_SESSION["city"] : "&nbsp;") . "</p>";
		$html .= "<p><b>Postal Code:</b> " 						. (isset($_SESSION["postalcode"]) ? $_SESSION["postalcode"] : "&nbsp;") . "</p>";
		$html .= "<p><b>Phone:</b> " 							. (isset($_SESSION["phone"]) ? $_SESSION["phone"] : "&nbsp;") . "</p>";
		$html .= "<p><b>Fax:</b> " 								. (isset($_SESSION["fax"]) ? $_SESSION["fax"] : "&nbsp;") . "</p>";
		$html .= "<p><b>Email:</b> " 							. (isset($_SESSION["email"]) ? $_SESSION["email"] : "&nbsp;") . "</p>";
		$html .= "<p><b>Website:</b> " 							. (isset($_SESSION["website"]) ? $_SESSION["website"] : "&nbsp;") . "</p>";
		$html .= "<p><b>Product:</b> " 							. (isset($_SESSION["craft"]) ? $_SESSION["craft"] : "&nbsp;") . "</p>";
		$html .= "<p><b>Craft:</b> " 							. (isset($_SESSION["craft"]) ? $_SESSION["craft"] : "&nbsp;") . "</p>";
		$html .= "<p><b>First Time?</b> " 						. (isset($_SESSION["firsttime"]) && $_SESSION["firsttime"] == "1" ? "Yes" : "No") . "</p>";
		$html .= "<p><b>Edible Product?</b> " 					. (isset($_SESSION["edibleproduct"]) && $_SESSION["edibleproduct"] == "1" ? "Yes" : "No") . "</p>";
		$html .= "<p><b>Onsite Cooking Capabilities:</b> " 		. (isset($_SESSION["onsitecooking"]) && $_SESSION["onsitecooking"] == "1" ? "Yes" : "No") . "</p>";
		$html .= "<p><b>Dimensions of truck/trailer/cart:</b> " . (isset($_SESSION["dimensions"]) && $_SESSION["dimensions"] == "1" ? "Yes" : "No") . "</p>";
		$html .= "<p><b># of Spaces:</b> " 						. (isset($_SESSION["numberspaces"]) ? $_SESSION["numberspaces"] : "&nbsp;") . "</p>";
		$html .= "<p><b>Comments:</b> " 						. (isset($_SESSION["comments"]) ? $_SESSION["comments"] : "&nbsp;") . "</p>";
		$html .= "<p><b>Payment Enclosed:</b> $" 				. number_format($form->fee * (isset($_SESSION["numberspaces"]) ? $_SESSION["numberspaces"] : 1), 2) . "</p>";
		$html .= "<p>&nbsp;</p>";
		$html .= "<p><b>Signature:</b> " 						. str_pad("", 50, "_") . "</p>";

		$html .= '<h1 style="text-align: center;">' . $form->title . "</h1>";

		if($form->terms)
		{
			$html .= '<h2 style="text-align: center;">Rules and Regulations</h2>';
			$html .= "<div>" . $form->terms . "</div>";
		}
		$html .= $instructions;

		$filename = ABSOLUTE_PATH . "/temp/Application " . sha1(print_r($_SESSION, true)) . ".pdf";
		//delete the file if it already exists
		@unlink($filename);

		$title = $form->title . " Application";
		file_put_contents($filename, Latex::latex_pdf($title, $title, $html, true, false, $title, "bare.tex"));

		return str_replace(ABSOLUTE_PATH, LIVE_SITE, $filename);
	}

	private function send_email()
	{
		$site = Mainframe::site();
		$form = new Event_Form();
		$form->Load($_SESSION["form_id"]);

		$instructions = $this->setting("instructions");

		$mail = get_mailer();
		$mail->SetFrom($site->mail_username, ($site->mail_from ? $site->mail_from : COMPANY_NAME));
	    $mail->ClearReplyTos();
		$mail->AddReplyTo(($site->mail_replyto ? $site->mail_replyto : COMPANY_EMAIL), ($site->mail_from ? $site->mail_from : COMPANY_NAME));
		$mail->AddAddress($this->input->post("email_form"));
		$mail->Subject = $form->title . " Application";
		$body = "<p>Your application form for " . $form->title . " is attached.</p>";
		$body .= $instructions;
		$mail->MsgHTML($body);
		$mail->AddAttachment(str_replace(LIVE_SITE, ABSOLUTE_PATH, $this->input->post("filename")));

		if($mail->Send())
		{
			?><div class="success">Your application was sent to <?php echo($this->input->post("email_form")); ?>.</div><?php
		}
		else
		{
			?><div class="error">There was an error sending your application.</div><?php
		}
	}
}
