<?php
defined('PRODUCT_NAME') or die;
class Galleria extends ModuleInstance
{
	public function __construct()
	{
		parent::__construct();
		$this->scripts = array("<script async src=\"modules/galleria/galleria/galleria-1.2.4.min.js\"></script>",
								"<script async src=\"modules/galleria/galleria/themes/classic/galleria.classic.js\"></script>",
								"<link rel=\"stylesheet\" href=\"modules/galleria/galleria/themes/classic/galleria.classic.css\" />");
		$this->enable_jquery = true;
	}

	function render()
	{
		$title 					= $this->setting("title");
		$title_heading_level 	= $this->setting("title_heading_level");
		$module_class 			= $this->setting("module_class");
		$base					= $this->setting("directory");
		$max_width				= $this->setting("max_width");
		$max_height				= $this->setting("max_height");
		$autoplay				= ($this->setting("autoplay") * 1000);

		//sanitize input
		$dir = filter_input(INPUT_GET, "dir", FILTER_SANITIZE_STRING);
		$dir = str_replace("../", "", $dir);

		if($dir)
		{
			//add sub directory to current path
			$base .= "/$dir/";
		}

		$directory = ABSOLUTE_PATH . "/" . stripslashes($base);
		$directory2 = ABSOLUTE_PATH;

		$files = @scandir($directory);

		if(count($files) <= 2)
		{
			return;
		}

		$content = "";

		?>
		<div id="module_<?php echo($this->module_instance_id); ?>" class="module galleria-module <?php echo($module_class); ?>">
			<?php
			if($title && $title_heading_level)
			{
				?><<?php echo($title_heading_level); ?> class="module-title"><?php echo($title); ?></<?php echo($title_heading_level); ?>><?php
			}

			foreach($files as $file)
			{
				if($file != "." && $file != "..")
				{
					$ext = strtolower(substr($file, strrpos($file, ".")+1));

					switch($ext)
					{
						case "jpg":
						case "jpeg":
						case "png":
						case "gif":
						case "bmp":
						{
							$this->image("$base/$file", $directory2, $max_width, $max_height);

							break;
						}
					}
				}
			}
			?>
		</div>

		<script>
			jQuery(window).on("load", function()
			{
				jQuery('#module_<?php echo($this->module_instance_id); ?>').galleria({
			        width:<?php echo $max_width?>,
			        height:<?php echo $max_height?>,
			        autoplay: <?php echo $autoplay?>,
			        lightbox: true,
			        showCounter: false,
			        preload: "all"
			    });
			});
		</script>
		<?php
	}

	function image($file, $directory, $max_width, $max_height)
	{
		// Ensure that the full size image isn't astronomically huge.
		$file 		= Mainframe::thumbnail($file, 1280, 1024, false, Mainframe::site()->webp ? IMAGETYPE_WEBP : null);
		$file 		= str_replace("//", "/", $file);
		$size 		= getimagesize($file);
		$thumbnail 	= Mainframe::thumbnail("$directory/$file", $max_width, $max_height, false, Mainframe::site()->webp ? IMAGETYPE_WEBP : null);
		$size 		= @getimagesize(ABSOLUTE_PATH . $thumbnail);
		$resized 	= true;
		$width 		= $size[0];
		$height 	= $size[1];
		?>
		<a href="<?php echo($file); ?>"><img src="<?php echo($thumbnail); ?>" /></a>
		<?php
	}
}
