<?php
defined('PRODUCT_NAME') or die;
class Header1Module extends ModuleInstance
{
	public function __construct()
	{
		parent::__construct();

		$this->children[]            = $this->get_module_id("accessibility", "Accessibility Controls");
		$this->children[]            = $this->get_module_id("menu", "Secondary Menu");
		$this->children[]            = $this->get_module_id("logo", "Logo");
		$this->children[]            = $this->get_module_id("contact_info", "Contact Info");
		$this->children[]            = $this->get_module_id("social", "Social Media Icons");
		$this->children[]            = $this->get_module_id("menu", "Main Menu");
		$this->cache_config->enabled = false;
	}

	public function install()
	{
		$settings = array("text_customize" 	=> "Customize Font and Colours",
		                  "icon" 			=> "fa-eye fas");
		$this->install_module("accessibility", "Accessibility Controls", 1, false, $settings);

		$settings = array("menu_id" 	=> 2,
		                  "style" 		=> "horizontal",
		                  "responsive" 	=> 0,
		                  "hover" 		=> 0);
		$this->install_module("menu", "Secondary Menu", 1, false, $settings);

		$settings = array("logo_path" => "",
		                  "logo_text" => COMPANY_NAME,
		                  "logo_link" => "/");
		$this->install_module("logo", "Logo", 1, false, $settings);

		$settings = array("phone_numbers_icon" 	=> "fa-phone fas",
		                  "phone_numbers" 		=> "",
		                  "hours_icon" 			=> "fa-clock far",
		                  "hours" 				=> "",
		                  "address_icon" 		=> "fa-calendar-alt far",
		                  "address" 			=> "");
		$this->install_module("contact_info", "Contact Info", 1, false, $settings);

		$settings = array("facebook" 	=> "",
		                  "twitter" 	=> "",
		                  "gplus" 		=> "",
		                  "flickr" 		=> "",
		                  "pinterest" 	=> "");
		$this->install_module("social", "Social Media Icons", 1, false, $settings);

		$settings = array("menu_id" 	=> 1,
		                  "style" 		=> "horizontal",
		                  "responsive" 	=> 1,
		                  "hover" 		=> 1);
		$this->install_module("menu", "Main Menu", 1, false, $settings);
	}

	function render()
	{
		$data = array("module_instance_id" 	=> $this->module_instance_id,
					  "child_ids" 			=> $this->children());

		$this->load->view("modules/header1/module", $data);
	}
}
