<?php
defined('PRODUCT_NAME') or die;
class InstagramSlider extends ModuleInstance
{
	public function __construct()
	{
		parent::__construct();
		$this->cache_config->enabled = false;
	}

	// Using load() instead of __construct() allows us to access module settings.
	// Potential reproducssions of this are still unknown.
	function load($id)
	{
		parent::load($id);

		$theme 			= $this->setting("lightbox_theme");
		$lightbox		= $this->setting("lightbox");
		$default_link 	= $this->setting("link");
		$this->scripts 	= array();

		// Only include this CSS file if there's going to be a lightbox, otherwise it can conflict with the gallery.
		if($lightbox && $theme)
		{
			$this->scripts = array_merge($this->scripts, array("<link rel=\"stylesheet\" href=\"/modules/instagram_slider/" . $theme . "/colorbox.css\" />"));
		}
		$this->scripts =  array_merge($this->scripts,
                          array("<script async src=\"/modules/instagram_slider/jquery.bxslider.min.js\"></script>",
								"<script async src=\"/modules/instagram_slider/plugins/jquery.easing.1.3.js\"></script>",
								"<script async src=\"/modules/instagram_slider/plugins/jquery.fitvids.js\"></script>",
								"<script async src=\"/modules/instagram_slider/jquery.colorbox-min.js\"></script>"
								));

		$this->enable_jquery = true;
	}

	function render($files = null)
	{
		$module_class 					= $this->setting("module_class");
		$instagram_username				= $this->setting("instagram_username");
		$access_token					= $this->setting("access_token");
		$lightbox						= $this->setting("lightbox");
		$lightbox_width					= $this->setting("lightbox_width");
		$lightbox_height				= $this->setting("lightbox_height");
		$config_mode 					= $this->setting("mode");
		$config_speed 					= $this->setting("speed");
		$config_slideMargin 			= $this->setting("slideMargin");
		$config_startSlide 				= $this->setting("startSlide");
		$config_randomStart 			= $this->setting("randomStart");
		$config_slideSelector 			= $this->setting("slideSelector");
		$config_infiniteLoop 			= $this->setting("infiniteLoop");
		$config_hideControlOnEnd 		= $this->setting("hideControlOnEnd");
		$config_easing 					= $this->setting("easing");
		$config_captions 				= $this->setting("captions");
		$config_ticker 					= $this->setting("ticker");
		$config_tickerHover 			= $this->setting("tickerHover");
		$config_adaptiveHeight 			= $this->setting("adaptiveHeight");
		$config_adaptiveHeightSpeed 	= $this->setting("adaptiveHeightSpeed");
		$config_video 					= $this->setting("video");
		$config_responsive 				= $this->setting("responsive");
		$config_useCSS 					= $this->setting("useCSS");
		$config_preloadImages 			= $this->setting("preloadImages");
		$config_touchEnabled 			= $this->setting("touchEnabled");
		$config_swipeThreshold 			= $this->setting("swipeThreshold");
		$config_oneToOneTouch 			= $this->setting("oneToOneTouch");
		$config_preventDefaultSwipeX 	= $this->setting("preventDefaultSwipeX");
		$config_preventDefaultSwipeY 	= $this->setting("preventDefaultSwipeY");
		$config_pager 					= $this->setting("pager");
		$config_pagerType 				= $this->setting("pagerType");
		$config_pagerShortSeparator 	= $this->setting("pagerShortSeparator");
		$config_pagerSelector 			= $this->setting("pagerSelector");
		$config_pagerCustom 			= $this->setting("pagerCustom");
		$config_buildPager 				= $this->setting("buildPager");
		$config_controls 				= $this->setting("controls");
		$config_nextText 				= $this->setting("nextText");
		$config_prevText 				= $this->setting("prevText");
		$config_nextSelector 			= $this->setting("nextSelector");
		$config_prevSelector 			= $this->setting("prevSelector");
		$config_autoControls 			= $this->setting("autoControls");
		$config_startText 				= $this->setting("startText");
		$config_stopText 				= $this->setting("stopText");
		$config_autoControlsCombine 	= $this->setting("autoControlsCombine");
		$config_autoControlsSelector 	= $this->setting("autoControlsSelector");
		$config_auto 					= $this->setting("auto");
		$config_pause 					= $this->setting("pause");
		$config_autoStart 				= $this->setting("autoStart");
		$config_autoDirection 			= $this->setting("autoDirection");
		$config_autoHover 				= $this->setting("autoHover");
		$config_autoDelay 				= $this->setting("autoDelay");
		$config_minSlides 				= $this->setting("minSlides");
		$config_maxSlides 				= $this->setting("maxSlides");
		$config_moveSlides 				= $this->setting("moveSlides");
		$config_slideWidth 				= $this->setting("slideWidth");
		$config_slideHeight 			= $this->setting("slideHeight");

		$feed_url 		= "https://api.instagram.com/v1/users/self/media/recent/?access_token=" . $access_token;
		$profile_url 	= "https://api.instagram.com/v1/users/self/?access_token=" . $access_token;

		$ch = curl_init($feed_url);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
		$feed = json_decode(curl_exec($ch));
		curl_close($ch);

		$ch = curl_init($profile_url);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
		$profile = json_decode(curl_exec($ch));
		curl_close($ch);

		if(isset($feed->data) && is_array($feed->data))
		{
	        ?>
			<div id="module_<?php echo($this->module_instance_id); ?>" class="module instagram-slider-module <?php echo($module_class); ?>">
				<div class="pure-g instagram-slider-profile">
					<div class="pure-u-1 pure-u-md-1-6"><span class="instagram-slider-profile-picture"><img src="<?php echo($profile->data->profile_picture); ?>" /></span></div>
					<div class="pure-u-1 pure-u-md-5-6">
						<h3 class="instagram-slider-profile-name"><?php echo($profile->data->full_name); ?></h3>
						<p class="instagram-slider-follow"><a href="https://instagram.com/<?php echo($instagram_username); ?>" target="_blank" class="pure-button pure-button-primary"><em class="fab fa-instagram"></em> Follow on Instagram</a></p>

						<div class="pure-g">
							<div class="pure-u-1 pure-u-md-1-3"><span class="instagram-slider-profile-count"><b><?php echo($profile->data->counts->media); ?></b> posts</span></div>
							<div class="pure-u-1 pure-u-md-1-3"><span class="instagram-slider-profile-count"><b><?php echo($profile->data->counts->followed_by); ?></b> followers</span></div>
							<div class="pure-u-1 pure-u-md-1-3"><span class="instagram-slider-profile-count"><b><?php echo($profile->data->counts->follows); ?></b> following</span></div>
						</div>

						<p class="instagram-slider-bio"><?php echo($profile->data->bio); ?></p>
					</div>
				</div>

				<ul id="slider_<?php echo $this->module_instance_id?>" class="instgram-slider">
					<?php
					$count = 0;

					foreach($feed->data as $img)
					{
						// carousel_media holds an identical images array and is used when multiple photos are included in one post.
						if(isset($img->carousel_media))
						{
							foreach($img->carousel_media as $img2)
							{
								$count++;
								$a_name 	= "instagram-slider_" . $this->module_instance_id . "_image$count";
								$link 		= $img2->link;
								$target 	= "_blank";
								$class 		= "";
								$thumb 		= $img2->images->thumbnail->url;
								// carousel_media has no caption. We must use the main post's caption instead.
								$caption 	= (isset($img->caption->text) ? $img->caption->text : "");

								if($img2->type == "image")
								{
									if($lightbox)
									{
										$class 	= "lightbox";
										$link 	= $img2->images->standard_resolution->url;
										$target = "_self";
									}

									?><li><a href="<?php echo($link); ?>" id="<?php echo($a_name); ?>" rel="slider_<?php echo $this->module_instance_id?>" class="<?php echo($class); ?>" target="<?php echo($target); ?>"><div class="instagram-slider-overlay"><span class="instagram-slider-overlay-icon"><em class="fab fa-3x fa-instagram" aria-hidden="true"></em></span><span class="instagram-slider-overlay-counts"><em class="fas fa-fw fa-heart" aria-hidden="true"></em> <?php echo($img2->likes->count); ?> <em class="fas fa-fw fa-comment" aria-hidden="true"></em> <?php echo($img2->comments->count); ?></span><img src="<?php echo($thumb); ?>" data-thumb="<?php echo($thumb); ?>" width="<?php echo($img2->images->thumbnail->width); ?>" height="<?php echo($img2->images->thumbnail->height); ?>" alt="<?php echo(htmlspecialchars($caption)); ?>" title="<?php echo(htmlspecialchars($caption)); ?>" /></div></a></li><?php
								}
								else if($img2->type == "video")
								{
									?><li><a href="<?php echo($link); ?>" id="<?php echo($a_name); ?>" rel="slider_<?php echo $this->module_instance_id?>" class="<?php echo($class); ?>" target="<?php echo($target); ?>"><div class="instagram-slider-overlay"><span class="instagram-slider-overlay-icon"><em class="far fa-3x fa-play-circle" aria-hidden="true"></em></span><span class="instagram-slider-overlay-counts"><em class="fas fa-fw fa-heart" aria-hidden="true"></em> <?php echo($img2->likes->count); ?> <em class="fas fa-fw fa-comment" aria-hidden="true"></em> <?php echo($img2->comments->count); ?></span><img src="<?php echo($thumb); ?>" data-thumb="<?php echo($thumb); ?>" width="<?php echo($img2->images->thumbnail->width); ?>" height="<?php echo($img2->images->thumbnail->height); ?>" alt="<?php echo(htmlspecialchars($caption)); ?>" title="<?php echo(htmlspecialchars($caption)); ?>" /></div></a></li><?php
								}
							}
						}
						else
						{
							$count++;
							$a_name 	= "instagram-slider_" . $this->module_instance_id . "_image$count";
							$link 		= $img->link;
							$target 	= "_blank";
							$class 		= "";
							$thumb 		= $img->images->thumbnail->url;
							$caption 	= (isset($img->caption->text) ? $img->caption->text : "");

							if($img->type == "image")
							{
								if($lightbox)
								{
									$class 	= "lightbox";
									$link 	= $img->images->standard_resolution->url;
									$target = "_self";
								}

								?><li><a href="<?php echo($link); ?>" id="<?php echo($a_name); ?>" rel="slider_<?php echo $this->module_instance_id?>" class="<?php echo($class); ?>" target="<?php echo($target); ?>"><div class="instagram-slider-overlay"><span class="instagram-slider-overlay-icon"><em class="fab fa-3x fa-instagram" aria-hidden="true"></em></span><span class="instagram-slider-overlay-counts"><em class="fas fa-fw fa-heart" aria-hidden="true"></em> <?php echo($img->likes->count); ?> <em class="fas fa-fw fa-comment" aria-hidden="true"></em> <?php echo($img->comments->count); ?></span><img src="<?php echo($thumb); ?>" data-thumb="<?php echo($thumb); ?>" width="<?php echo($img->images->thumbnail->width); ?>" height="<?php echo($img->images->thumbnail->height); ?>" alt="<?php echo(htmlspecialchars($caption)); ?>" title="<?php echo(htmlspecialchars($caption)); ?>" /></div></a></li><?php
							}
							else if($img->type == "video")
							{
								?><li><a href="<?php echo($link); ?>" id="<?php echo($a_name); ?>" rel="slider_<?php echo $this->module_instance_id?>" class="<?php echo($class); ?>" target="<?php echo($target); ?>"><div class="instagram-slider-overlay"><span class="instagram-slider-overlay-icon"><em class="far fa-3x fa-play-circle" aria-hidden="true"></em></span><span class="instagram-slider-overlay-counts"><em class="fas fa-fw fa-heart" aria-hidden="true"></em> <?php echo($img->likes->count); ?> <em class="fas fa-fw fa-comment" aria-hidden="true"></em> <?php echo($img->comments->count); ?></span><img src="<?php echo($thumb); ?>" data-thumb="<?php echo($thumb); ?>" width="<?php echo($img->images->thumbnail->width); ?>" height="<?php echo($img->images->thumbnail->height); ?>" alt="<?php echo(htmlspecialchars($caption)); ?>" title="<?php echo(htmlspecialchars($caption)); ?>" /></div></a></li><?php
							}
						}
					}
					?>
				</ul>
			</div>

			<script>
				jQuery(window).on("load", function(){
			    	jQuery('#slider_<?php echo $this->module_instance_id?>').bxSlider({
						mode: "<?php echo($config_mode); ?>",
						speed: <?php echo($config_speed); ?>,
						slideMargin: <?php echo($config_slideMargin); ?>,
						startSlide: <?php echo($config_startSlide); ?>,
						randomStart: <?php echo(($config_randomStart == 1 ? "true" : "false")); ?>,
						slideSelector: "<?php echo($config_slideSelector); ?>",
						infiniteLoop: <?php echo(($config_infiniteLoop == 1 ? "true" : "false")); ?>,
						hideControlOnEnd: <?php echo(($config_hideControlOnEnd == 1 ? "true" : "false")); ?>,
						easing: "<?php echo($config_easing); ?>",
						captions: <?php echo(($config_captions == 1 ? "true" : "false")); ?>,
						ticker: <?php echo(($config_ticker == 1 ? "true" : "false")); ?>,
						tickerHover: <?php echo(($config_tickerHover == 1 ? "true" : "false")); ?>,
						adaptiveHeight: <?php echo(($config_adaptiveHeight == 1 ? "true" : "false")); ?>,
						adaptiveHeightSpeed: <?php echo($config_adaptiveHeightSpeed); ?>,
						video: <?php echo(($config_video == 1 ? "true" : "false")); ?>,
						responsive: <?php echo(($config_responsive == 1 ? "true" : "false")); ?>,
						useCSS: <?php echo(($config_useCSS == 1 ? "true" : "false")); ?>,
						preloadImages: "<?php echo($config_preloadImages); ?>",
						touchEnabled: <?php echo(($config_touchEnabled == 1 ? "true" : "false")); ?>,
						swipeThreshold: <?php echo($config_swipeThreshold); ?>,
						oneToOneTouch: <?php echo(($config_oneToOneTouch == 1 ? "true" : "false")); ?>,
						preventDefaultSwipeX: <?php echo(($config_preventDefaultSwipeX == 1 ? "true" : "false")); ?>,
						preventDefaultSwipeY: <?php echo(($config_preventDefaultSwipeY == 1 ? "true" : "false")); ?>,
						pager: <?php echo(($config_pager == 1 ? "true" : "false")); ?>,
						pagerType: "<?php echo($config_pagerType); ?>",
						pagerShortSeparator: "<?php echo($config_pagerShortSeparator); ?>",
						pagerSelector: "<?php echo($config_pagerSelector); ?>",
						pagerCustom: "<?php echo($config_pagerCustom); ?>",
						buildPager: "<?php echo($config_buildPager); ?>",
						controls: <?php echo(($config_controls == 1 ? "true" : "false")); ?>,
						nextText: "<?php echo($config_nextText); ?>",
						prevText: "<?php echo($config_prevText); ?>",
						nextSelector: "<?php echo($config_nextSelector); ?>",
						prevSelector: "<?php echo($config_prevSelector); ?>",
						autoControls: <?php echo(($config_autoControls == 1 ? "true" : "false")); ?>,
						startText: "<?php echo($config_startText); ?>",
						stopText: "<?php echo($config_stopText); ?>",
						autoControlsCombine: <?php echo(($config_autoControlsCombine == 1 ? "true" : "false")); ?>,
						autoControlsSelector: "<?php echo($config_autoControlsSelector); ?>",
						auto: <?php echo(($config_auto == 1 ? "true" : "false")); ?>,
						pause: <?php echo($config_pause); ?>,
						autoStart: <?php echo(($config_autoStart == 1 ? "true" : "false")); ?>,
						autoDirection: "<?php echo($config_autoDirection); ?>",
						autoHover: <?php echo(($config_autoHover == 1 ? "true" : "false")); ?>,
						autoDelay: <?php echo($config_autoDelay); ?>,
						minSlides: <?php echo($config_minSlides); ?>,
						maxSlides: <?php echo($config_maxSlides); ?>,
						moveSlides: <?php echo($config_moveSlides); ?>,
						slideWidth: <?php echo($config_slideWidth); ?>
					});

					<?php
					// Only include this JS if there's going to be a lightbox, otherwise it can conflict with the gallery.
					if($lightbox)
					{
						?>
						jQuery(".instagram-slider-module a.lightbox").colorbox({
							'rel'			: 'slider_<?php echo $this->module_instance_id?>',
							'transition'	: 'elastic',
							'current'		: '{current}/{total}',
							'scalePhotos' 	: true,
							'width'			: '<?php echo($lightbox_width); ?>',
							'height'		: '<?php echo($lightbox_height); ?>',
							'maxWidth' 		: '100%',
							'maxHeight'		: '100%'
						});
						<?php
					}
					?>
				});
		    </script>
			<?php
		}
	}
}
