<?php
defined('PRODUCT_NAME') or die;
class MenuModule extends ModuleInstance
{
	private $active_items = array();

	public function __construct()
	{
		parent::__construct();

		$this->scripts = array("<script src=\"/modules/menu/menu.js\"></script>",
		                       "<script src=\"/modules/menu/priority-navigation.js\"></script>");
		$this->enable_jquery 		= true;
		$this->cache_config->user   = true;
	}

	function render()
	{
		$title 					= $this->setting("title");
		$title_heading_level 	= $this->setting("title_heading_level");
		$module_class 			= $this->setting("module_class");
		$style 					= $this->setting("style");
		$responsive 			= $this->setting("responsive");
		$more_text 				= $this->setting("more_text");
		$less_text 				= $this->setting("less_text");
		$menu_text 				= $this->setting("menu_text");
		$menu_class 			= ($this->setting("raw") ? "ncms" : "pure");
		?>
		<div id="module_<?php echo($this->module_instance_id); ?>" class="module menu-module <?php echo($module_class); ?>">
			<?php
			if($title && $title_heading_level)
			{
				?><<?php echo($title_heading_level); ?> class="module-title"><?php echo($title); ?></<?php echo($title_heading_level); ?>><?php
			}
			?>
			<div class="<?php echo($menu_class); ?>-menu-container">
				<nav class="<?php echo($menu_class); ?>-menu <?php echo($menu_class); ?>-menu-<?php echo($style); ?> <?php echo($responsive ? $menu_class . "-menu-responsive" : ""); ?>" id="menu_<?php echo($this->module_instance_id); ?>">
					<?php $this->menu(); ?>
					<div class="clear"></div>
				</nav>
				<div class="clear"></div>
			</div>
		</div>

		<script>
		jQuery(document).ready(function()
		{
			<?php
			if($responsive)
			{
				?>
				jQuery("#module_<?php echo($this->module_instance_id); ?> > .<?php echo($menu_class); ?>-menu-container > .<?php echo($menu_class); ?>-menu-responsive > .<?php echo($menu_class); ?>-menu-items").prioritize_menu({
					more: '<?php echo(addslashes($more_text)); ?>',
					less: '<?php echo(addslashes($less_text)); ?>',
					menu: '<?php echo(addslashes($menu_text)); ?>'
				});
				<?php
			}
			?>
		});
		</script>
		<?php
	}

	function menu($parent_id=null, $items=null)
	{
		$this->load->model("menuitem");

		$page                   = Mainframe::page();
		$site                   = Mainframe::site();
		$menu_id                = $this->setting("menu_id");
		$hover                  = $this->setting("hover");
		$menu_class             = ($this->setting("raw") ? "ncms" : "pure");
		$style                  = $this->setting("style");
		$duplicate_parent_links = $this->setting("duplicate_parent_links");

		//We can save a double lookup by passing items from the $subitems check below into the recursive function.
		if($items == null)
		{
			$items = $this->menuitem->LoadByMenuID($menu_id, $parent_id, Mainframe::user());
		}

		if(count($items) == 0)
		{
			return;
		}
		?>
		<ul class="<?php echo($menu_class); ?>-menu-<?php echo($parent_id ? "children" : ($style == "vertical" ? "list" : "items")); ?>">
			<?php
			$total = count($items);
			$count = 0;

			foreach($items as $item)
			{
				if(!$item->published)
				{
					continue;
				}
				$active_parent = false;
				$count ++;

				//check if any children are active
				$subitems = $this->menuitem->LoadByMenuID($menu_id, $item->menu_item_id, Mainframe::user());

				foreach($subitems as $subitem)
				{
					if(!$subitem->published)
					{
						continue;
					}

					if($page->page_id == $subitem->page_id)
					{
						$active_parent = true;
						break;
					}
				}

				$url   = (preg_match('/^http/', strtolower($item->url)) ? '' : '/') . ($item->page_id == $site->default_page_id ? "" : $item->url);
				$class = $menu_class . "-menu-item";

				if($item->url == "index" || $url == "//")
				{
					$url = "/";
				}

				if(count($subitems) > 0 && $item->menu_item_id != $parent_id)
				{
					$class .= " " . $menu_class . "-menu-has-children";
				}

				if($hover)
				{
					$class .= " " . $menu_class . "-menu-allow-hover";
				}

				// The wonky PHP tags here help prevent spaces from being placed between menu items.
				?><li class="<?php echo($class); ?> <?php echo($count == 1 ? "first" : "")?> <?php echo($count == $total ? "last" : "")?> <?php echo($page->page_id == $item->page_id || $active_parent ? "active" : "")?>"><?php
					?><a href="<?php echo $url?>" <?php echo ($item->target ? "target=\"$item->target\"" : "")?> <?php echo ($item->title_tag ? "title=\"$item->title_tag\"" : "")?> class="<?php echo($menu_class); ?>-menu-link"><?php
					if($item->icon)
					{
						?><em class="fa-fw <?php echo($item->icon); ?>" aria-hidden="true"></em> <?php
					}
					echo($item->title);
					?></a><?php

					if($item->menu_item_id != $parent_id)
					{
						// Add the current menu item as the first child of the submenu for accessibility reasons.
						if($duplicate_parent_links && count($subitems))
						{
							$subitems = array_merge(array($item), $subitems);
						}

						$this->menu($item->menu_item_id, $subitems);
					}
				?></li><?php
			}
			?>
		</ul>
		<?php
	}
}
