(function ( $ )
{
	$.fn.prioritize_menu = function( options )
	{
		$.fn.prioritize_menu.defaults = {
				    more: "More&hellip;",
					less: "Less&hellip;",
					menu: "Menu"
		};

		// Extend our default options with those provided.
	    // Note that the first argument to extend is an empty
	    // object – this is to keep from overriding our "defaults" object.
	    var opts = $.extend( {}, $.fn.prioritize_menu.defaults, options );

		return this.each(function()
		{
			var element = this;

			buildMoreMenu(element);
			jQuery(element).addClass("prioritized").css({"overflow":"hidden"});
			showItems(element, howManyItems(element), howManyFit(element));
			jQuery(element).css({"overflow":"visible"});

			jQuery(window).resize(function()
			{
				// If the overlay is already open, bail out or it will end up closing.
				if(jQuery(element).hasClass("opened"))
				{
					return;
				}

				jQuery(element).css({"overflow":"hidden"}).removeClass("opened");
				showItems(element, howManyItems(element), howManyFit(element));
				jQuery(element).css({"overflow":"visible"});
			});

			// var element  = this;

			// jQuery(element).addClass("prioritized");
			// buildMoreMenu(element);
			// checkWidth(element);
			// jQuery(element).removeClass("invisible");

			// jQuery(window).resize(function()
			// {
			// 	// If the overlay is already open, bail out or it will end up closing.
			// 	if(jQuery("li[data-priority='less']:visible").size() > 0)
			// 	{
			// 		return;
			// 	}

			// 	jQuery(element).css({"overflow":"hidden"});
			// 	jQuery(element).removeClass("truncated opened");
			// 	jQuery('.demoted', element).removeClass("demoted");
			// 	checkWidth(element);
			// 	jQuery(element).css({"overflow":"visible"});
			// });
		});

		function howManyItems(element)
		{
			// Don't count "More" and "Less" as items.
			return Number(jQuery('> li', element).size() - 2);
		}

		function howManyFit(element)
		{
			var t        = 0;
			var wrapper  = jQuery(element).outerWidth(false);
			var more  	 = 0;
			var widths   = [];
			var w 		 = 0;
			var how_many = 0;

			jQuery('> li.demoted', element).removeClass("demoted");

			// Calculate the width of all <li>s except "more" and "less"
			jQuery('> li:not([data-priority="more"]), > li:not([data-priority="less"])', element).each(function()
			{
				w = jQuery(this).outerWidth(true);
				widths.push(w);
				t += w;
			});

			// We know that they won't all fit.
			if(t > wrapper)
			{
				more = widths[widths.length-1];
				t    = more;

				for(var i=0; i<widths.length-1; i++)
				{
					t += widths[i];

					if(t < wrapper)
					{
						how_many++;
					}
				}
			}
			else
			{
				how_many = widths.length;
			}

			return how_many;
		}

		function showItems(element, total, max)
		{
			var more = (total > max);

			// Show items.
			for(var i=0; i<max; i++)
			{
				jQuery('> li', element).eq(i).removeClass("demoted");
			}

			// Hide items that don't fit. The rest are already promoted.
			for(var i=max; i<total; i++)
			{
				jQuery('> li', element).eq(i).addClass("demoted");
			}

			// total did not include the more menu, so referencing it "without -1" will give us the correct index.
			if(total == 0)
			{
				jQuery('li[data-priority="more"] > a', element).html(opts.menu);
			}
			else
			{
				jQuery('li[data-priority="more"] > a', element).html(opts.more);
			}

			if(!more)
			{
				jQuery('> li', element).eq(total).addClass("demoted");
			}
		}

		function buildMoreMenu(element)
		{
			$('li[data-priority="more"], li[data-priority="less"]', element).remove();

			if($(element).hasClass("ncms-menu-items"))
			{
				menu_class = "ncms";
			}
			else
			{
				menu_class = "pure";
			}

			var more_menu = '<li data-priority="more" class="' + menu_class + '-menu-item ' + menu_class + '-menu-item-more ' + menu_class + '-menu-has-children"><a href="#" class="' + menu_class + '-menu-link">' + opts.more + '</a></li><li data-priority="less" class="' + menu_class + '-menu-item ' + menu_class + '-menu-item-less"><a href="#" class="' + menu_class + '-menu-link">' + opts.less + '</a></li>';

			jQuery(element).append(more_menu);

			$('li[data-priority="more"] a', element).on("click", function(event)
			{
				event.preventDefault();
				jQuery(this).parents("ul").addClass("opened");
			});

			$('li[data-priority="less"] a', element).on("click", function(event)
			{
				event.preventDefault();
			  	jQuery(this).parents("ul").removeClass("opened");
				jQuery(window).resize();
			});
		}
	}
}( jQuery ));
