<?php
defined('PRODUCT_NAME') or die;
class MonthlySpecials extends ModuleInstance
{
	function render()
	{
		$title 					= $this->setting("title");
		$title_heading_level 	= $this->setting("title_heading_level");
		$module_class 			= $this->setting("module_class");
		$display				= $this->setting("display");
		$link					= $this->setting("link");
		$sort					= $this->setting("sort");
		$view_all_link			= $this->setting("view_all_link");
		$specials 				= array();
		$specials[1]			= $this->setting("special01");
		$specials[2]			= $this->setting("special02");
		$specials[3]			= $this->setting("special03");
		$specials[4]			= $this->setting("special04");
		$specials[5]			= $this->setting("special05");
		$specials[6]			= $this->setting("special06");
		$specials[7]			= $this->setting("special07");
		$specials[8]			= $this->setting("special08");
		$specials[9]			= $this->setting("special09");
		$specials[10]			= $this->setting("special10");
		$specials[11]			= $this->setting("special11");
		$specials[12]			= $this->setting("special12");

		if($this->input->get_post("view") == "all")
		{
			$display = "all";
		}

		$months = array("January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December");

		$displayed_specials = array();

		if($display == "current")
		{
			$special = $specials[date("n")];	//month, no leading zero

			?>
			<div id="module_<?php echo($this->module_instance_id); ?>" class="module monthly-specials-module <?php echo($module_class); ?>">
				<?php
				if($title && $title_heading_level)
				{
					?><<?php echo($title_heading_level); ?> class="module-title"><?php echo($title); ?></<?php echo($title_heading_level); ?>><?php
				}
				?>
				<h2 class="monthly_special_month"><?php echo $months[date("n")-1]?> Special</h2>
				<div class="monthly_special_detail"><?php echo $special?></div>

				<?php
				if(trim($link) && $view_all_link)
				{
					?><div class="monthly_special_view_all"><a href="<?php echo $link?>">View All Specials</a></div><?php
				}
				?>
			</div>
			<?php
		}
		else
		{
			$count = 0;

			if($sort == "january")
			{
				$start = 1;
			}
			else
			{
				$start = date("n");
			}

			for($i = $start; $count < 12; $i++)
			{
				if($i > 12)
				{
					$i = 0;
				}

				$special = (isset($specials[$i]) ? $specials[$i] : "");

				if(trim($special) == "")
				{
					$count++;
					continue;
				}

				?>
				<div id="module_<?php echo($this->module_instance_id); ?>" class="module monthly-specials-module <?php echo($module_class); ?>">
					<?php
					if($title && $title_heading_level)
					{
						?><<?php echo($title_heading_level); ?> class="module-title"><?php echo($title); ?></<?php echo($title_heading_level); ?>><?php
					}
					?>
					<h2 class="monthly_special_month"><?php echo $months[$i-1]?> Special</h2>
					<div class="monthly_special_detail"><?php echo $special?></div>
				</div>
				<?php
				$count++;
			}
		}
	}
}
