(function ( $ )
{
	$.fn.prioritize_nvmenu = function( options )
	{
		$.fn.prioritize_nvmenu.defaults = {
				    more: "More&hellip;",
					menu: "Menu",
					module_instance_id: 0
		};

		// Extend our default options with those provided.
	    // Note that the first argument to extend is an empty
	    // object – this is to keep from overriding our "defaults" object.
	    var opts = $.extend( {}, $.fn.prioritize_nvmenu.defaults, options );

		return this.each(function()
		{
			var element = this;

			buildMoreMenu(element);
			jQuery(element).addClass("prioritized").css({"overflow":"hidden"});
			showItems(element, howManyItems(element), howManyFit(element));
			jQuery(element).css({"overflow":"visible"});

			jQuery(window).resize(function()
			{
				jQuery(element).css({"overflow":"hidden"});
				showItems(element, howManyItems(element), howManyFit(element));
				jQuery(element).css({"overflow":"visible"});
			});
		});

		function howManyItems(element)
		{
			// Don't count "More" as an item.
			return Number(jQuery('> li', element).size() - 1);
		}

		function howManyFit(element)
		{
			var t        = 0;
			var wrapper  = jQuery(element).outerWidth(false);
			var more  	 = 0;
			var widths   = [];
			var w 		 = 0;
			var how_many = 0;

			jQuery('> li.demoted', element).removeClass("demoted");

			// Calculate the width of all <li>s except "more"
			jQuery('> li:not([data-priority="more"])', element).each(function()
			{
				w = jQuery(this).outerWidth(true);
				widths.push(w);
				t += w;
			});

			// We know that they won't all fit.
			if(t > wrapper)
			{
				more = widths[widths.length-1];
				t    = more;

				for(var i=0; i<widths.length-1; i++)
				{
					t += widths[i];

					if(t < wrapper)
					{
						how_many++;
					}
				}
			}
			else
			{
				how_many = widths.length;
			}

			return how_many;
		}

		function showItems(element, total, max)
		{
			var more = (total > max);

			// Show items.
			for(var i=0; i<max; i++)
			{
				jQuery('> li', element).eq(i).removeClass("demoted");
			}

			// Hide items that don't fit. The rest are already promoted.
			for(var i=max; i<total; i++)
			{
				jQuery('> li', element).eq(i).addClass("demoted");
			}

			// total did not include the more menu, so referencing it "without -1" will give us the correct index.
			if(total == 0)
			{
				jQuery('li[data-priority="more"] > a', element).html(opts.menu);
			}
			else
			{
				jQuery('li[data-priority="more"] > a', element).html(opts.more);
			}

			if(!more)
			{
				jQuery('> li', element).eq(total).addClass("demoted");
			}
		}

		function buildMoreMenu(element)
		{
			jQuery('li[data-priority="more"]', element).remove();

			var items = jQuery("> li", element);
			var more_menu = '<li data-priority="more" class="nvmenu-item nvmenu-item-more nvmenu-has-children demoted"><a href="#" onclick="open_nvmenu' + opts.module_instance_id + '(event); return false;" class="nvmenu-link">' + opts.more + '</a></div><div class="nvmenu-overlay-data-items hidden"><ul class="pure-g">';

			for(var i=0; i<items.size(); i++)
			{
				items.eq(i).addClass("pure-u-1 pure-u-md-1-2 pure-u-lg-1-3 pure-u-xl-1-4");
				more_menu += items.eq(i)[0].outerHTML;
				items.eq(i).removeClass("pure-u-1 pure-u-md-1-2 pure-u-lg-1-3 pure-u-xl-1-4");
			}

			more_menu += '</ul></div></li>';
			jQuery(element).append(more_menu);
		}
	}
}( jQuery ));
