<?php
defined('PRODUCT_NAME') or die;
class ShopBreadcrumbModule extends ModuleInstance
{
	public function __construct()
	{
		parent::__construct();

		$this->cache_config->enabled = false;
	}

	function render()
	{
		$this->load->model(array("shop/shop_category", "shop/shop_product", "shop/shop_config"));

		$title 					= $this->setting("title");
		$title_heading_level 	= $this->setting("title_heading_level");
		$module_class 			= $this->setting("module_class");
		$shop_config 			= $this->shop_config->LoadAssocBySiteID(Mainframe::site()->site_id);

		if(!class_exists("shop"))
		{
			return;
		}

		if(!Shop::is_product() && !Shop::is_category())
		{
			return;
		}

		?>
		<div id="module_<?php echo($this->module_instance_id); ?>" class="module shop-breadcrumbs-module <?php echo($module_class); ?>">
			<?php
			if($title && $title_heading_level)
			{
				?><<?php echo($title_heading_level); ?> class="module-title"><?php echo($title); ?></<?php echo($title_heading_level); ?>><?php
			}

			if(Shop::is_product())
			{
				$product = Shop::get_product();
				echo($product->GetBreadcrumbs());
			}
			else if(Shop::is_category())
			{
				$category = Shop::get_category();
				echo($category->GetBreadcrumbs());
			}
			?>
		</div>
		<?php
	}
}
