<?php
defined('PRODUCT_NAME') or die;
class ShopCartModule extends ModuleInstance
{
	public function __construct()
	{
		parent::__construct();
		$this->enable_jquery         = true;
		$this->cache_config->enabled = false;
	}

	function render()
	{
		$this->load->model(array("shop/shop_cart", "shop/shop_product_option", "shop/shop_config"));

		$shop_config = $this->shop_config->LoadAssocBySiteID(Mainframe::site()->site_id);
		$shop_page = new Page();
		$shop_page->Load($shop_config["page_id"]);

		$cart_url 		= "/" . $shop_page->url . "/cart";
		$checkout_url 	= "/" . $shop_page->url . "/checkout";
		$cart 			= new Shop_cart();
		$items 			= $cart->GetItemsBySessionID(session_id());

		$this->load->view("modules/shop_cart/module",
		                  array("module_instance_id" 	=> $this->module_instance_id,
					  			"title" 				=> $this->setting("title"),
					  			"title_heading_level" 	=> $this->setting("title_heading_level"),
						  		"module_class" 			=> $this->setting("module_class"),
						  		"cart_url" 				=> $cart_url,
						  		"checkout_url" 			=> $checkout_url,
						  		"items"					=> $items
						  		));
	}
}
