<?php
defined('PRODUCT_NAME') or die;
class ShopCategoryModule extends ModuleInstance
{
	public function __construct()
	{
		parent::__construct();

		$this->cache_config->user = true;
	}

	function render()
	{
		$site     = Mainframe::site();
		$template = Mainframe::template();
		$page     = Mainframe::page();

		$this->load->model(array("shop/shop_category", "shop/shop_product_layout", "shop/shop_category_layout", "shop/shop_product_variant", "shop/shop_product", "shop/shop_config"));

		$title 					= $this->setting("title");
		$title_heading_level 	= $this->setting("title_heading_level");
		$module_class 			= $this->setting("module_class");
		$shop_config 			= $this->shop_config->LoadAssocBySiteID(Mainframe::site()->site_id);
		$category_id 			= $this->setting("category_id");
		$category 				= new Shop_Category();
		$category->LoadWithImages($category_id);

		$layout 	= new Shop_Category_Layout();
		$layout->Load($category->category_layout_id);

		$shop_page 	= new Page();
		$shop_page->Load($shop_config["page_id"]);
		$url_parts 	= "/" . $shop_page->url;
		$categories = $this->shop_category->LoadByParentID((isset($category->category_id) && $category->category_id > 0 ? $category->category_id : 0));
		$products 	= $this->shop_product->LoadByCategoryID((isset($category->category_id) && $category->category_id > 0 ? $category->category_id : 0));

		$shop_category_images 	= array();
		$shop_product_images 	= array();

		if(is_array($categories))
		{
			foreach($categories as $cat)
			{
				if(strlen($cat->image_filename) > 0)
				{
					$shop_category_images[] = $cat->image_filename;
				}
			}
		}

		if(is_array($products))
		{
			foreach($products as $p)
			{
				if(strlen($p->image_filename) > 0)
				{
					$shop_product_images[] = $p->image_filename;
				}
			}
		}

		process_thumbnails($shop_category_images, $layout->category_image_width, $layout->category_image_height);
		process_thumbnails($shop_product_images, $layout->product_image_width, $layout->product_image_height);

		$shop_data = array();
		$shop_data["module_instance_id"] 	= $this->module_instance_id;
		$shop_data["title"] 				= $this->setting("title");
		$shop_data["title_heading_level"] 	= $this->setting("title_heading_level");
		$shop_data["module_class"] 			= $this->setting("module_class");
		$shop_data["shop_config"]			= $shop_config;
		$shop_data["site"]					= $site;
		$shop_data["template"]				= $template;
		$shop_data["page"]					= $page;
		$shop_data["url_parts"]				= array($url_parts);
		$shop_data["category"]				= (isset($category) ? $category : null);
		$shop_data["categories"]			= (isset($categories) ? $categories : array());
		$shop_data["product"]				= (isset($product) ? $product : null);
		$shop_data["products"]				= (isset($products) ? $products : array());
		$shop_data["layout"]				= (isset($layout) ? $layout : null);
		$shop_data["show_categories"] 		= $this->setting("show_categories");
		$shop_data["show_products"] 		= $this->setting("show_products");

		$this->load->view("modules/shop_category/module", $shop_data);
	}
}
