<?php
defined('PRODUCT_NAME') or die;
class ShopCurrencyModule extends ModuleInstance
{
	function render()
	{
		$this->load->model(array("shop/shop_currency", "shop/shop_config"));

		$title 					= $this->setting("title");
		$title_heading_level 	= $this->setting("title_heading_level");
		$module_class 			= $this->setting("module_class");
		$shop_config 			= $this->shop_config->LoadAssocBySiteID(Mainframe::site()->site_id);
		$shop_page 				= new Page();
		$shop_page->Load($shop_config["page_id"]);

		?>
		<div id="module_<?php echo($this->module_instance_id); ?>" class="module shop-currency-module <?php echo($module_class); ?>">
			<?php
			if($title && $title_heading_level)
			{
				?><<?php echo($title_heading_level); ?> class="module-title"><?php echo($title); ?></<?php echo($title_heading_level); ?>><?php
			}
			$currencies = $this->shop_currency->get();

			?>
			<ul class="shop_currencies">
				<?php
				foreach($currencies as $currency)
				{
					$class = "shop_currency";

					if($currency->currency_code == (class_exists("Shop") ? Shop::currency() : "CAD"))
					{
						$class .= " shop_currency_active";
					}

					?>
					<li class="<?php echo($class); ?>"><a href="<?php echo("/" . Mainframe::page()->url . "?currency=" . $currency->currency_code); ?>"><span class="shop_currency_code"><?php echo($currency->currency_code); ?></span> <span class="shop_currency_name"><?php echo($currency->currency_name); ?></span></a></li>
					<?php
				}
				?>
			</ul>
		</div>
		<?php
	}
}
