<?php
defined('PRODUCT_NAME') or die;
class ShopFilterModule extends ModuleInstance
{
	private $categories;
	private $url_parts;
	private $active_category;

	public function __construct()
	{
		parent::__construct();
		$this->scripts = array("<script async src=\"/modules/shop_filter/jquery.mixitup.js\"></script>");

		$this->enable_jquery         = true;
		$this->cache_config->enabled = false;

		require_once(APPLICATION_PATH . "/controllers/Shop.php");
	}

	function render()
	{
		$title               = $this->setting("title");
		$title_heading_level = $this->setting("title_heading_level");
		$module_class        = $this->setting("module_class");
		$refine_title        = $this->setting("refine_title");
		$field_text          = $this->setting("field_text");
		$button_text         = $this->setting("button_text");
		$show_categories     = $this->setting("show_categories");

		$this->load->model(array("shop/shop_product", "shop/shop_category", "shop/shop_config"));

		$shop_config = $this->shop_config->LoadAssocBySiteID(Mainframe::site()->site_id);
		$shop_page = new Page();
		$shop_page->Load($shop_config["page_id"]);
		$url = "/" . $shop_page->url . "/search";

		$user = get_user();

		$category_id = false;
		if(isset(Shop::get_category()->category_id) && Shop::get_category()->category_id > 0)
		{
			$category_id = Shop::get_category()->category_id;
		}
		?>
		<div id="module_<?php echo($this->module_instance_id); ?>" class="module shop-filter-module <?php echo($module_class); ?>">
			<?php
			if($title && $title_heading_level)
			{
				?><<?php echo($title_heading_level); ?> class="module-title"><?php echo($title); ?></<?php echo($title_heading_level); ?>><?php
			}
			?>
			<form name="shop_search_form" id="shop_search_form" method="get" action="<?php echo($url); ?>" class="pure-form pure-form-aligned">
				<?php
				csrf();
				if(isset(Shop::get_category()->category_id) && Shop::get_category()->category_id > 0)
				{
					$_POST["shop_filter_category_id"] = Shop::get_category()->category_id;
				}

				$wgt = new FeralTextWidget("shop_q", urldecode($this->input->get_post("shop_q")));
				$wgt->SetAttribute("onchange", "reset_search_parameters(true, true, true);");
				$wgt->SetAttribute("title", $field_text);
				$wgt->SetAttribute("placeholder", $field_text);
				$wgt->Create();
				?><button type="submit" class="pure-button pure-button-success" title="Search"><?php echo($button_text); ?></button>
				<div class="clear"></div>
				<?php

				//if(Shop::is_search()) //$this->input->get_post("shop_q"))
				//{
					$all_products = Shop::get_unfiltered_products(); //$this->shop_product->LoadByQuery(false);
					$products = Shop::get_products(); //$this->shop_product->LoadByQuery(true);
					$categories = array();
					$product_ids = array();
					$product_options = array();
					$layout_specific_values = array();

					if(count($all_products) > 1)
					{
						$categories = array();
						$product_ids = array();

						foreach($all_products as $product)
						{
							$cats = $this->shop_category->GetCategoriesForProductID($product->product_id);

							foreach($cats as $cat)
							{
								$categories[$cat->category_id] = $cat->category_name;
							}
							$product_ids[] = $product->product_id;
						}
						asort($categories);

						Shop::get_price_range_index(0, $all_products, $min_price, $max_price, $min_ranges, $max_ranges);

						$price_groups = count($min_ranges);

						$layout_specific_values = $this->shop_product->LoadLayoutSpecificDataValues($product_ids, true);
					}

					//decide weather to show the "refine search" section
					if((count($all_products) > 1 && $price_groups > 1) ||
						count($categories) > 1 ||
						count($layout_specific_values) > 1
						)
					{
						?>
						<h3 class="module_title" id="refine-search"><?php echo($refine_title); ?> <em class="fas fa-arrow-down" aria-hidden="true"></em></h3>
						<div class="shop_search_refine">
							<?php
							if(count($all_products) > 2 && $price_groups > 1)
							{
								?><h4>By Price Range</h4><?php

								$wgt = new FeralRadioWidget("shop_filter_price", "0", ($this->input->get_post("shop_filter_price") ? $this->input->get_post("shop_filter_price") : "0"), "product-filter-other");
								$wgt->SetAttribute("id", "shop_filter_price_00");
								//$wgt->SetAttribute("onclick", "reset_search_parameters(false, false, true); document.getElementById('shop_search_form').submit();");
								$wgt->SetAttribute("onclick", "filter_products(false);");
								$wgt->SetAttribute("data-filter", "price_all");
								$wgt->Create();

								echo(" <label for='shop_filter_price_00'>Any Price (0)</label><br />");

								for($i=0; $i<$price_groups; $i++)
								{
									$wgt = new FeralRadioWidget("shop_filter_price", $min_ranges[$i] . "|" . $max_ranges[$i], $this->input->get_post("shop_filter_price"), "product-filter-other");
									$wgt->SetAttribute("id", "shop_filter_price_$i");
									//$wgt->SetAttribute("onclick", "reset_search_parameters(false, false, true); document.getElementById('shop_search_form').submit();");
									$wgt->SetAttribute("onclick", "filter_products(false);");
									$wgt->SetAttribute("data-filter", "price_$i");
									$wgt->Create();

									echo(" <label for='shop_filter_price_$i'>$" . number_format($min_ranges[$i]) . " to $" . number_format($max_ranges[$i]) . " (0)</label><br />");
								}
							}

							if(count($categories) > 1 && $show_categories)
							{
								?><h4>By Category</h4><?php

								//if(count($categories) > 1)
								//{
									$wgt = new FeralRadioWidget("shop_filter_category_id", "0", ($this->input->get_post("shop_filter_category_id") ? $this->input->get_post("shop_filter_category_id") : "0"), "product-filter-other");
									$wgt->SetAttribute("id", "shop_filter_category_id_0");
									//$wgt->SetAttribute("onclick", "reset_search_parameters(false, false, true); document.getElementById('shop_search_form').submit();");
									$wgt->SetAttribute("onclick", "filter_products(false);");
									$wgt->SetAttribute("data-filter", "category_all");
									$wgt->Create();

									echo(" <label for='shop_filter_category_id_0'>Any Category (0)</label><br />");
								//}

								foreach($categories as $category_id => $category_name)
								{
									$wgt = new FeralRadioWidget("shop_filter_category_id", $category_id, $this->input->get_post("shop_filter_category_id"), "product-filter-other");
									$wgt->SetAttribute("id", "shop_filter_category_id_" . $category_id);
									//$wgt->SetAttribute("onclick", "reset_search_parameters(false, false, true); document.getElementById('shop_search_form').submit();");
									$wgt->SetAttribute("onclick", "filter_products(false);");
									$wgt->SetAttribute("data-filter", "category_$category_id");
									$wgt->Create();

									echo(" <label for='shop_filter_category_id_$category_id'>$category_name (0)</label><br />");
								}
							}
							else if(count($categories) == 1)
							{
								// Removed because this causes and unwanted "category lock" when searching.
								//there will only be 1, but we don't know its index
								// foreach($categories as $category_id => $category_name)
								// {
								// 	FeralHidden("shop_filter_category_id", $category_id);
								// }
							}
							else
							{
								FeralHidden("shop_filter_category_id", ($this->input->get_post("shop_filter_category_id") ? $this->input->get_post("shop_filter_category_id") : "0"));
							}

							if(count($layout_specific_values) > 1)
							{
								$last_name = "";

								//product attributes
								foreach($layout_specific_values as $value)
								{
									if($value->datatype == "checkbox")
									{
										if($last_name != $value->data_group)
										{
											?><h4><?php echo($value->data_group); ?></h4><?php
										}

										?><input type="checkbox" class="product-filter-checkbox" data-filter="option_<?php echo($value->layout_specific_data_id); ?>" name="option_<?php echo($value->layout_specific_data_id); ?>" id="option_<?php echo($value->layout_specific_data_id); ?>" value="1" onclick="filter_products(true);" /><?php
										echo(" <label for='option_" . $value->layout_specific_data_id . "'>" . $value->data_name . " (0)</label><br />");

										$last_name = $value->data_group;
									}
									else
									{
										if($last_name != ($value->data_group ? $value->data_group : $value->data_name))
										{
											?><h4><?php echo(($value->data_group ? $value->data_group : $value->data_name)); ?></h4><?php

											$wgt = new FeralRadioWidget("shop_filter_value_" . $value->layout_specific_data_id, "0", ($this->input->get_post("shop_filter_value_" . $value->layout_specific_data_id) ? $this->input->get_post("shop_filter_value_" . $value->layout_specific_data_id) : "0"), "product-filter-other");
											$wgt->SetAttribute("id", "shop_filter_value_" . $value->layout_specific_data_id . "_0");
											//$wgt->SetAttribute("onclick", "document.getElementById('shop_search_form').submit();");
											$wgt->SetAttribute("onclick", "filter_products(false);");
											$wgt->SetAttribute("data-filter", "option_" . $value->layout_specific_data_id . "_all");
											$wgt->Create();

											echo(" <label for='shop_filter_value_" . $value->layout_specific_data_id . "_0'>Any (0)</label><br />");
											//echo(" Any " . $value->data_name . "<br />");
										}

										$wgt = new FeralRadioWidget("shop_filter_value_" . $value->layout_specific_data_id, md5($value->data_value), ($this->input->get_post("shop_filter_value_" . $value->layout_specific_data_id) ? $this->input->get_post("shop_filter_value_" . $value->layout_specific_data_id) : "0"), "product-filter-other");
										$wgt->SetAttribute("id", "shop_filter_value_" . $value->layout_specific_data_id . "_" . md5($value->data_value));
										//$wgt->SetAttribute("onclick", "document.getElementById('shop_search_form').submit();");
										$wgt->SetAttribute("onclick", "filter_products(false);");
										$wgt->SetAttribute("data-filter", "option_" . $value->layout_specific_data_id . "_" . md5($value->data_value));
										$wgt->Create();

										echo(" <label for='shop_filter_value_" . $value->layout_specific_data_id . "_" . md5($value->data_value) . "'>" . $value->data_value . " (0)</label><br />");

										$last_name = ($value->data_group ? $value->data_group : $value->data_name);
									}
								}
							}
							?>
						</div>
						<?php
					}
				//}
			?>
			</form>
		</div>

		<script>
			var shop_filter_<?php echo($this->module_instance_id) ?>_recount = true;

			jQuery(window).on("load", function()
			{
				jQuery("#refine-search").click(function()
				{
					var left = jQuery(".shop_search_refine").eq(0);
					var content = jQuery("#content").eq(0);
					var fa = jQuery("#refine-search .fa, #refine-search .fas, #refine-search .far, #refine-search .fal, #refine-search .fab").eq(0);

					//if the icon is not visible we're not on mobile and should ignore clicks
					if(!fa.is(':visible'))
					{
						return false;
					}

					if(left.is(':visible'))
					{
						left.slideUp(800, function()
						{
							fa.removeClass("fa-arrow-up");
							fa.addClass("fa-arrow-down");
							jQuery("#galleria").resize();
						});
					}
					else if(!left.is(':visible'))
					{
						left.slideDown(800, function()
						{
							fa.removeClass("fa-arrow-down");
							fa.addClass("fa-arrow-up");
							jQuery("#galleria").resize();
						});
					}
				});

				jQuery('.shop_products').mixItUp(
					{
						load:
						{
							filter: 'all',
							sort: 'default:asc'
						},
						callbacks: {
							onMixEnd: function(state)
							{
								var checked_classes = "";
								var unchecked_classes = "";
								var all_classes = "";
								var shown_classes = "";

								jQuery(".product-filter-checkbox, .product-filter-other").each(function()
								{
									all_classes += jQuery(this).data("filter") + ",";

									if(jQuery(this).prop("checked"))
									{
										checked_classes += jQuery(this).data("filter") + ",";
									}
									else
									{
										unchecked_classes += jQuery(this).data("filter") + ",";
									}
								});

								//remove trailing comma
								if(checked_classes.length > 0)
								{
									checked_classes = checked_classes.substr(0, checked_classes.length -1);
								}
								//remove trailing comma
								if(unchecked_classes.length > 0)
								{
									unchecked_classes = unchecked_classes.substr(0, unchecked_classes.length -1);
								}

								jQuery(".mix").each(function()
								{
									if(jQuery(this).is(':visible'))
									{
										shown_classes += jQuery(this).attr("class").replace(/\s/g, ",").replace(/(shop_product|mix),/g, "") + ",";
									}
								});

								//remove trailing comma/space
								if(shown_classes.length > 0)
								{
									shown_classes = shown_classes.substr(0, shown_classes.length -1);
								}

								//shown_classes will now become an array
								shown_classes = shown_classes.split(",");

								//Always recount checkboxes
								jQuery(".product-filter-checkbox").each(function()
								{
									var filter 		= jQuery(this).data("filter");
									var label_for 	= jQuery(this).attr("id");
									var count 		= 0;

									for(var i=0; i<shown_classes.length; i++)
									{
										//count how many times this filter appears in the array of shown filters
										if(shown_classes[i] == filter)
										{
											count++;
										}
									}

									var label = jQuery("label[for='" + label_for + "']").eq(0);

									label.text(label.text().replace(/ \(\d*\)/g, " (" + count + ")"));
								});

								//Only recount other options if we haven't counted yet, or a checkbox was clicked.
								if(shop_filter_<?php echo($this->module_instance_id) ?>_recount == true)
								{
									jQuery(".product-filter-other").each(function()
									{
										var filter 		= jQuery(this).data("filter");
										var label_for 	= jQuery(this).attr("id");
										var count 		= 0;

										for(var i=0; i<shown_classes.length; i++)
										{
											//count how many times this filter appears in the array of shown filters
											if(shown_classes[i] == filter)
											{
												count++;
											}
										}

										var label = jQuery("label[for='" + label_for + "']").eq(0);

										label.text(label.text().replace(/ \(\d*\)/g, " (" + count + ")"));
									});
								}
							}
						}
					}
				);
			});

			function filter_products(recount)
			{
				<?php
				// 	The comma separation was removed in order to create an "and" filter instead of an "or" filter
				// 	which flat out doesn't work well at all.
				?>
				var filter = "";

				jQuery(".product-filter-checkbox:checked, .product-filter-other:checked").each(function()
				{
					filter += "." + jQuery(this).data("filter");// + ", ";
				});

				if(filter == "")
				{
					filter = "all";
				}
				else
				{
					//filter = filter.substring(0, filter.length-2);
				}

				shop_filter_<?php echo($this->module_instance_id) ?>_recount = recount;		//Global variable.

				jQuery('.shop_products').mixItUp('filter', filter);
			}
		</script>
		<?php
	}
}
