<?php
defined('PRODUCT_NAME') or die;
class ShopCategoryMenu extends ModuleInstance
{
	private $categories;
	private $url_parts;
	private $active_category;

	public function __construct()
	{
		parent::__construct();
		$this->enable_jquery              = true;
		$this->cache_config->user         = true;
		$this->cache_config->url          = true;
		$this->cache_config->query_string = true;
	}

	function render()
	{
		$title               = $this->setting("title");
		$title_heading_level = $this->setting("title_heading_level");
		$module_class        = $this->setting("module_class");
		$category_id         = $this->setting("category_id");

		$this->load->model(array("shop/shop_category", "shop/shop_config", "shop/shop_route"));

		$shop_config = $this->shop_config->LoadAssocBySiteID(Mainframe::site()->site_id);
		$shop_page = new Page();
		$shop_page->Load($shop_config["page_id"]);

		$url_parts = uri_string();
		$url_parts = explode("/", $url_parts);

		//remove "shop" from the start, if its there
		if($url_parts[0] == $shop_page->url)
		{
			array_shift($url_parts);
		}

		$route = new Shop_Route();
		$route->LoadBySiteID(Mainframe::site()->site_id, uri_string());

		$category = new Shop_Category();
		$category->load($route->category_id);

		$this->categories = $this->shop_category->LoadBySiteID(Mainframe::site()->site_id);

		if(!isset($category->category_id) || $category->category_id <= 0)
		{
			//no category could be determined, use default specified in module settings
			$category->load($category_id);
		}

		// Check if there are any categories to show, if not, we'll load up the main category again.
		$has_categories = false;
		foreach($this->categories as $c)
		{
			if($c->parent_category_id == $category->category_id)
			{
				$has_categories = true;
			}
		}

		if(!$has_categories)
		{
			return;
		}

		$this->active_category 	= $category;
		$this->url_parts 		= "/" . $shop_page->url;
		?>
		<div id="module_<?php echo($this->module_instance_id); ?>" class="module shop-menu-module <?php echo($module_class); ?>">
			<?php
			if($title && $title_heading_level)
			{
				?><<?php echo($title_heading_level); ?> class="module-title"><?php echo($title); ?></<?php echo($title_heading_level); ?>><?php
			}
			?>
			<nav class="pure-menu pure-menu-vertical">
				<?php $this->build_menu($category, false, "pure-menu-items"); ?>
			</nav>
		</div>
		<?php
	}

	private function build_menu($parent, $all, $class)
	{
		?>
		<ul class="<?php echo($class); ?> shop_category_menu shop_category_menu_<?php echo($parent->category_id);?>">
		<?php
		if($all)
		{
			?><li class="pure-menu-item"><a href="/<?php echo($parent->url); ?>" class="pure-menu-link">All <?php echo($parent->category_name); ?></a></li><?php
		}

		foreach($this->categories as $category)
		{
			if($category->parent_category_id == $parent->category_id)
			{
				$has_children = false;

				foreach($this->categories as $category2)
				{
					if($category2->parent_category_id == $category->category_id)
					{
						$has_children = true;
						break;
					}
				}
				?>
				<li class="pure-menu-item <?php echo($has_children ? "pure-menu-has-children": ""); ?>">
					<a href="/<?php echo($category->url); ?>" class="pure-menu-link">
						<?php echo($category->category_name); ?>
					</a>

					<?php
					$this->build_menu($category, $has_children, ($has_children ? "pure-menu-children": "pure-menu-items"));
					?>
				</li>
				<?php
			}
		}

		?></ul><?php
	}
}
