<?php
defined('PRODUCT_NAME') or die;
class ShopSearchModule extends ModuleInstance
{
	private $categories;
	private $url_parts;
	private $active_category;
	private $shop_controller;

	public function __construct()
	{
		parent::__construct();
		$this->enable_jquery         = true;
		$this->cache_config->enabled = false;
		require_once(APPLICATION_PATH . "/controllers/Shop.php");
	}

	function render()
	{
		$title               = $this->setting("title");
		$title_heading_level = $this->setting("title_heading_level");
		$module_class        = $this->setting("module_class");
		$field_text          = $this->setting("field_text");
		$button_text         = $this->setting("button_text");

		$this->load->model(array("shop/shop_product", "shop/shop_category", "shop/shop_product_variant", "shop/shop_config"));

		$shop_config 	= $this->shop_config->LoadAssocBySiteID(Mainframe::site()->site_id);
		$shop_page 		= new Page();
		$shop_page->Load($shop_config["page_id"]);

		$getvars 		= $this->input->get(NULL, TRUE);
		$postvars 		= $this->input->post(NULL, TRUE);
		$postvars 		= array_merge(is_array($postvars) ? $postvars : array(), is_array($getvars) ? $getvars : array());
		$url_extras 	= array();

		if($this->input->get_post("shop_q") != "")
		{
			// $url_extras[] = array("key" => "shop_q", "value" => rawurlencode($this->input->get_post("shop_q")));
		}
		else if($this->input->get_post("shop_q_part_ids") != "")
		{
			// $url_extras[] = array("key" => "shop_q_part_ids", "value" => rawurlencode($this->input->get_post("shop_q_part_ids")));
		}

		//automatically add any values starting with shop_filter to our query to preserve our filters
		foreach($postvars as $key=>$value)
		{
			if(stripos($key, "shop_filter") !== false || stripos($key, "shop_part") !== false)
			{
				// $url_extras[] = array("key" => $key, "value" => $value);
			}
		}

		$url = "/" . $shop_page->url . "/search";
		?>
		<div id="module_<?php echo($this->module_instance_id); ?>" class="module shop-search-module <?php echo($module_class); ?>">
			<?php
			if($title && $title_heading_level)
			{
				?><<?php echo($title_heading_level); ?> class="module-title"><?php echo($title); ?></<?php echo($title_heading_level); ?>><?php
			}
			?>
			<form name="shop_search_form" id="shop_search_form" method="get" action="<?php echo($url); ?>" class="pure-form pure-form-aligned">
				<?php
				csrf();

				foreach($url_extras as $extra)
				{
					//DO NOT put an ID on these or they will conflict with the part finder
					?><input type="hidden" name="<?php echo($extra["key"]); ?>" value="<?php echo($extra["value"]); ?>" /><?php
				}

				$wgt = new FeralTextWidget("shop_q", urldecode($this->input->get_post("shop_q")));
				$wgt->SetAttribute("onchange", "reset_search_parameters(true, true, true);");
				$wgt->SetAttribute("title", $field_text);
				$wgt->SetAttribute("placeholder", $field_text);
				$wgt->Create();
				?><button type="submit" class="pure-button pure-button-success" title="Search"><?php echo($button_text); ?></button>
				<div class="clear"></div>

				<?php
				if(isset(Shop::get_category()->category_id) && Shop::get_category()->category_id > 0)
				{
					$_POST["shop_filter_category_id"] = Shop::get_category()->category_id;
				}

				if(Shop::is_search()) //$this->input->get_post("shop_q"))
				{
					$all_products = Shop::get_unfiltered_products(); //$this->shop_product->LoadByQuery(false);
					$products = Shop::get_products(); //$this->shop_product->LoadByQuery(true);
					$categories = array();
					$product_ids = array();
					$layout_specific_values = array();

					if(count($all_products) > 1)
					{
						$min_price = 100000000;
						$max_price = 0;
						$avg_price = 0;
						$price_total = 0;
						$categories = array();
						$product_ids = array();

						foreach($all_products as $product)
						{
							if($product->price < $min_price)
							{
								$min_price = floor($product->price);
							}
							if($product->price > $max_price)
							{
								$max_price = ceil($product->price);
							}
							$price_total += $product->price;

							$categories[$product->main_category_id] = $product->main_category_name;
							$product_ids[] = $product->product_id;
						}
						asort($categories);

						$avg_price = $price_total / count($all_products);

						$price_step = ceil(($max_price - $min_price) / 5);

						$min_ranges = array();
						$max_ranges = array();
						$min_ranges[0] = floor($min_price);
						$max_ranges[4] = ceil($max_price);

						for($i=2; $i<=5; $i++)
						{
							$min_ranges[$i-1] = $min_ranges[$i-2] + $price_step + 1;
						}
						for($i=0; $i<4; $i++)
						{
							$max_ranges[$i] = $min_ranges[$i] + $price_step;
						}

						$layout_specific_values = $this->shop_product->LoadLayoutSpecificDataValues($product_ids, true);
					}

					//decide weather to show the "refine search" section
					if((count($all_products) > 1 && $price_total > 0) ||
						count($categories) > 1 ||
						count($layout_specific_values) > 1
						)
					{
						?>
						<div class="shop_search_refine pure-hidden-phone">
						<h4 class="module_title">Refine Search</h4><?php

						if(count($all_products) > 2 && $price_total > 0)
						{
							?><h5>By Price Range</h5><?php

							$wgt = new FeralRadioWidget("shop_filter_price", "0", ($this->input->get_post("shop_filter_price") ? $this->input->get_post("shop_filter_price") : "0"));
							$wgt->SetAttribute("id", "shop_filter_price_0");
							$wgt->SetAttribute("onclick", "reset_search_parameters(false, false, true); document.getElementById('shop_search_form').submit();");
							$wgt->Create();

							echo(" <label for='shop_filter_price_0'>Any Price</label><br />");

							for($i=0; $i<5; $i++)
							{
								$wgt = new FeralRadioWidget("shop_filter_price", $min_ranges[$i] . "|" . $max_ranges[$i], $this->input->get_post("shop_filter_price"));
								$wgt->SetAttribute("id", "shop_filter_price_$i");
								$wgt->SetAttribute("onclick", "reset_search_parameters(false, false, true); document.getElementById('shop_search_form').submit();");
								$wgt->Create();

								echo(" <label for='shop_filter_price_$i'>$" . number_format($min_ranges[$i]) . " to $" . number_format($max_ranges[$i]) . "</label><br />");
							}
						}

						if(count($categories) > 1)
						{
							?><h5>By Category</h5><?php

							//if(count($categories) > 1)
							//{
								$wgt = new FeralRadioWidget("shop_filter_category_id", "0", ($this->input->get_post("shop_filter_category_id") ? $this->input->get_post("shop_filter_category_id") : "0"));
								$wgt->SetAttribute("id", "shop_filter_category_id_0");
								$wgt->SetAttribute("onclick", "reset_search_parameters(false, false, true); document.getElementById('shop_search_form').submit();");
								$wgt->Create();

								echo(" <label for='shop_filter_category_id_0'>Any Category</label><br />");
							//}

							foreach($categories as $category_id => $category_name)
							{
								$wgt = new FeralRadioWidget("shop_filter_category_id", $category_id, $this->input->get_post("shop_filter_category_id"));
								$wgt->SetAttribute("id", "shop_filter_category_id_" . $category_id);
								$wgt->SetAttribute("onclick", "reset_search_parameters(false, false, true); document.getElementById('shop_search_form').submit();");
								$wgt->Create();

								echo(" <label for='shop_filter_category_id_$category_id'>" . $category_name . "</label><br />");
							}
						}
						else if(count($categories) == 1)
						{
							//there will only be 1, but we don't know its index
							foreach($categories as $category_id => $category_name)
							{
								FeralHidden("shop_filter_category_id", $category_id);
							}
						}
						else
						{
							FeralHidden("shop_filter_category_id", ($this->input->get_post("shop_filter_category_id") ? $this->input->get_post("shop_filter_category_id") : "0"));
						}

						$last_name = "";

						//product attributes
						foreach($layout_specific_values as $value)
						{
							if($last_name != $value->data_name)
							{
								?><h5><?php echo($value->data_name); ?></h5><?php

								$wgt = new FeralRadioWidget("shop_filter_value_" . $value->layout_specific_data_id, "0", ($this->input->get_post("shop_filter_value_" . $value->layout_specific_data_id) ? $this->input->get_post("shop_filter_value_" . $value->layout_specific_data_id) : "0"));
								$wgt->SetAttribute("id", "shop_filter_value_" . $value->layout_specific_data_id . "0");
								$wgt->SetAttribute("onclick", "document.getElementById('shop_search_form').submit();");
								$wgt->Create();

								echo(" <label for='shop_filter_value_" . $value->layout_specific_data_id . "0'>Any " . $value->data_name . "</label><br />");
							}

							$wgt = new FeralRadioWidget("shop_filter_value_" . $value->layout_specific_data_id, md5($value->data_value), ($this->input->get_post("shop_filter_value_" . $value->layout_specific_data_id) ? $this->input->get_post("shop_filter_value_" . $value->layout_specific_data_id) : "0"));
							$wgt->SetAttribute("id", "shop_filter_value_" . $value->layout_specific_data_id . $value->layout_specific_data_value_id);
							$wgt->SetAttribute("onclick", "document.getElementById('shop_search_form').submit();");
							$wgt->Create();

							echo(" <label for='shop_filter_value_" . $value->layout_specific_data_id . $value->layout_specific_data_value_id . "'>" . $value->data_value . "</label><br />");

							$last_name = $value->data_name;
						}
						?>
						</div>
						<?php
					}
				}
			?>
			</form>
		</div>

		<script>
			function reset_search_parameters(reset_price, reset_category, reset_other)
			{
				if(reset_price)
				{
					jQuery('#shop_filter_price_0').prop("checked", true);
				}
				if(reset_category)
				{
					jQuery('#shop_filter_category_id_0').prop("checked", true);
					jQuery("#shop_filter_category_id").val(0);
				}

				if(reset_other)
				{
					<?php
					if(isset($layout_specific_values) && is_array($layout_specific_values))
					{
						foreach($layout_specific_values as $value)
						{
							if($last_name != $value->data_name)
							{
								?>jQuery('#shop_filter_value_<?php echo($value->layout_specific_data_id . "0"); ?>').prop("checked", true);<?php
							}
						}
					}
					?>
				}
			}
		</script>
		<?php
	}
}
