<?php
defined('PRODUCT_NAME') or die;
class ShopShippingModule extends ModuleInstance
{
	public function __construct()
	{
		parent::__construct();
		$this->enable_jquery         = true;
		$this->enable_jquery_ui      = true;
		$this->cache_config->enabled = false;
		require_once(APPLICATION_PATH . "/controllers/Shop.php");
	}

	function render()
	{
		$title 					= $this->setting("title");
		$title_heading_level 	= $this->setting("title_heading_level");
		$module_class 			= $this->setting("module_class");
		$field_text 			= $this->setting("field_text");
		$button_text 			= $this->setting("button_text");
		?>
		<div id="module_<?php echo($this->module_instance_id); ?>" class="module shop-shipping-module <?php echo($module_class); ?>">
			<?php
			if($title && $title_heading_level)
			{
				?><<?php echo($title_heading_level); ?> class="module-title"><?php echo($title); ?></<?php echo($title_heading_level); ?>><?php
			}
			?>
			<form name="shop_shipping_estimator_form" id="shop_shipping_estimator_form" method="post" action="" onsubmit="return false;" class="pure-form pure-form-stacked">
				<?php
				csrf();

				$wgt = new FeralTextWidget("shop_postalcode", urldecode($this->input->get_post("shop_postalcode")));
				$wgt->SetAttribute("title", $field_text);
				$wgt->SetAttribute("placeholder", $field_text);
				$wgt->Create();
				?><button type="submit" class="pure-button pure-button-success" title="Get Shipping Rates" onclick="shop_shipping_estimate_dialog(); return false;"><?php echo($button_text); ?></button>
				<div class="clear"></div>
			</form>

			<div id='shop-shipping-dialog'></div>
		</div>

		<script>
		function shop_shipping_estimate_dialog()
		{
			var postalcode = jQuery("#shop_postalcode").val();

			if(postalcode == '')
			{
				alert("Enter your postal code to receive a shipping estimate.");
				jQuery("#shop_postalcode").focus()
				return false;
			}

			postalcode = postalcode.replace("-", "").replace(" ", "").toUpperCase();

			jQuery("#shop-shipping-dialog").html("<em class=\"fas fa-spin fa-spinner\" aria-hidden=\"true\"></em> Loading Shipping Options...");

			jQuery( "#shop-shipping-dialog" ).dialog(
			{
				title: "Shipping Estimate To " + postalcode,
				width: jQuery(window).width() * 0.9,
				height: jQuery(window).height() * 0.9,
				modal: true,
				show: { effect: "blind", duration: 800 },
				hide: { effect: "blind", duration: 800 },
				buttons: {
					"Continue Shopping": function()
				    {
				    	jQuery(this).dialog( "close" );
				    }
				}
			});

			try
			{
				jQuery.post(
					"/shop/shipping_estimate",
					{
						postalcode: postalcode
					},
					function(data)
					{
						jQuery("#shop-shipping-dialog").html(data);
					}
				);
			}
			catch(e)
			{
				alert("Error getting a shipping estimate: " + e);
			}
		}
		</script>
		<?php
	}
}
