<?php
defined('PRODUCT_NAME') or die;
class NivoSlider extends ModuleInstance
{
	private $files = array();

	// Using load() instead of __construct() allows us to access module settings.
	// Potential reproducssions of this are still unknown.
	function load($id)
	{
		parent::load($id);

		$theme 			= $this->setting("lightbox_theme");
		$nivo_theme		= $this->setting("nivo_theme");
		$lightbox		= $this->setting("lightbox");
		$default_link 	= $this->setting("link");
		$this->scripts 	= array("<link rel=\"stylesheet\" href=\"/modules/slideshow_nivoslider/themes/" . $nivo_theme . "/" . $nivo_theme . ".css\" />");

		// Only include this CSS file if there's going to be a lightbox, otherwise it can conflict with the gallery.
		if($lightbox && $theme)
		{
			$this->scripts = array_merge($this->scripts, array("<link rel=\"stylesheet\" href=\"/modules/slideshow_nivoslider/" . $theme . "/colorbox.css\" />"));
		}
		$this->scripts = array_merge($this->scripts,
                         array("<script async src=\"/modules/slideshow_nivoslider/jquery.nivo.slider.pack.js\"></script>",
								"<script async src=\"/modules/slideshow_nivoslider/jquery.colorbox-min.js\"></script>"));

		$this->enable_jquery = true;
	}

	function render($files = null)
	{
		$data = array("module_instance_id" 		=> $this->module_instance_id,
					  "title" 					=> $this->setting("title"),
					  "title_heading_level" 	=> $this->setting("title_heading_level"),
		              "module_class" 			=> $this->setting("module_class"),
					  "files" 					=> $this->setting("files"),
					  "base"					=> $this->setting("directory"),
					  "delay"					=> $this->setting("delay"),
					  "max_width"				=> $this->setting("max_width"),
					  "max_height"				=> $this->setting("max_height"),
					  "lightbox"				=> $this->setting("lightbox"),
					  "lightbox_width"			=> $this->setting("lightbox_width"),
					  "lightbox_height"			=> $this->setting("lightbox_height"),
					  "random"					=> $this->setting("random"),
					  "effect"					=> $this->setting("effect"),
					  "directionNav"			=> $this->setting("directionNav"),
					  "controlNav"				=> $this->setting("controlNav"),
					  "controlNavThumbs" 		=> $this->setting("controlNavThumbs"),
					  "default_link" 			=> $this->setting("link"),
					  "theme"					=> $this->setting("lightbox_theme"),
					  "nivo_theme"				=> $this->setting("nivo_theme"),
					  "captions"				=> $this->setting("captions"));

		for($j=0; $j<20; $j++)
		{
			$data["image$j"] = $this->setting("image$j");
			$data["link$j"]  = $this->setting("link$j");
		}

		$this->load->view("modules/slideshow_nivoslider/module", $data);
	}
}
