<?php
defined('PRODUCT_NAME') or die;
class Slippry extends ModuleInstance
{
	// Using load() instead of __construct() allows us to access module settings.
	// Potential reproducssions of this are still unknown.
	function load($id)
	{
		parent::load($id);

		$theme 			= $this->setting("lightbox_theme");
		$lightbox		= $this->setting("lightbox");
		$default_link 	= $this->setting("link");
		$this->scripts 	= array();

		// Only include this CSS file if there's going to be a lightbox, otherwise it can conflict with the gallery.
		if($lightbox && $theme)
		{
			$this->scripts = array_merge($this->scripts, array("<link rel=\"stylesheet\" href=\"/modules/slideshow_slippry/" . $theme . "/colorbox.css\" />"));
		}
		$this->scripts =  array_merge($this->scripts,
                          array("<script async src=\"/modules/slideshow_slippry/slippry.min.js\"></script>",
								"<script async src=\"/modules/slideshow_slippry/jquery.colorbox-min.js\"></script>"
								));

		$this->enable_jquery = true;
	}

	function render($files = null)
	{
		$module_class = $this->setting("module_class");
		$base         = $this->setting("directory");
		$directory    = ABSOLUTE_PATH . "/" . $base;

		if($files == null)
		{
			$files = scandir($directory);
		}
		if(count($files) <= 2)
		{
			return;
		}

		$full_files  = array();
		$image_files = array();

		foreach($files as $file)
		{
			$full_file = $file;

			if(is_file("$directory/$file") && preg_match('/\.(jpe?g|png|gif|webp)$/i', "$directory/$file"))
			{
				$full_files[] = "/" . $base . "/" . $full_file;
			}
		}

		$this->load->view("modules/slideshow_slippry/module",
								array("module" => $this,
								      "module_instance_id"	  => $this->module_instance_id,
									  "module_class"		  => $this->setting("module_class"),
									  "full_files"			  => $full_files,
									  "default_link"		  => $this->setting("default_link", "/"),
									  "lightbox"			  => $this->setting("lightbox", 0),
									  "lightbox_width"		  => $this->setting("lightbox_width", "90%"),
									  "lightbox_height"		  => $this->setting("lightbox_height", "90%"),
									  "config_slippryWrapper" => $this->setting("slippryWrapper", '<div class="sy-box"></div>'),
									  "config_slideWrapper"   => $this->setting("slideWrapper", '<div class="sy-slides-wrap"></div>'),
									  "config_slideCrop"      => $this->setting("slideCrop", '<div class="sy-slides-crop"></div>'),
									  "config_boxClass"       => $this->setting("boxClass", 'sy-list'),
									  "config_elements"       => $this->setting("elements", 'li'),
									  "config_activeClass"    => $this->setting("activeClass", 'sy-active'),
									  "config_fillerClass"    => $this->setting("fillerClass", 'sy-filler'),
									  "config_loadingClass"   => $this->setting("loadingClass", 'sy-loading'),
									  "config_adaptiveHeight" => $this->setting("adaptiveHeight", true),
									  "config_start"          => $this->setting("start", true),
									  "config_random"         => $this->setting("random", false),
									  "config_loop"           => $this->setting("loop", true),
									  "config_captionsSrc"    => $this->setting("captionsSrc", 'img'),
									  "config_captions"       => $this->setting("captions", 'overlay'),
									  "config_captionsEl"     => $this->setting("captionsEl", '.sy-caption'),
									  "config_initSingle"     => $this->setting("initSingle", true),
									  "config_responsive"     => $this->setting("responsive", true),
									  "config_preload"        => $this->setting("preload", 'visible'),
									  "config_pager"          => $this->setting("pager", true),
									  "config_pagerClass"     => $this->setting("pagerClass", 'sy-pager'),
									  "config_controls"       => $this->setting("controls", true),
									  "config_controlClass"   => $this->setting("controlClass", 'sy-controls'),
									  "config_prevClass"      => $this->setting("prevClass", 'sy-prev'),
									  "config_prevText"       => $this->setting("prevText", 'Previous'),
									  "config_nextClass"      => $this->setting("nextClass", 'sy-next'),
									  "config_nextText"       => $this->setting("nextText", 'Next'),
									  "config_hideOnEnd"      => $this->setting("hideOnEnd", true),
									  "config_transition"     => $this->setting("transition", 'fade'),
									  "config_kenZoom"        => $this->setting("kenZoom", 120),
									  "config_slideMargin"    => $this->setting("slideMargin", 0),
									  "config_transClass"     => $this->setting("transClass", 'transition'),
									  "config_speed"          => $this->setting("speed", 800),
									  "config_easing"         => $this->setting("easing", 'swing'),
									  "config_continuous"     => $this->setting("continuous", true),
									  "config_useCSS"         => $this->setting("useCSS", true),
									  "config_auto"           => $this->setting("auto", true),
									  "config_autoDirection"  => $this->setting("autoDirection", 'next'),
									  "config_autoHover"      => $this->setting("autoHover", true),
									  "config_autoHoverDelay" => $this->setting("autoHoverDelay", 100),
									  "config_autoDelay"      => $this->setting("autoDelay", 500),
									  "config_pause"          => $this->setting("pause", 3000),
		                  		));
	}
}
