<?php
defined('PRODUCT_NAME') or die;
class HTML5Video extends ModuleInstance
{
	public function __construct()
	{
		parent::__construct();
		$this->scripts = array("<script async src=\"/modules/video/flowplayer-3.2.6.min.js\"></script>");
	}

	function render()
	{
		$title 					= $this->setting("title");
		$title_heading_level 	= $this->setting("title_heading_level");
		$module_class 			= $this->setting("module_class");
		$video					= $this->setting("video");
		$max_width				= $this->setting("max_width");
		$max_height				= $this->setting("max_height");
		$autoplay				= $this->setting("autoplay");
		$volume					= $this->setting("volume");
		$poster					= "";
		$dir 					= ABSOLUTE_PATH . "/videos";

		if(file_exists("$dir/$video.jpg"))
		{
			$poster = "/videos/" . $video . ".jpg";
		}
		else if(file_exists("$dir/$video.png"))
		{
			$poster = "/videos/" . $video . ".png";
		}

		$this->load->view("modules/video/module", array(
		                  "module_instance_id" 	=> $this->module_instance_id,
					  	  "title" 				=> $title,
					  	  "title_heading_level" => $title_heading_level,
		              	  "module_class" 		=> $module_class,
		                  "video" 				=> $video,
		                  "max_height" 			=> $max_height,
		                  "max_width" 			=> $max_width,
		                  "autoplay" 			=> $autoplay,
		                  "volume" 				=> $volume,
		                  "poster" 				=> $poster,
		                  "dir" 				=> $dir));
	}
}
