<?php
/**
 * Using mod_rewrite to pass the image URL to the Img controller
 * seems next to impossible because the internal environment variables
 * don't get updated in the process. This file serves as an entry point
 * for the Img controller. All it does is modify the URL as follows:
 *
 * Old URL: /images/myimage.jpg
 * New URL: /img/images/myimage.jpg
 */

if(isset($_GET['devicePixelRatio']))
{
	session_start([
	    "cookie_secure" 	=> (isset($_SERVER["HTTPS"]) && $_SERVER["HTTPS"]),
		"cookie_httponly" 	=> true
	]);

    $dpr = $_GET['devicePixelRatio'];

    // Validate value before setting cookie
    if(''.intval($dpr) !== $dpr)
    {
        $dpr = '1';
    }

    $_SERVER['REQUEST_URI'] = "/img/setDPR/" . $dpr;
	require_once("index.php");

    exit();
}

$_SERVER['REQUEST_URI'] = "/img" . $_SERVER['REQUEST_URI'];
require_once("index.php");
