# Create basic roles.
INSERT INTO `acl_role` (`acl_role_id`, `role`, `description`) VALUES
	(1, 'Public', "Automatically used for visitors who are not logged in."),
	(2, 'Registered Users', "Intended for registered users who need access to front-end features."),
	(3, 'Administrators', "Full access to everything."),
	(4, 'Editors', "Manage general content (pages, modules, etc)."),
	(5, 'SEO Specialists', "Access search engine optimization tools."),
	(6, 'Business Directory Managers', "Manage the business directory."),
	(7, 'Event Coordinators', "Manage events and event forms."),
	(8, 'Shop Managers', "Manage shop products, categories, and orders"),
	(9, 'Shop Administrators', "Manage shop products, categories, orders, and configuration."),
	(10, 'Appointment Schedulers', "Manage appointments from the online booking module.");

# Create actions.
INSERT INTO `acl_action` SET `acl_action_id`=1, `action`="Public Login", `constant`="LOGIN";
INSERT INTO `acl_action` SET `acl_action_id`=2, `action`="Admin: Login", `constant`="ADMIN_LOGIN";
INSERT INTO `acl_action` SET `acl_action_id`=3, `action`="Admin: Access website configuration", `constant`="CONFIG";
INSERT INTO `acl_action` SET `acl_action_id`=4, `action`="Admin: Access users", `constant`="USERS";
INSERT INTO `acl_action` SET `acl_action_id`=5, `action`="Admin: Install updates", `constant`="UPDATES";
INSERT INTO `acl_action` SET `acl_action_id`=6, `action`="Admin: Access pages", `constant`="PAGES";
INSERT INTO `acl_action` SET `acl_action_id`=7, `action`="Admin: Access categories", `constant`="CATEGORIES";
INSERT INTO `acl_action` SET `acl_action_id`=8, `action`="Admin: Access menus", `constant`="MENUS";
INSERT INTO `acl_action` SET `acl_action_id`=9, `action`="Admin: Access modules", `constant`="MODULES";
INSERT INTO `acl_action` SET `acl_action_id`=10, `action`="Admin: Access media manager", `constant`="MEDIA";
INSERT INTO `acl_action` SET `acl_action_id`=11, `action`="Admin: Access documents", `constant`="DOCUMENTS";
INSERT INTO `acl_action` SET `acl_action_id`=12, `action`="Admin: Access portfolio", `constant`="PORTFOLIO";
INSERT INTO `acl_action` SET `acl_action_id`=13, `action`="Admin: Access SEO tools", `constant`="SEO";
INSERT INTO `acl_action` SET `acl_action_id`=14, `action`="Admin: Access user roles", `constant`="ROLES";
INSERT INTO `acl_action` SET `acl_action_id`=15, `action`="Admin: Access directory companies", `constant`="DIRECTORY_COMPANIES";
INSERT INTO `acl_action` SET `acl_action_id`=16, `action`="Admin: Access directory categories", `constant`="DIRECTORY_CATEGORIES";
INSERT INTO `acl_action` SET `acl_action_id`=17, `action`="Admin: Access directory export", `constant`="DIRECTORY_EXPORT";
INSERT INTO `acl_action` SET `acl_action_id`=18, `action`="Admin: Access events", `constant`="EVENTS";
INSERT INTO `acl_action` SET `acl_action_id`=19, `action`="Admin: Access event forms", `constant`="EVENT_FORMS";
INSERT INTO `acl_action` SET `acl_action_id`=20, `action`="Admin: Access appointments", `constant`="APPOINTMENTS";
INSERT INTO `acl_action` SET `acl_action_id`=21, `action`="Admin: Access shop products", `constant`="SHOP_PRODUCTS";
INSERT INTO `acl_action` SET `acl_action_id`=22, `action`="Admin: Access shop categories", `constant`="SHOP_CATEGORIES";
INSERT INTO `acl_action` SET `acl_action_id`=23, `action`="Admin: Access shop orders", `constant`="SHOP_ORDERS";
INSERT INTO `acl_action` SET `acl_action_id`=24, `action`="Admin: Access shop data fields", `constant`="SHOP_DATA";
INSERT INTO `acl_action` SET `acl_action_id`=25, `action`="Admin: Access shop shopper groups", `constant`="SHOP_SHOPPER_GROUPS";
INSERT INTO `acl_action` SET `acl_action_id`=26, `action`="Admin: Access shop configuration", `constant`="SHOP_CONFIG";

# Configure role actions.
INSERT INTO `acl_role_action` (`acl_role_id`, `acl_action_id`) VALUES
	(2, 1),
	(3, 1),
	(3, 2),
	(3, 3),
	(3, 4),
	(3, 5),
	(3, 6),
	(3, 7),
	(3, 8),
	(3, 9),
	(3, 10),
	(3, 11),
	(3, 12),
	(3, 13),
	(3, 14),
	(4, 1),
	(4, 2),
	(4, 6),
	(4, 7),
	(4, 8),
	(4, 9),
	(4, 10),
	(4, 11),
	(4, 12),
	(5, 1),
	(5, 2),
	(5, 13),
	(6, 1),
	(6, 2),
	(6, 15),
	(6, 16),
	(6, 17),
	(7, 1),
	(7, 2),
	(7, 18),
	(7, 19),
	(8, 1),
	(8, 2),
	(8, 21),
	(8, 22),
	(8, 23),
	(9, 1),
	(9, 2),
	(9, 21),
	(9, 22),
	(9, 23),
	(9, 24),
	(9, 25),
	(9, 26),
	(10, 1),
	(10, 2),
	(10, 20);
