# ACL for admin user
INSERT INTO `acl_user_role` SET `user_id`=1, `acl_role_id`=3;
INSERT INTO `acl_user_role` SET `user_id`=1, `acl_role_id`=4;
INSERT INTO `acl_user_role` SET `user_id`=1, `acl_role_id`=5;
INSERT INTO `acl_user_role` SET `user_id`=1, `acl_role_id`=6;
INSERT INTO `acl_user_role` SET `user_id`=1, `acl_role_id`=7;
INSERT INTO `acl_user_role` SET `user_id`=1, `acl_role_id`=9;
INSERT INTO `acl_user_role` SET `user_id`=1, `acl_role_id`=10;

# Page-install files will have already done some ACL (for when used individually).
# For installation we're going to start fresh. The default ACL is the same in both places anyway.
TRUNCATE TABLE `acl`;

# ACL for pages
INSERT INTO `acl` (`acl_role_id`, `page_id`, `read`, `write`)
	SELECT ('1') AS `acl_role_id`, `page_id` AS `page_id`, ('1') AS `read`, ('0') AS `write`
	FROM `pages`
	UNION SELECT ('2') AS `acl_role_id`, `page_id` AS `page_id`, ('1') AS `read`, ('0') AS `write`
	FROM `pages`
	UNION SELECT ('3') AS `acl_role_id`, `page_id` AS `page_id`, ('1') AS `read`, ('1') AS `write`
	FROM `pages`;

# ACL for modules
INSERT INTO `acl` (`acl_role_id`, `module_instance_id`, `read`, `write`)
	SELECT ('1') AS `acl_role_id`, `module_instance_id` AS `module_instance_id`, ('1') AS `read`, ('0') AS `write`
	FROM `module_instances`
	UNION SELECT ('2') AS `acl_role_id`, `module_instance_id` AS `module_instance_id`, ('1') AS `read`, ('0') AS `write`
	FROM `module_instances`
	UNION SELECT ('3') AS `acl_role_id`, `module_instance_id` AS `module_instance_id`, ('1') AS `read`, ('1') AS `write`
	FROM `module_instances`;

# ACL for menu items
INSERT INTO `acl` (`acl_role_id`, `menu_item_id`, `read`, `write`)
	SELECT ('1') AS `acl_role_id`, `menu_item_id` AS `menu_item_id`, ('1') AS `read`, ('0') AS `write`
	FROM `menu_items`
	UNION SELECT ('2') AS `acl_role_id`, `menu_item_id` AS `menu_item_id`, ('1') AS `read`, ('0') AS `write`
	FROM `menu_items`
	UNION SELECT ('3') AS `acl_role_id`, `menu_item_id` AS `menu_item_id`, ('1') AS `read`, ('1') AS `write`
	FROM `menu_items`;
